<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header modal-primary no-print">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
            <button type="button" class="close mr10" onclick="window.print();"><i class="fa fa-print"></i></button>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="">
                        <div>
                            <tr>
                                <td><h4 style="text-align:center;"><?= $store->name; ?></h4></td>
                            </tr>
                            <tr>
                                <td>
                                <?php
                                    echo '<p>' . lang('customer') . ' : ' . $customer->name . '</p>';
                                    echo '<p>' . lang('phone') . ' : ' . $customer->phone . '</p>';
                                    echo '<p>' . lang('date') . ' : ' . date('d-m-Y',now()) . '</p>';
                                ?>
                                </td>
                            </tr>
                        </div>
                            <table width="100%" class="table table-bordered" style="margin-bottom:0;">
                                <thead>
                                    <tr class="active">
                                        <th><?= lang('no'); ?></th>
                                        <th><?= lang('date'); ?></th>
                                        <th><?= lang('sale_no_ref'); ?></th>
                                        <th><?= lang('amount'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if ($due_invoices) {
                                        $counter = 1;
                                        $total_due = 0;
                                        foreach ($due_invoices as $invoice) {
                                            echo '<tr>';
                                            echo '<td class="text-center">' . $counter . '</td>';
                                            echo '<td class="text-center">'.  date('d-m-Y',strtotime($invoice->date)) .'</td>';
                                            echo '<td class="text-center">' . str_pad($invoice->inv_number, 8, '0', STR_PAD_LEFT) . '</td>';
                                            echo '<td class="text-right">' . $this->tec->formatMoney($invoice->balance) . '</td>';
                                            echo '</tr>';
                                            $counter ++;
                                            $total_due += $invoice->balance;
                                        }
                                    }
                                    ?>
                                </tbody>  
                                <thead>
                                    <tr style="font-size:14px;">
                                        <td colspan='3' class='text-center'><strong><?= lang('total'); ?></strong></td>
                                        <td class='text-right'><strong><?= $this->tec->formatMoney($total_due); ?></strong></td>
                                    </tr>
                                </thead>                              
                            </table>
                            <table width="100%" style="margin-top:20px;">	
                                    <tr>
                                        <td width="50%" style="text-align:center;">Customer's Signature</td>
                                        <td style="text-align:center;">Seller's Signature</td>
                                    </tr>                                    
                            </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style type="text/css" media="all">
    @page {
            margin: 5px;
        }
    @media print {
        
        .no-print { display: none; }
        .modal-dialog, .modal-content .modal-body{margin: 0; margin-left:0.5%;}
        tr {font-size: 14px;} 
        hr {margin-top: 5px; margin-bottom:5px;}
        table.table-bordered tr, table.table-bordered td, table.table-bordered th {border: 1px solid #000!important;}
        .modal-title{font-size: 14px; margin: 10px;}
        h4 {font-size: 20px!important;}
        body { 
							color: #000; 
							font-family: "Battambang", "Khmer OS Battambang";
							font-size: 14px;
							line-height: 1;
							margin: 0px;
                            padding-right: 0 !important;
						}						
    }
</style>