<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <p><?= lang('review_report'); ?></p>
                </div>
                <div class="box-body">
                    <div class="col-sm-12">
                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box bg-aqua">
                                    <span class="info-box-icon"><i class="fa fa-shopping-cart"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?= lang('sales_value'); ?></span>
                                        <? $total_sales_exc = $Settings->exchange_rate_multiply == '*'? ($total_sales->total_amount-$total_sales->tax) * $Settings->exchange_rate : ($total_sales->total_amount-$total_sales->tax) / $Settings->exchange_rate  ?>
                                        <span class="info-box-number"><?= $Settings->exchange_rate > 0 ? $this->tec->formatMoney($total_sales->total_amount-$total_sales->tax) . ' (' . $this->tec->formatMoneyExc($total_sales_exc,$Settings->exchange_rate_symbol) . ')' : $this->tec->formatMoney($total_sales->total_amount)?></span>
                                        <div class="progress">
                                            <div style="width: 100%" class="progress-bar"></div>
                                        </div>
                                        <span class="progress-description">
                                            <?= $total_sales->total .' ' . lang('sales'); ?> |
                                            <?= $this->tec->formatMoney($total_sales->paid) . ' ' . lang('received') ?> |
                                            <?= $this->tec->formatMoney($total_sales->tax) . ' ' . lang('tax') ?>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box bg-yellow">
                                    <span class="info-box-icon"><i class="fa fa-minus"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?= lang('cost'); ?></span>
                                        <? $total_cost_exc = $Settings->exchange_rate_multiply == '*'? $total_cost->total_amount * $Settings->exchange_rate : $total_cost->total_amount / $Settings->exchange_rate  ?>
                                        <span class="info-box-number"><?= $Settings->exchange_rate > 0 ? $this->tec->formatMoney($total_cost->total_amount) . ' (' . $this->tec->formatMoneyExc($total_cost_exc,$Settings->exchange_rate_symbol) . ')' : $this->tec->formatMoney($total_cost->total_amount) ?></span>
                                        <div class="progress">
                                            <div style="width: 0%" class="progress-bar"></div>
                                        </div>
                                        <span class="progress-description">
                                            <?= $total_cost->total ?> <?= lang('sales'); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box bg-red">
                                    <span class="info-box-icon"><i class="fa fa-circle-o"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?= lang('expenses_value'); ?></span>
                                        <? $total_expenses_exc = $Settings->exchange_rate_multiply == '*'? $total_expenses->total_amount * $Settings->exchange_rate : $total_expenses->total_amount / $Settings->exchange_rate  ?>
                                        <span class="info-box-number"><?= $Settings->exchange_rate > 0 ? $this->tec->formatMoney($total_expenses->total_amount) . ' (' . $this->tec->formatMoneyExc($total_expenses_exc,$Settings->exchange_rate_symbol) . ')' : $this->tec->formatMoney($total_expenses->total_amount) ?></span>
                                        <div class="progress">
                                            <div style="width: 0%" class="progress-bar"></div>
                                        </div>
                                        <span class="progress-description">
                                            <?= $total_expenses->total ?> <?= lang('expenses'); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="info-box bg-green">
                                    <span class="info-box-icon"><i class="fa fa-dollar"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text"><?= lang('profit_loss'); ?></span>
                                        <? $total_profitloss_exc = $Settings->exchange_rate_multiply == '*'? ($total_sales->total_amount-$total_sales->tax-$total_cost->total_amount-$total_expenses->total_amount) * $Settings->exchange_rate : ($total_sales->total_amount-$total_sales->tax-$total_cost->total_amount-$total_expenses->total_amount) / $Settings->exchange_rate  ?>
                                        <span class="info-box-number"><?= $Settings->exchange_rate > 0 ? $this->tec->formatMoney($total_sales->total_amount-$total_sales->tax-$total_cost->total_amount-$total_expenses->total_amount) . ' (' . $this->tec->formatMoneyExc($total_profitloss_exc,$Settings->exchange_rate_symbol) . ')' : $this->tec->formatMoney($total_sales->total_amount-$total_sales->tax-$total_cost->total_amount-$total_expenses->total_amount)?></span>
                                        <div class="progress">
                                            <div style="width: 100%" class="progress-bar"></div>
                                        </div>
                                        <span class="progress-description">
                                            <?= $total_sales->total_amount-$total_sales->tax.' - '.($total_cost->total_amount ? $total_cost->total_amount : 0).' - '.($total_expenses->total_amount ? $total_expenses->total_amount : 0); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="calendar table-responsive">
                            <?=$calender?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
