<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        function ptype(x) {
            if (x == 'standard') {
                return '<?= lang('standard'); ?>';
            } else if (x == 'combo') {
                return '<?= lang('combo'); ?>';
            } else if (x == 'service') {
                return '<?= lang('service'); ?>';
            } else {
                return x;
            }
        }
        function image(n) {
            if (n !== null) {
                return '<div style="width:32px; margin: 0 auto;"><a href="<?=base_url();?>uploads/'+n+'" class="open-image"><img src="<?=base_url();?>uploads/thumbs/'+n+'" alt="" class="img-responsive"></a></div>';
            }
            return '';
        }
        function method(n) {
            return (n == 0) ? '<span class="label label-primary"><?= lang('inclusive'); ?></span>' : '<span class="label label-warning"><?= lang('exclusive'); ?></span>';
        }
        var table = $('#fileData').DataTable({
            'ajax' : { url: '<?=site_url('reports/get_alertsservice/'. $v);?>', type: 'POST', "data": function ( d ) {
                d.<?=$this->security->get_csrf_token_name();?> = "<?=$this->security->get_csrf_hash()?>";
            }},
            "buttons": [
                { extend: 'copyHtml5', 'footer': true, exportOptions: { columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ] } },
            { extend: 'excelHtml5', 'footer': true, exportOptions: { columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ] } },
            { extend: 'csvHtml5', 'footer': true, exportOptions: { columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ] } },
            { extend: 'pdfHtml5', orientation: 'landscape', pageSize: 'A4', 'footer': true,
            exportOptions: { columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8 ] } },
            { extend: 'colvis', text: 'Columns'},
            ],
            "columns": [
            { "data": "inv_number"},
            { "data": "date", "render": hrld },
            { "data": "product_code" },
            { "data": "product_name" },
            { "data": "customer_name"},
            { "data": "customer_phone"},
            { "data": "next_service_date"},
            { "data": "quantity" },
            <?php if ($Settings->show_unit) { ?>
            { "data": "unit" },
            <?php } else { ?>
            { "data": "unit", "visible": false },    
            <?php } ?>
            { "data": "subtotal", "searchable": false, "render": currencyFormat },
            { "data": "Actions", "searchable": false, "orderable": false }
            ]

        });

        $('#fileData').on('click', '.open-image', function() {
            var a_href = $(this).attr('href');
            $('#product_image').attr('src',a_href);
            $('#picModal').modal();
            return false;
        });

        

    });

</script>
<style type="text/css">
    .table td:first-child { padding: 1px; }
    .table td:nth-child(6), .table td:nth-child(7), .table td:nth-child(8), .table td:nth-child(9) { text-align: center; }
    .table td:nth-child(10), .table td:nth-child(11) { text-align: right; }
</style>
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('list_results'); ?></h3>
                </div>
                <div class="box-body">
                        <div class="table-responsive">
                        <table id="fileData" class="table table-striped table-bordered table-hover" style="margin-bottom:5px;">
                            <thead>
                            <tr class="active">
                                            <th style="max-width:30px;"><?= lang("sale_no_ref"); ?></th>
                                            <th class="col-xs-2"><?= lang("date"); ?></th>
                                            <th class="col-xs-1"><?= lang("code"); ?></th>
                                            <th><?= lang("product"); ?></th>
                                            <th class="col-xs-1"><?= lang("customer"); ?></th>
                                            <th class="col-xs-1"><?= lang("phone"); ?></th>
                                            <th class="col-xs-1"><?= lang("service_date"); ?></th>
                                            <th class="col-xs-1"><?= lang("qty"); ?></th>
                                            <th class="col-xs-1"><?= lang("unit"); ?></th>
                                            <th class="col-xs-1"><?= lang("subtotal"); ?></th>
                                            <th style="width:35px;"><?= lang("actions"); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="11" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
</section>
