<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<?php
if ($modal) {
    ?>
    <div class="modal-dialog" role="document"<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <?php
            } else {
                ?><!doctype html>
                <html<?= $Settings->rtl ? ' dir="rtl"' : ''; ?>>
                <head>
                    <meta charset="utf-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                    <title><?= $page_title . " " . lang("no") . " " . $inv->id; ?></title>
                    <base href="<?= base_url() ?>"/>
                    <meta http-equiv="cache-control" content="max-age=0"/>
                    <meta http-equiv="cache-control" content="no-cache"/>
                    <meta http-equiv="expires" content="0"/>
                    <meta http-equiv="pragma" content="no-cache"/>
                    <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
                    <link rel="preconnect" href="https://fonts.googleapis.com">
                    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
                    <link href="https://fonts.googleapis.com/css2?family=Battambang&display=swap" rel="stylesheet">                    
                    <script src="<?= $assets ?>dist/js/print.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/html2canvas.min.js" type="text/javascript"></script>
                    <style type="text/css" media="all">
                        @page {
                            <? echo $Settings->pos_printer_margin ? 'margin: 2px 35px 2px 2px;' : 'margin: 2px 15px;'; ?>
                        }
                        * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ }
                        body { 
							color: #000; 
							font-family: "Battambang", "Khmer OS Battambang";
							font-size: <?= $Settings->receipt_font_size .'px';?>;
							line-height: 1.42857143;
							margin: 0 5px;
						}
						p {
							margin:5px 0;
						}
						.text-right {
							text-align: right;
                            padding-right: 10px !important;
						}
                        #wrapper { max-width: 480px; margin: 0 auto; padding-top: 20px; }
                        .btn { margin-bottom: 5px; }
                        .table { border-radius: 3px; width:100%; border-collapse: collapse; margin-top:10px; margin-bottom:-10px;}
                        thead.mythead, tr.mythead {color:#000; }
                        tr.mythead, tr.mytotal {color:#fff !important; background-color:#000;}
                        tr.mythead th, tr.mytotal th {color:#fff !important;}
                        tr.mytotal th {font-size: <?= $Settings->receipt_font_size+2 .'px';?>;}
                        tr.mythead th.text-right {padding-right:10px !important;}
						thead.mythead th { padding:10px 0; color:#fff !important;}
						tfoot.mytfoot { border-top: 1px solid #000;}
                        .table th, .table td { vertical-align: middle !important; padding:5px; border-top:1px solid;}
                        h3 { margin: 5px 0; }
						a {
							text-decoration: none;
							color: #fff;
						}
						.btn-primary {
							background-color: #3c8dbc;
							border-color: #367fa9;
						}
						.btn-success {
							background-color: #00a65a;
							border-color: #008d4c;
						}
						.btn-warning {
							background-color: #f39c12;
							border-color: #e08e0b;
						}
						.btn-block {
							display: block;
							width: 100%;
						}
						.btn-primary {
							color: #fff;
						}
						.btn {
							border-radius: 3px;
                            font-family: "Battambang", "Khmer OS Battambang";
							margin-bottom: 5px;
							-webkit-box-shadow: none;
							box-shadow: none;
							border: 0px solid transparent;
							display: inline-block;
							padding: 6px 0;
							margin-bottom: 0;
							font-size: 14px;
							font-weight: 400;
							line-height: 1.42857143;
							text-align: center;
							white-space: nowrap;
							-ms-touch-action: manipulation;
							touch-action: manipulation;
							cursor: pointer;
							-webkit-user-select: none;
							-moz-user-select: none;
							-ms-user-select: none;
							user-select: none;
							margin-bottom: 5px;
						}
						.well-sm {
							padding: 5px;
							border-radius: 3px;
						}
						.well {
							min-height: 20px;
							border: 1px solid #000;
							border-radius: 4px;
							-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
							box-shadow: inset 0 1px 1px rgba(0,0,0,.05);
						}
						.alert-success {
							background-color: #00a65a!important;
							border-color: #008d4c!important;
						}
						.alert, .callout {
							border-radius: 3px;
						}
						.alert {
							padding: 15px;
							border: 1px solid transparent;
						}
						.alert, .thumbnail {
							margin-bottom: 20px;
						}
						.alert .close {
							color: #000;
							opacity: .2;
							filter: alpha(opacity=20);
						}
						button.close {
							-webkit-appearance: none;
							padding: 0;
							cursor: pointer;
							background: 0 0;
							border: 0;
						}
						.close {
							float: right;
							font-size: 21px;
							line-height: 1;
							color: #000;
							text-shadow: 0 1px 0 #fff;
							filter: alpha(opacity=20);
							opacity: .2;
						}
                        a[href^=tel] {
                            color: inherit;
                            text-decoration: none;
                        }
						.alert .alert-link, .close {
							font-weight: 700;
						}
                        @media only screen and (max-device-width: 480px) {
                            #wrapper {
                                max-width: 100% !important;
                                margin: 0 auto;
                                padding-top: 10px;
                            }
                            div#receiptData {
                                max-width: 100% !important;
                                margin: 0 auto;
                                padding : 10px;
                            }
                        }
                        @media print {
                            .no-print { display: none; }
                            #wrapper { max-width: 700px; min-width: 250px; margin: 0 auto; padding-top:0 !important;}	
                            div#receipt-data {padding-right:0 !important;}							
                        }
                        <?php if($Settings->rtl) { ?>
                            .text-right { text-align: left; }
                            .text-left { text-align: right; }
                            tfoot tr th:first-child { text-align: left; }
                        <?php } else { ?>
                            tfoot tr th:first-child { text-align: right; }
                        <?php } ?>
                    </style>
                </head>
                <body>
                    <?php
                }
                ?>
                <div id="wrapper">
                    <div id="receiptData" style="width: auto; max-width: 700px; margin: 0 auto;">
                        <div class="no-print">
                            <span class="col-xs-12">
                                <a class="btn btn-block btn-warning" style="padding-top:20px; padding-bottom:20px; font-size:20px;" href="<?= site_url('pos'); ?>"><?= lang("back_to_pos"); ?></a>
                                <?php //echo '<a href="'.site_url('pos/view/'.$inv->id.'/0').'" id="print80mm" class="btn btn-block btn-primary">'.lang("print").' 80mm</a>'; ?>
                                <?php //echo '<a href="'.site_url('pos/view/'.$inv->id.'/2').'" id="printA4" class="btn btn-block btn-primary">'.lang("print").' A4/A5</a>'; ?>
                            </span>
                        </div>
                        <div id="receipt-data" style="padding-right:10px;">
                            <div>
                                <div style="text-align:center;">
                                    <?php
                                    if ($store) {
                                        if (!empty($store->logo)) {
										echo '<img src="'.base_url('uploads/'.$store->logo).'" height="80px" alt="'.$store->name.'">';										
                                        echo '<p style="text-align:center; font-size:11px;">';
                                        } else {
                                        $font_size = $Settings->receipt_font_size + 5;
                                        echo '<p style="text-align:center; font-size:'. $font_size .'px;">';                                           
                                        }    
                                        echo '<strong>' . nl2br($store->name) . '</strong><br></p>';                                                                   
                                        echo '<p>'.$store->address1.'<br>'.$store->address2;
                                        echo $store->city.'<br>'.$store->phone;
                                        echo '<br>'.nl2br($store->receipt_header).'</p>';
                                    }                                    
                                    ?>
                                    <?php
                                    if($Settings->show_waiting_number){
                                    echo '<p style="margin:0;">'. lang('waiting_number') .':</p>';
                                    echo '<p style="margin:0; font-size:20px; font-weight:bold;">'.$inv->waiting_number.'</p>';
                                    }
                                    ?>
                                </div>
                                <table width="100%">
                                    <? if (($Settings->show_date_inout) && ($inv->date_in != '')) { ?>
                                        <?
                                            $hour = (abs(strtotime($inv->date_out) - strtotime($inv->date_in))/3600)%24;
                                            $minute = (abs(strtotime($inv->date_out) - strtotime($inv->date_in))/60)%60;
                                        ?>
                                    <tr>
                                        <td><?= lang('date_in').':'; ?></td>
                                        <td><?= $this->tec->hrld($inv->date_in); ?></td>
                                        <td><?= lang('date_out').':'; ?></td>
                                        <td class="text-right"><?= $this->tec->hrld($inv->date_out); ?></td>
                                    </tr>
                                    <? /* 
                                    <tr>
                                        <td><?= lang('duration').':'; ?></td>
                                        <td class="text-right"><?= $hour . ' h ' . $minute . ' mn'; ?></td>
                                    </tr>
                                    */ ?>
                                    <? } ?>  
                                    <? if ($Settings->exchange_rate>0) { ?>                                  
                                    <tr>
                                        <td><?= lang('rate').':'; ?></td>
                                        <? if ($Settings->exchange_rate_multiply == '*') { ?>
                                        <td><?= $this->tec->formatMoney(1,0) . ' = ' . $this->tec->formatMoneyExc($Settings->exchange_rate,$Settings->exchange_rate_symbol,0); ?></td>
                                        <? } else { ?>
                                        <td><?= $this->tec->formatMoneyExc(1,$Settings->exchange_rate_symbol,0) . ' = ' . $this->tec->formatMoney($Settings->exchange_rate,0); ?></td>
                                        <? } ?>
                                        <td><?= lang('date').':'; ?></td>
                                        <td class="text-right"><?= date('d-m-Y',strtotime($inv->date)); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?= lang('sales_person').':'; ?></td>
                                        <td><?= $created_by->first_name." ".$created_by->last_name; ?></td>
                                        <td><?= lang('sale_no_ref').':'; ?></td>
                                        <td class="text-right"><?= str_pad($inv->inv_number, 8, '0', STR_PAD_LEFT); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?= lang('customer').':'; ?></td>
                                        <td><?= $inv->customer_name; ?></td>
                                        <? if ($customer->phone != '') { ?>
                                        <td><?= lang('phone').':'; ?></td>                                        
                                        <td class="text-right"><?= $customer->phone; ?></td>
                                        <? } ?>
                                    </tr>
                                    <? if ($customer->cf1 != '') { ?>
                                    <tr>
                                        <td><?= lang('ccf1').':'; ?></td>                                        
                                        <td class="" colspan="3"><?= $customer->cf1; ?></td>
                                    </tr>
                                    <? } ?>    
                                    <? } else { ?>
                                    <tr>
                                        <td><?= lang('customer').':'; ?></td>
                                        <td><?= $inv->customer_name; ?></td>
                                        <td><?= lang('date').':'; ?></td>
                                        <td class="text-right"><?= date('d-m-Y',strtotime($inv->date)); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?= lang('sales_person').':'; ?></td>
                                        <td><?= $created_by->first_name." ".$created_by->last_name; ?></td>
                                        <td><?= lang('sale_no_ref').':'; ?></td>
                                        <td class="text-right"><?= str_pad($inv->inv_number, 8, '0', STR_PAD_LEFT); ?></td>
                                    </tr>
                                    <tr>
                                        <? if ($customer->cf1 != '') { ?>                                        
                                        <td><?= lang('ccf1').':'; ?></td>                                        
                                        <td class="" colspan="3"><?= $customer->cf1; ?></td>                                        
                                        <? } ?> 
                                        <? if ($customer->phone != '') { ?>
                                        <td><?= lang('phone').':'; ?></td>                                        
                                        <td class="text-right"><?= $customer->phone; ?></td>
                                        <? } ?>
                                    </tr>
                                       
                                    <? } ?>
                                </table>
                                <div style="clear:both;"></div>
                                <table class="table table-striped table-condensed" style="margin-top: 5px !important;">
                                    <thead class="mythead">
                                        <tr class="mythead">
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('inv_no');?></th>
                                            <th class="text-center" style="width: 35%; border-bottom: 1px solid;"><?=lang('inv_description');?></th>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('inv_quantity');?></th>
                                            <? if ($Settings->show_unit) { ?>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('inv_unit');?></th>
                                            <? } ?>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('inv_price');?></th>
                                            <? if ($inv->product_discount > 0) { ?>
                                            <th class="text-center" style="border-bottom: 1px solid;"><?=lang('inv_disc');?></th>
                                            <? } ?>
                                            <th class="text-right" style="border-bottom: 1px solid;"><?=lang('inv_subtotal');?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="mytbody">
                                        <?php
                                        $tax_summary = array();
                                        $counter = 1;
                                        $beverage_discount = 0;
                                        foreach ($rows as $row) {
                                            echo '<tr>
													<td style="text-align:center;">'. $counter . '</td>
													<td>' . $row->product_name . '<br><small>' . $row->comment . '</small></td>';
                                            echo '<td style="text-align:center;">' . $this->tec->formatQuantity($row->quantity) . '</td>';
                                            if ($Settings->show_unit) {
                                            echo '<td style="text-align:center;">' . $row->unit . '</td>';
                                            }
                                            echo '<td class="text-right">';
                                            if ($inv->product_discount > 0) {
                                            echo $this->tec->formatMoney($row->real_unit_price) . '</td><td class="text-right">' . (! is_numeric($row->discount) ? $row->discount : $this->tec->formatMoney($row->item_discount)) . '</td><td class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>';
                                            } else {
                                            echo $this->tec->formatMoney($row->net_unit_price + ($row->item_tax / $row->quantity)) . '</td><td class="text-right">' . $this->tec->formatMoney($row->subtotal) . '</td></tr>';           
                                            }    
                                            $counter ++;
                                            if($row->beverage == 1){$beverage_discount = $beverage_discount + $row->item_discount;}                             
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                <table class="table table-striped table-condensed" style="margin-bottom:3px;">
                                        <tr>
                                            <th><?= lang("total"); ?></th>
											
											
											<th class="text-right"><?= $this->tec->formatQuantity( $inv->total_items); ?> (<?= $this->tec->formatQuantity( $inv->total_quantity); ?>)</th>
											
											
                                            <? if ($inv->product_discount !=0) { ?>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->total + $inv->product_discount + $inv->product_tax); ?></th>
                                            <? } else { ?>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->total + $inv->product_tax); ?></th>
                                            <? } ?>
                                        </tr>
                                        <?php
                                        if ($inv->total_discount != 0) {
                                            if ($inv->order_discount_id != 0) {
                                                echo '<tr><th>' . lang("order_discount") . '</th><th class="text-right">(' . $inv->order_discount_id . ')</th><th class="text-right">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
                                            } else {
                                                //echo '<tr><th class="text-right">' . lang("bevarage_discount") . '</th><th class="text-right"></th><th class="text-right">' . $this->tec->formatMoney($beverage_discount) . '</th></tr>';
                                                //echo '<tr><th class="text-right">' . lang("food_discount") . '</th><th class="text-right"></th><th class="text-right">' . $this->tec->formatMoney($inv->total_discount - $beverage_discount) . '</th></tr>';
                                                echo '<tr><th>' . lang("order_discount") . '</th><th class="text-right"></th><th class="text-right">' . $this->tec->formatMoney($inv->total_discount) . '</th></tr>';
                                            }
                                        }
                                        if ($inv->order_tax != 0) {
                                            echo '<tr><th>' . lang("order_tax") . '</th><th class="text-right">(' . $inv->order_tax_id . ')</th><th class="text-right">' . $this->tec->formatMoney($inv->order_tax) . '</th></tr>';
                                        }
                                        if ($Settings->show_inclusive_tax) {
                                            echo '<tr><th>' . lang("tax") . '</th><th></th><th class="text-right">' . $this->tec->formatMoney($inv->product_tax) . '</th></tr>';
                                        }
                                        

                                        if ($Settings->rounding) {
                                            $round_total = $this->tec->roundNumber($inv->grand_total, $Settings->rounding);
                                            $rounding = $this->tec->formatDecimal($round_total - $inv->grand_total);
                                            ?>
                                            <tr>
                                                <th colspan="2" class="text-right"><?= lang("rounding"); ?> (<?=$Settings->symbol?>)</th>
                                                <th class="text-right"><?= $this->tec->formatMoney($rounding); ?></th>
                                            </tr>
                                            <tr class="mytotal">
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?></th>
                                                <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total + $rounding); ?></th>
                                            </tr>
											<?php if ($Settings->exchange_rate > 0) { ?>
                                            <?php 
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    $grand_total_local_currency = ($inv->grand_total + $rounding) * $Settings->exchange_rate;
                                                }
                                                else{
                                                    $grand_total_local_currency = ($inv->grand_total + $rounding) / $Settings->exchange_rate;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency,$Settings->exchange_rate_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
											<?php if ($Settings->exchange_rate2 > 0) { ?>
                                                <?php 
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    $grand_total_local_currency2 = ($inv->grand_total + $rounding) * $Settings->exchange_rate2;
                                                }
                                                else{
                                                    $grand_total_local_currency2 = ($inv->grand_total + $rounding) / $Settings->exchange_rate2;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate2_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency2,$Settings->exchange_rate2_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
                                            <?php
                                        } else {
                                            $round_total = $inv->grand_total;
                                            ?>
                                            <tr class="mytotal">
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->symbol?>)</th>
                                                <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total); ?></th>
                                            </tr>
											<?php if ($Settings->exchange_rate > 0) { ?>
                                            <?php 
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    $grand_total_local_currency = $inv->grand_total * $Settings->exchange_rate;
                                                }
                                                else{
                                                    $grand_total_local_currency = $inv->grand_total / $Settings->exchange_rate;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate_symbol?>)</th>
                                                <th class="text-right"><?= $grand_total_local_currency,$Settings->exchange_rate_symbol; ?></th>
												
                                            </tr>
											<?php } ?>
											<?php if ($Settings->exchange_rate2 > 0) { ?>
                                                <?php 
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    $grand_total_local_currency2 = $inv->grand_total * $Settings->exchange_rate2;
                                                }
                                                else{
                                                    $grand_total_local_currency2 = $inv->grand_total / $Settings->exchange_rate2;
                                                }                                              
                                            ?>
											<tr>
                                                <th colspan="2" class="text-right"><?= lang("grand_total"); ?> (<?=$Settings->exchange_rate2_symbol?>)</th>
                                                <th class="text-right"><?=$this->tec->formatMoneyExc($grand_total_local_currency2,$Settings->exchange_rate2_symbol); ?></th>
												
                                            </tr>
											<?php } ?>
                                            <?php
                                        }
                                        if ($inv->paid < $round_total || ($total_sales->amount-$total_sales->paid) - ($inv->grand_total - $inv->paid)>0) { ?>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("paid_amount"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->paid); ?></th>
                                        </tr>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("due_amount"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney($inv->grand_total - $inv->paid); ?></th>
                                        </tr>
                                        <?php if ($Settings->show_previous_due) { ?>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("previous_due"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney(($total_sales->amount-$total_sales->paid) - ($inv->grand_total - $inv->paid)); ?></th>
                                        </tr>
                                        <tr>
                                            <th colspan="2" class="text-right"><?= lang("total_due"); ?></th>
                                            <th class="text-right"><?= $this->tec->formatMoney($total_sales->amount-$total_sales->paid); ?></th>
                                        </tr>
                                        <?php } ?>
                                        <?php } ?>
                                    
                                </table>
                                
                                <?php
                                /*
                                //Summary by Subtotal Category
                                echo '<table class="well well-sm" style="margin-top:1px; margin-bottom:5px; margin-left:3px; width:50%;"><tbody>';
                                foreach ($summary_categories as $summary_category) {
                                    if ($Settings->exchange_rate > 0) {
                                        if ($Settings->exchange_rate_multiply == '*') {
                                            $subtotal_currency = $summary_category->subtotal * $Settings->exchange_rate;
                                        }
                                        else{
                                            $subtotal_currency = $summary_category->subtotal / $Settings->exchange_rate;
                                        }
                                    }     
                                    echo '<tr>';
                                    echo '<td>' . $summary_category->name . '</td>';
                                    echo '<td class="text-right">' . $this->tec->formatMoney($summary_category->subtotal) . ' (' . $this->tec->formatMoneyExc($subtotal_currency,$Settings->exchange_rate_symbol) . ')</td>';
                                    echo '</tr>';
                                }
                                echo '<tbody></table>';
                                */
                                ?>

                                <?php
                                
								if ($payments) { 
                                    
									foreach ($payments as $payment) {
                                        echo '<table class="well well-sm" style="margin-top:1px; margin-left:3px; width:97%;"><tbody>';
                                        echo '<tr>';
                                        //if ($payment->paid_by == 'cash' && $payment->pos_paid) {
                                        if ($payment->amount) {
                                            $paidby_rowspan = 2;
                                            if ($Settings->exchange_rate>0) { $paidby_rowspan += 2; }
                                            if ($Settings->exchange_rate2>0) { $paidby_rowspan += 2; }
                                            if ($payment->paid_by == 'cash') {
                                                echo '<th rowspan="'. $paidby_rowspan . '"' . ' style="text-align:left;" width="30%">' . lang("paid_by") . ':<br>' . lang($payment->paid_by) . '</th>';
                                            } else if ($payment->paid_by == 'other') {
                                                echo '<th rowspan="'. $paidby_rowspan . '"' . ' style="text-align:left;" width="30%">' . lang("paid_by") . ':<br>' . lang('other_sale') . '</th>';
                                            } else {
                                                echo '<th rowspan="2" style="text-align:left;" width="30%">' . lang("paid_by") . ':<br>' . lang($payment->paid_by) . '</th>';   
                                            }
                                            echo '<th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->symbol .'): </th>';
                                            if ($Settings->show_exc_paid){
                                                echo '<th class="text-right" width="30%">' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid_main) . '</th></tr>';
                                            } else {
                                                echo '<th class="text-right" width="30%">' . $this->tec->formatMoney($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid) . '</th></tr>';
                                            }                                            
                                            if ($Settings->exchange_rate>0) {												
                                                echo '<tr><th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                if ($Settings->show_exc_paid){
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoneyExc($payment->pos_paid_exc,$Settings->exchange_rate_symbol) . '</th></tr>';
                                                } else {
                                                    if ($Settings->exchange_rate_multiply == '*') {
                                                        echo '<th class="text-right" width="30%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid * $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';	
                                                    }else{
                                                        echo '<th class="text-right" width="30%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid / $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';
                                                    } 
                                                }                                               
                                            }
                                            if ($Settings->exchange_rate2>0) {												
                                                echo '<tr><th colspan="2" class="text-right">' . lang("amount") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                if ($Settings->show_exc_paid){
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoneyExc($payment->pos_paid_exc2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                } else {
                                                    if ($Settings->exchange_rate2_multiply == '*') {
                                                        echo '<th class="text-right" width="30%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid * $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';	
                                                     }else{
                                                        echo '<th class="text-right" width="30%">'. $this->tec->formatMoneyExc($payment->pos_paid == 0 ? $payment->amount : $payment->pos_paid / $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                    }
                                                }                                                    
                                            }
                                            //echo '</tbody></table>';
                                            //echo '<table class="well well-sm" style="margin-top:3px; margin-left:3px; width:97%;"><tbody>';
                                            if ($payment->paid_by == 'cash') {	
											echo '<tr><th colspan="2" class="text-right" style="border-top:1px dotted;">' . lang("change") . ' ('. $Settings->symbol .'): </th>';
                                            echo '<th class="text-right" width="30%" style="border-top:1px dotted;">' . ($payment->pos_balance > 0 ? $this->tec->formatMoney($payment->pos_balance) : $this->tec->formatMoney(0)) . '</th></tr>';
                                            }
                                            if ($payment->paid_by == 'cash' && $Settings->exchange_rate>0) {
											    echo '<tr><th colspan="2" class="text-right">' . lang("change") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                if ($Settings->exchange_rate_multiply == '*') {
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoneyExc(($payment->pos_balance > 0 ? $payment->pos_balance : 0) * $Settings->exchange_rate,$Settings->exchange_rate_symbol) . '</th></tr>';												
                                                }else{
                                                    echo '<th class="text-right" width="30%">' . ($payment->pos_balance > 0 ? $payment->pos_balance : 0)  / $Settings->exchange_rate,$Settings->exchange_rate_symbol . '</th></tr>';
                                                }
                                            }
                                            if ($payment->paid_by == 'cash' && $Settings->exchange_rate2>0) {	
											    echo '<tr><th colspan="2" class="text-right">' . lang("change") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                if ($Settings->exchange_rate2_multiply == '*') {
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoneyExc(($payment->pos_balance > 0 ? $payment->pos_balance : 0)  * $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';												
                                                }else{
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoneyExc(($payment->pos_balance > 0 ? $payment->pos_balance : 0)  / $Settings->exchange_rate2,$Settings->exchange_rate2_symbol) . '</th></tr>';
                                                }
                                            }
                                            if ($Settings->show_changedecimal){
                                                echo '</tbody></table>';
                                                echo '<table class="well well-sm" style="margin-top:3px; margin-left:3px; width:97%;"><tbody>';
                                                if ($Settings->exchange_rate>0) {	
                                                    echo '<tr><th colspan="2" class="text-right">' . lang("change_decimal") . ' ('. $Settings->exchange_rate_symbol .'): </th>';
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoney($payment->pos_balance-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0))) . ' = ' . (((($payment->pos_balance > 0 ? $payment->pos_balance : 0)-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0)))*$Settings->exchange_rate) > 0 ? $this->tec->formatMoneyExc((($payment->pos_balance > 0 ? $payment->pos_balance : 0)-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0)))*$Settings->exchange_rate,$Settings->exchange_rate_symbol) : 0) . '</th></tr>';											
                                                }
                                                if ($Settings->exchange_rate2>0) {	
                                                    echo '<tr><th colspan="2" class="text-right">' . lang("change_decimal") . ' ('. $Settings->exchange_rate2_symbol .'): </th>';
                                                    echo '<th class="text-right" width="30%">' . $this->tec->formatMoney($payment->pos_balance-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0))) . ' = ' . (((($payment->pos_balance > 0 ? $payment->pos_balance : 0)-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0)))*$Settings->exchange_rate2) > 0 ? $this->tec->formatMoneyExc((($payment->pos_balance > 0 ? $payment->pos_balance : 0)-floor(($payment->pos_balance > 0 ? $payment->pos_balance : 0)))*$Settings->exchange_rate2,$Settings->exchange_rate2_symbol) : 0) . '</th></tr>';											
                                                }
                                            }                                            
                                        }
                                        echo '</tbody></table>';
                                        
                                    }
                                }

                                ?>							

                                <?= $inv->note ? '<p style="margin-top:5px; text-align: center;">' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
                                <?php if (!empty($store->receipt_footer)) { ?>
                                <div class="well-sm"  style="margin-top:5px;">                                    
                                    <div style="text-align: center;"><?= nl2br($store->receipt_footer); ?></div>
                                </div>
                                <?php } ?>
                                <? if ($Settings->each_spent > 0) { ?>
                                <div class="well-sm" >                                    
                                    <div style="text-align: center;"><?= lang('award_points') .' : ' . floor($customer->award_points); ?></div>
                                </div>
                                <? } ?>
                                <? /* show QR image
                                <div style="text-align:center;">
                                    <?= '<img src="'.base_url('uploads/'.$store->promotion_photo).'" alt="'.$store->name.'" height="120px">'; ?>
                                </div>
                                */ ?>
                                <? if ($Settings->show_refbarcode == 2 || $Settings->show_refbarcode == 3 ) { ?>
                                <div id="barcode" style="text-align:center;"><?= $saleid_barcode ?></div>
                                <? } ?>                                
                                <?/* if ($aba_qrcode) { ?>
                                <div id="qrcode" style="text-align:center;">
                                    <p style="margin:0;"><?= lang('scan_aba');?></p>
                                    <?= $aba_qrcode; ?>                                    
                                </div>
                                <? } */?>
                                <? if ($store->aba_qrstring || $store->acleda_qrstring) { ?>
                                <div id="qrcode" style="text-align:center;">
                                    <table width="100%">
                                        <tr>
                                            <? if($store->aba_qrstring) {
                                                echo '<td>ABA</td>';
                                            } ?>
                                            <? if($store->acleda_qrstring) {
                                                echo '<td>ACLEDA</td>';
                                            } ?>
                                        </tr>
                                        <tr>
                                        <? if($store->aba_qrstring) {
                                                echo '<td>' . $aba_qrstring . '</td>';
                                            } ?>
                                            <? if($store->acleda_qrstring) {
                                                echo '<td>' . $acleda_qrstring . '</td>';
                                            } ?>
                                        </tr>
                                    </table>                                   
                                </div>
                                <? } ?>
                            </div>
                            <div style="clear:both;"></div>
                        </div>

                        <!-- start -->
                        <div id="buttons" style="padding-top:10px; text-transform:uppercase;" class="no-print">
                            <hr>
                            <?php if ($modal) { ?>
                            <div class="btn-group btn-group-justified" role="group" aria-label="...">
                                <div class="btn-group" role="group">
                                    <?php
                                    if ( ! $Settings->remote_printing) {
                                        echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    } elseif ($Settings->remote_printing == 1) {
                                        echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';                                        
                                    } elseif ($Settings->remote_printing == 3) {
                                        echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';                                        
                                    } else {
                                        echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    }
                                    ?>
                                </div>
                                <div class="btn-group" role="group">
                                    <a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a>
                                </div>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
                                </div>
                            </div>
                            <?php } else { ?>
                            <span class="pull-right col-xs-12">
                                <?php
                                if ( ! $Settings->remote_printing) {
                                    echo '<a href="'.site_url('pos/print_receipt/'.$inv->id.'/1').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                    echo '<a href="'.site_url('pos/open_drawer/').'" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</a>';
                                } elseif ($Settings->remote_printing == 1) {
                                    echo '<button onclick="window.print();" class="btn btn-block btn-primary">'.lang("print").'</button>';  
                                    echo '<a href="#" id="image" class="btn btn-block btn-warning">'.lang("save_image").'</a>';                                   
                                } elseif ($Settings->remote_printing == 3) {
                                    echo '<a href="'.site_url('pos/pdf_receipt/'.$inv->id.'/0').'" id="print" class="btn btn-block btn-primary">'.lang("print").'</a>';
                                } else {
                                    echo '<button onclick="return printReceipt()" class="btn btn-block btn-primary">'.lang("print").'</button>';
                                    echo '<button onclick="return openCashDrawer()" class="btn btn-block btn-default">'.lang("open_cash_drawer").'</button>';
                                }
                                
                                ?>
                            </span>
                            <?//<span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="#" id="email"><?= lang("email"); ?></a></span>
                            <?php
                            if($Settings->print_customer_label){
                                if($Settings->remote_printing==1){
                                    echo '<button onclick="return printLabel()" class="btn btn-block btn-primary">'.lang("print").' Label</button>';
                                    //echo '<button onclick="return printLabelNoPrice()" class="btn btn-block btn-primary">'.lang("print").' Label No Price</button>';
                                }else if($Settings->remote_printing==3){
                                    echo '<a href="'.site_url('pos/label_customer/'.$inv->id).'" id="labelprint" class="btn btn-block btn-primary">'.lang("Print_Delivery_Label_60x40").'</a>'; 
                                }
                            }
                            ?>
                            <span class="pull-left col-xs-12"><a class="btn btn-block btn-success" href="<?= site_url('sales'); ?>"><?= lang("back_to_sales"); ?></a></span>							
                            <?php } ?>
                            <div style="clear:both;"></div>
                            <div id="delivery_tbl" style="overflow:hidden; max-height:0; margin: 0 auto;">
                                <!--
                                <table width="100%"> 
                                    <tr>  
                                        <td> <?= lang("name").': '. $inv->customer_name; ?> </td>								 
                                    </tr>
                                    <tr>
                                        <td><?= lang("phone").': '. $customer->phone; ?> </td>
                                    </tr>
                                    <tr>	
                                        <td><?= lang("address").': '. $customer->cf1; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?= lang("date").': '.$this->tec->hrld($inv->date); ?></td>
                                    </tr>
                                    <tr>
                                        <td> <?= lang("total").': '. $this->tec->formatMoney($inv->total); ?></td>
                                    </tr>
                                    <tr>	
                                        <td> <?= $this->tec->decode_html($inv->note); ?></td>
                                    </tr>
                                </table>
                                -->
                                <div>
                                        <table class="border-bottom" style="border-bottom: 1px solid; width:100%;">
                                        <tr>
                                            <?php
                                            if ($store) {										
                                                if (!empty($store->logo)) {
                                                echo '<td><img src="'.base_url('uploads/'.$store->logo).'" height="80px" alt="'.$store->name.'"></td>';
                                                }
                                                echo '<td><p style="font-size:14px;">'; 
                                                echo '<strong>' . nl2br($store->name) . '</strong></p>';     
                                                echo '<p class="line-height-18" style="font-size:10px;">' . lang("date").': '. date('d-m-Y',strtotime($inv->date)) . '</p>';    
                                                echo '<p class="line-height-18" style="font-size:10px;">' . lang("sale_no_ref").': '. str_pad($inv->id, 8, '0', STR_PAD_LEFT) . '</p>';                        
                                            }                                    
                                            ?>
                                        </tr>
                                        </table>
                                        
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("customer").': '. $inv->customer_name; ?>                               
                                        </p>
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("address1").': '. $customer->cf1; ?>                                  
                                        </p>
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("phone").': '. $customer->phone; ?>                                  
                                        </p>
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("grand_total") . '(' . $Settings->symbol . ')' . ': '. $this->tec->formatMoney($inv->grand_total); ?>                                  
                                        </p>
                                        <?php 
                                        if ($Settings->exchange_rate > 0) {                                             
                                            if ($Settings->exchange_rate_multiply == '*') {
                                                $grand_total_local_currency = $inv->grand_total * $Settings->exchange_rate;
                                            }
                                            else {
                                                $grand_total_local_currency = $inv->grand_total / $Settings->exchange_rate;
                                            } 
                                        }                                             
                                        ?>
                                        <p class="font-15"  style="font-size:15px;">  
                                            <?= lang("grand_total") . '(' . $Settings->exchange_rate_symbol . ')' . ': '. $this->tec->formatMoneyExc($grand_total_local_currency,$Settings->exchange_rate_symbol,0); ?>                                  
                                        </p>
                                                                    
                                        <?= $inv->note ? '<p class="font-15" style="margin-top:5px; font-size:14px;">' . lang("other") . ' : ' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
										<br>
                                        <?php if (!empty($store->receipt_footer)) { ?>
                                            <p  class="border-top" style="font-size:14px; border-top:1px solid; padding-top:5px;"><?= nl2br($store->receipt_footer); ?></p>
                                        
                                        <?php } ?>
                                        <?php /* if (!empty($store->receipt_header)) { ?>
                                            <p class="header" style="font-size:14px; text-align:center; margin-top:10px;"><?= nl2br($store->receipt_header); ?></p>
                                        
                                        <?php } */?>
                                    </div>
                            </div>
                            <div id="delivery_tbl_noprice" style="overflow:hidden; max-height:0; margin: 0 auto;">                                
                                <div>
                                        <table class="border-bottom" style="border-bottom: 1px solid; width:100%;">
                                        <tr>
                                            <?php
                                            if ($store) {										
                                                if (!empty($store->logo)) {
                                                echo '<td><img src="'.base_url('uploads/'.$store->logo).'" height="80px" alt="'.$store->name.'"></td>';
                                                }
                                                echo '<td><p style="font-size:14px;">'; 
                                                echo '<strong>' . nl2br($store->name) . '</strong></p>';     
                                                echo '<p class="line-height-18" style="font-size:10px;">' . lang("date").': '. date('d-m-Y',strtotime($inv->date)) . '</p>';    
                                                echo '<p class="line-height-18" style="font-size:10px;">' . lang("sale_no_ref").': '. str_pad($inv->id, 8, '0', STR_PAD_LEFT) . '</p>';                        
                                            }                                    
                                            ?>
                                        </tr>
                                        </table>
                                        
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("customer").': '. $inv->customer_name; ?>                               
                                        </p>
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("address1").': '. $customer->cf1; ?>                                  
                                        </p>
                                        <p class="font-15" style="font-size:15px;">  
                                            <?= lang("phone").': '. $customer->phone; ?>                                  
                                        </p>
                                                                    
                                        <?= $inv->note ? '<p class="font-15" style="margin-top:5px; font-size:14px;">' . lang("other") . ' : ' . $this->tec->decode_html($inv->note) . '</p>' : ''; ?>
										<br>
                                        <?php if (!empty($store->receipt_footer)) { ?>
                                            <p  class="border-top" style="font-size:14px; border-top:1px solid; padding-top:5px;"><?= nl2br($store->receipt_footer); ?></p>
                                        
                                        <?php } ?>
                                        <?php /* if (!empty($store->receipt_header)) { ?>
                                            <p class="header" style="font-size:14px; text-align:center; margin-top:10px;"><?= nl2br($store->receipt_header); ?></p>
                                        
                                        <?php } */?>
                                    </div>
                            </div>
                        </div>
                        <!-- end -->
                    </div>
                </div>
                <!-- start -->
                <?php
                if (!$modal) {
                    ?>
                    <script type="text/javascript">
                        var base_url = '<?=base_url();?>';
                        var site_url = '<?=site_url();?>';
                        var dateformat = '<?=$Settings->dateformat;?>', timeformat = '<?= $Settings->timeformat ?>';
                        <?php unset($Settings->protocol, $Settings->smtp_host, $Settings->smtp_user, $Settings->smtp_pass, $Settings->smtp_port, $Settings->smtp_crypto, $Settings->mailpath, $Settings->timezone, $Settings->setting_id, $Settings->default_email, $Settings->version, $Settings->stripe, $Settings->stripe_secret_key, $Settings->stripe_publishable_key); ?>
                        var Settings = <?= json_encode($Settings); ?>;
                    </script>
                    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js"></script>
                    <script src="<?= $assets ?>dist/js/libraries.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/scripts.min.js" type="text/javascript"></script>
                    <?php
                }
                ?>
                <script type="text/javascript">
                    $(document).ready(function () {                        
                        $('#print').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });
                        $('#labelprint').click(function (e) {
                            e.preventDefault();
                            var link = $(this).attr('href');
                            $.get(link);
                            return false;
                        });                        
                        $('#email').click(function () {
                            bootbox.prompt({
                                title: "<?= lang("email_address"); ?>",
                                inputType: 'email',
                                value: "<?= $customer->email; ?>",
                                callback: function (email) {
                                    if (email != null) {
                                        $.ajax({
                                            type: "post",
                                            url: "<?= site_url('pos/email_receipt') ?>",
                                            data: {<?= $this->security->get_csrf_token_name(); ?>: "<?= $this->security->get_csrf_hash(); ?>", email: email, id: <?= $inv->id; ?>},
                                            dataType: "json",
                                            success: function (data) {
                                                bootbox.alert({message: data.msg, size: 'small'});
                                            },
                                            error: function () {
                                                bootbox.alert({message: '<?= lang('ajax_request_failed'); ?>', size: 'small'});
                                                return false;
                                            }
                                        });
                                    }
                                }
                            });
                            return false;
                        });    
                        <?php if ($Settings->remote_printing != 3) {?> 
                        $('#image').click(function () {
                            window.scrollTo(0,0);
                            html2canvas(document.querySelector("#receipt-data")).then(function(canvas) {
                                var img = canvas.toDataURL();
                                var imgwindow = window.open('', 'sma_pos_img');
                                imgwindow.document.write('<html><head><title>Screenshot</title>');
                                imgwindow.document.write('<img src="' + img + '" class="img-thumbnail"/>');
                                imgwindow.document.write('</body></html>');
                            });                            
                            return false;
                        });     
                        <?php } ?>              
                    });
					<?php
					if ($Settings->auto_print == 1 && $Settings->remote_printing == 1) {
						?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
							}, 300);
							return true;      
						});
						<?php
					} else if ($Settings->auto_print == 2) {
                        ?>
						$(window).load(function () {
                            setTimeout(function() {
								window.print();  
                                document.location.href = "pos";
							}, 300);
							return true;      
						});
						<?php
                    }
                    ?>
                    function doPrint() {
                        window.print();            
                        document.location.href = "pos"; 
                    }
                    function printLabel() {
                            if (Settings.remote_printing == 1) {                                
                                printJS({
                                    printable:'delivery_tbl',
                                    type:'html',
                                    font_size: '17px;',
                                    style:'@page{margin:5px 10px 5px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:18px; line-height: 1.7;} h5{margin:5px; font-size:13px; font-weight:normal;} table{font-size:18px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid; margin-top:10px;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%; margin-top:10px;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:12px; color:#fff;} td{padding:5px;} div#qrcode{text-align:center;} .border-bottom{border-bottom: 1px solid;} .border-top{border-top: 1px solid;} p.line-height-18{line-height:2; padding-top:5px; padding-bottom:5px;} p.font-15{font-size:20px !important; line-height:2; padding-top:5px;} p.header{font-size:14px; text-align:center; margin-top:15px; padding-top:10px;}'
                                });                                                           
                            } else if (Settings.remote_printing == 3) {
                                
                            }
                    }
                    function printLabelNoPrice() {
                            if (Settings.remote_printing == 1) {                                
                                printJS({
                                    printable:'delivery_tbl_noprice',
                                    type:'html',
                                    font_size: '17px;',
                                    style:'@page{margin:5px 10px 5px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:18px; line-height: 1.7;} h5{margin:5px; font-size:13px; font-weight:normal;} table{font-size:18px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid; margin-top:10px;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%; margin-top:10px;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:12px; color:#fff;} td{padding:5px;} div#qrcode{text-align:center;} .border-bottom{border-bottom: 1px solid;} .border-top{border-top: 1px solid;} p.line-height-18{line-height:2; padding-top:5px; padding-bottom:5px;} p.font-15{font-size:22px !important; line-height:2; padding-top:5px;} p.header{font-size:14px; text-align:center; margin-top:15px; padding-top:10px;}'
                                });                                                           
                            } else if (Settings.remote_printing == 3) {
                                
                            }
                    }
                </script>
                <?php /* include FCPATH.'themes'.DIRECTORY_SEPARATOR.$Settings->theme.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'pos'.DIRECTORY_SEPARATOR.'remote_printing.php'; */ ?>
                <?php include 'remote_printing.php'; ?>
                <?php
                if ($modal) {
                    ?>
                </div>
            </div>
        </div>
        <?php
    } else {
        ?>
    <!-- end -->
    </body>
    </html>
    <?php
}
?>
