<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?><!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">   
    <title><?= $page_title.' | '.$Settings->site_name; ?></title>
    <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="<?= $assets ?>dist/css/styles.css" rel="stylesheet" type="text/css" />
    <link href="<?= $assets ?>dist/css/print.min.css" rel="stylesheet" type="text/css" />
    <?= $Settings->rtl ? '<link href="'.$assets.'dist/css/rtl.css" rel="stylesheet" />' : ''; ?>
    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js"></script>  
</head>
<body class="skin-<?= $Settings->theme_style; ?> sidebar-collapse sidebar-mini fixed pos">
    <div class="wrapper rtl rtl-inv">

        <header class="main-header">
            <a href="<?= site_url(); ?>" class="logo">
                <?php if ($store) { ?>
                <span class="logo-mini"><?= $store->code; ?></span>
                <span class="logo-lg"><?= $store->name == 'SimplePOS' ? 'Simple<b>POS</b>' : $store->name; ?></span>
                <?php } else { ?>
                <span class="logo-mini">POS</span>
                <span class="logo-lg"><?= $Settings->site_name == 'SimplePOS' ? 'Simple<b>POS</b>' : $Settings->site_name; ?></span>
                <?php } ?>
            </a>
            <nav class="navbar navbar-static-top" role="navigation">            
               
                <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
				</a>  
                <ul class="nav navbar-nav pull-left">
                    <li class="dropdown">                                              
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown"><img src="<?= $assets; ?>images/<?= $Settings->selected_language; ?>.png" alt="<?= $Settings->selected_language; ?>"></a>
                        <ul class="dropdown-menu">
                            <?php $scanned_lang_dir = array_map(function ($path) {
                                return basename($path);
                            }, glob(APPPATH . 'language/*', GLOB_ONLYDIR));
                            foreach ($scanned_lang_dir as $entry) { ?>
                            <li><a href="<?= site_url('pos/language/' . $entry); ?>"><img
                                src="<?= $assets; ?>images/<?= $entry; ?>.png"
                                class="language-img"> &nbsp;&nbsp;<?= ucwords($entry); ?></a></li>
                                <?php } ?>
                            </ul>
                        </li>                        
                    </ul>                      
                    <div class="navbar-custom-menu">

                        <ul class="nav navbar-nav">

                             <!-- <li><a href="#" onclick="toggleFullScreen(document.body)"><i class='fa fa-arrows-alt'></i></a></li> 
                        PopupCenter('http://www.google.com','google.com','900','500', {toolbar:1, resizable:1, location:1, menubar:1, status:1}); 
 <li class="hidden-sm hidden-xs"><a href="< ?= site_url('pos/view_bill'); ?>" target="_blank"><i class="fa fa-desktop"></i></a></li>

                        -->

                        <li class="hidden-sm hidden-xs"><a href="#" class="clock"></a></li>
                            <li class="hidden-sm hidden-xs"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i></a></li>
                            <?php if ($Admin) { ?>
                            <li class="hidden-sm hidden-xs"><a href="<?= site_url('settings'); ?>"><i class="fa fa-cogs"></i></a></li>
                            <?php } ?>
                            <?php if ($this->db->dbdriver != 'sqlite3') { ?>
                                <li class="hidden-sm hidden-xs"><a href="<?= site_url('pos/view_bill'); ?>" target="_blank"><i class="fa fa-desktop"></i></a></li>                            
                            <?php } ?>
                            <li class="hidden-xs hidden-sm"><a href="<?= site_url('pos/shortcuts'); ?>" data-toggle="ajax"><i class="fa fa-key"></i></a></li>
                            <li ><a href="<?= site_url('pos/register_details'); ?>" data-toggle="ajax"><i class="fa fa-bar-chart-o"></i></a></li>
                            <li ><a href="<?= site_url('pos/today_sale'); ?>" data-toggle="ajax"><i class="fa fa-shopping-cart"></i></a></li>
                            <li ><a href="<?= site_url('pos/close_register'); ?>" data-toggle="ajax"><i class="fa fa-dollar"></i></a></li>
                            <?php if ($suspended_sales) { ?>
                            <li class="dropdown notifications-menu" id="suspended_sales">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-bell-o"></i>
                                    <span class="label label-warning"><?=sizeof($suspended_sales);?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="header">
                                        <input type="text" autocomplete="off" data-list=".list-suspended-sales" name="filter-suspended-sales" id="filter-suspended-sales" class="form-control input-sm kb-text clearfix" placeholder="<?= lang('filter_by_reference'); ?>">
                                    </li>
                                    <li>
                                        <ul class="menu">
                                            <li class="list-suspended-sales">
                                                <?php
                                                foreach ($suspended_sales as $ss) {
                                                    echo '<a href="'.site_url('pos/?hold='.$ss->id).'" class="load_suspended">'.$this->tec->hrld($ss->date).' ('.$ss->customer_name.')<br><div class="bold">'.$ss->hold_ref.'</div></a>';
                                                }
                                                ?>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="footer"><a href="<?= site_url('sales/opened'); ?>"><?= lang('view_all'); ?></a></li>
                                </ul>
                            </li>
                            <?php } ?>
                            <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" style="padding: 15px 5px;">
                                    <img src="<?= base_url('uploads/avatars/thumbs/'.($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender').'.png')) ?>" class="user-image" alt="Avatar" />
                                    <span class="hidden-sm hidden-xs"><?= $this->session->userdata('first_name').' '.$this->session->userdata('last_name'); ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="user-header">
                                        <img src="<?= base_url('uploads/avatars/'.($this->session->userdata('avatar') ? $this->session->userdata('avatar') : $this->session->userdata('gender').'.png')) ?>" class="img-circle" alt="Avatar" />
                                        <p>
                                            <?= $this->session->userdata('email'); ?>
                                            <small><?= lang('member_since').' '.$this->session->userdata('created_on'); ?></small>
                                        </p>
                                    </li>
                                    <li class="user-footer">
                                        <div class="pull-left">
                                            <a href="<?= site_url('users/profile/'.$this->session->userdata('user_id')); ?>" class="btn btn-default btn-flat"><?= lang('profile'); ?></a>
                                        </div>
                                        <div class="pull-right">
                                            <a href="<?= site_url('logout'); ?>" class="btn btn-default btn-flat<?= $this->session->userdata('register_id') ? ' sign_out' : ''; ?>"><?= lang('sign_out'); ?></a>
                                        </div>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="#" data-toggle="control-sidebar" class="sidebar-icon"><i class="fa fa-folder sidebar-icon"></i></a>
                            </li>
                        </ul>
                    </div>
                </nav>
            </header>

            <aside class="main-sidebar">
                <section class="sidebar">
                    <ul class="sidebar-menu">
                        <?php if ($Order) { ?> 
                            <li class="mm_pos"><a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i> <span><?= lang('pos'); ?></span></a></li>
                        <?php } else if (!$Staff && !$Admin) { ?>   
                        <li class="mm_welcome"><a href="<?= site_url(); ?>"><i class="fa fa-dashboard"></i> <span><?= lang('dashboard'); ?></span></a></li>
                        <?php if ($Settings->multi_store && !$this->session->userdata('store_id')) { ?>
                        <li class="mm_stores"><a href="<?= site_url('stores'); ?>"><i class="fa fa-building-o"></i> <span><?= lang('stores'); ?></span></a></li>
                        <?php } ?>
                        <li class="mm_pos"><a href="<?= site_url('pos'); ?>"><i class="fa fa-th"></i> <span><?= lang('pos'); ?></span></a></li>
                         
                            <li class="treeview mm_sales">
                            <a href="#">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?= lang('sales'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_sales'); ?></a></li>
                                <li id="sales_opened"><a href="<?= site_url('sales/opened'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_opened_bills'); ?></a></li>
                            </ul>
                        </li>
                        <li class="treeview mm_products">
                                <a href="#">
                                    <i class="fa fa-barcode"></i>
                                    <span><?= lang('products'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a>
                                <ul class="treeview-menu">
                                    <li id="products_index"><a href="<?= site_url('products'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_products'); ?></a></li>
                                    <li id="products_add"><a href="<?= site_url('products/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_product'); ?></a></li>
                                    <li id="products_import"><a href="<?= site_url('products/import'); ?>"><i class="fa fa-circle-o"></i> <?= lang('import_products'); ?></a></li>

                                </ul>
                                
                                
                            </li>
                            <li class="treeview mm_categories">
                                <a href="#">
                                    <i class="fa fa-folder"></i>
                                    <span><?= lang('categories'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a>
                                <ul class="treeview-menu">
                                    <li id="categories_index"><a href="<?= site_url('categories'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_categories'); ?></a></li>
                                    <li id="categories_add"><a href="<?= site_url('categories/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_category'); ?></a></li>
                                    <li id="categories_import"><a href="<?= site_url('categories/import'); ?>"><i class="fa fa-circle-o"></i> <?= lang('import_categories'); ?></a></li>
                                </ul>
                            </li>

                            <li class="treeview mm_purchases">
                                <a href="#">
                                    <i class="fa fa-plus"></i>
                                    <span><?= lang('purchases'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a>
                                <ul class="treeview-menu">
                                    <li id="purchases_index"><a href="<?= site_url('purchases'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_purchases'); ?></a></li>
                                    <li id="purchases_add"><a href="<?= site_url('purchases/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_purchase'); ?></a></li>
                                    <li id="purchases_import"><a href="<?= site_url('purchases/import'); ?>"><i class="fa fa-circle-o"></i> <?= lang('import_purchase'); ?></a></li>
                                    <li class="divider"></li>
                                    <li id="purchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_expenses'); ?></a></li>
                                    <li id="purchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_expense'); ?></a></li>
                                </ul>
                            </li>
                            <li class="treeview mm_customers">
                                <a href="#">
                                    <i class="fa fa-users"></i>
                                    <span><?= lang('customers'); ?></span>
                                    <i class="fa fa-angle-left pull-right"></i>
                                </a>
                                <ul class="treeview-menu">
                                    <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_customers'); ?></a></li>
                                    <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_customer'); ?></a></li>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if ($Admin) { ?>
                        <li class="treeview mm_products">
                            <a href="#">
                                <i class="fa fa-barcode"></i>
                                <span><?= lang('products'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="products_index"><a href="<?= site_url('products'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_products'); ?></a></li>
                                <li id="products_add"><a href="<?= site_url('products/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_product'); ?></a></li>
                                <li id="products_import"><a href="<?= site_url('products/import'); ?>"><i class="fa fa-circle-o"></i> <?= lang('import_products'); ?></a></li>
                                <li class="divider"></li>
                                
                            </ul>
                        </li>
                        <li class="treeview mm_categories">
                            <a href="#">
                                <i class="fa fa-folder"></i>
                                <span><?= lang('categories'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="categories_index"><a href="<?= site_url('categories'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_categories'); ?></a></li>
                                <li id="categories_add"><a href="<?= site_url('categories/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_category'); ?></a></li>
                                <li id="categories_import"><a href="<?= site_url('categories/import'); ?>"><i class="fa fa-circle-o"></i> <?= lang('import_categories'); ?></a></li>
                            </ul>
                        </li>
                        <? if ($Settings->show_unit) { ?>               
                        <li class="treeview mm_unit">
                            <a href="#">
                                <i class="fa fa-bars"></i>
                                <span><?= lang('unit'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">                      
                                
                                <li id="unit_index"><a href="<?= site_url('unit'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_unit'); ?></a></li>
                                <li id="unit_add"><a href="<?= site_url('unit/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_unit'); ?></a></li>
                                
                            </ul>
                        </li>              
                        <? } ?>
                        <li class="treeview mm_sales">
                            <a href="#">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?= lang('sales'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_sales'); ?></a></li>
                                <? if ($Settings->show_delivery) { ?>
                                <li id="sales_delivery_list"><a href="<?= site_url('sales/delivery_list'); ?>"><i class="fa fa-circle-o"></i> <?= lang('delivery_list'); ?></a></li>
                                <? } ?>
                                <li id="sales_opened"><a href="<?= site_url('sales/opened'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_opened_bills'); ?></a></li>
                                <? if ($Settings->show_product_service) { ?>
                                <li id="sales_service_items"><a href="<?= site_url('sales/service_items'); ?>"><i class="fa fa-circle-o"></i> <?= lang('service_items'); ?></a></li>
                                <? } ?>
                            </ul>
                        </li>
                        <li class="treeview mm_purchases">
                            <a href="#">
                                <i class="fa fa-plus"></i>
                                <span><?= lang('purchases'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="purchases_index"><a href="<?= site_url('purchases'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_purchases'); ?></a></li>
                                <li id="purchases_add"><a href="<?= site_url('purchases/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_purchase'); ?></a></li>
                                <li class="divider"></li>
                                <li id="purchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_expenses'); ?></a></li>
                                <li id="purchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_expense'); ?></a></li>
                            </ul>
                        </li>
                        <?/*
                        <li class="treeview mm_gift_cards">
                            <a href="#">
                                <i class="fa fa-credit-card"></i>
                                <span><?= lang('gift_cards'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="gift_cards_index"><a href="<?= site_url('gift_cards'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_gift_cards'); ?></a></li>
                                <li id="gift_cards_add"><a href="<?= site_url('gift_cards/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_gift_card'); ?></a></li>
                            </ul>
                        </li>
                        */?>
                        <li class="treeview mm_auth mm_customers mm_suppliers">
                            <a href="#">
                                <i class="fa fa-users"></i>
                                <span><?= lang('people'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="auth_users"><a href="<?= site_url('users'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_users'); ?></a></li>
                                <li id="auth_add"><a href="<?= site_url('users/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_user'); ?></a></li>
                                <li class="divider"></li>
                                <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_customers'); ?></a></li>
                                <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_customer'); ?></a></li>
                                <li class="divider"></li>
                                <li id="suppliers_index"><a href="<?= site_url('suppliers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_suppliers'); ?></a></li>
                                <li id="suppliers_add"><a href="<?= site_url('suppliers/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_supplier'); ?></a></li>
                            </ul>
                        </li>

                        <li class="treeview mm_settings">
                            <a href="#">
                                <i class="fa fa-cogs"></i>
                                <span><?= lang('settings'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="settings_index"><a href="<?= site_url('settings'); ?>"><i class="fa fa-circle-o"></i> <?= lang('settings'); ?></a></li>
                                <li class="divider"></li>
                                <?php if ($Settings->multi_store) { ?>
                                <li id="settings_stores"><a href="<?= site_url('settings/stores'); ?>"><i class="fa fa-circle-o"></i> <?= lang('stores'); ?></a></li>
                                <li id="settings_add_store"><a href="<?= site_url('settings/add_store'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_store'); ?></a></li>
                                <li class="divider"></li>
                                <?php } ?>
                                <?/*
                                <li id="settings_printers"><a href="<?= site_url('settings/printers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('printers'); ?></a></li>
                                <li id="settings_add_printer"><a href="<?= site_url('settings/add_printer'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_printer'); ?></a></li>
                                */?>
                                <li class="divider"></li>
                                <?php if ($this->db->dbdriver != 'sqlite3') { ?>
                                <li id="settings_backups"><a href="<?= site_url('settings/backups'); ?>"><i class="fa fa-circle-o"></i> <?= lang('backups'); ?></a></li>
                                <?php } ?>
                                <!-- <li id="settings_updates"><a href="<?= site_url('settings/updates'); ?>"><i class="fa fa-circle-o"></i> <?= lang('updates'); ?></a></li> -->
                            </ul>
                        </li>
                        <li class="treeview mm_reports">
                            <a href="#">
                                <i class="fa fa-bar-chart-o"></i>
                                <span><?= lang('reports'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="reports_daily_sales"><a href="<?= site_url('reports/daily_sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('daily_sales'); ?></a></li>
                                <li id="reports_daily_profit"><a href="<?= site_url('reports/daily_profit'); ?>"><i class="fa fa-circle-o"></i> <?= lang('daily_profit'); ?></a></li>
                                <li id="reports_monthly_sales"><a href="<?= site_url('reports/monthly_sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('monthly_sales'); ?></a></li>
                                <li id="reports_monthly_profit"><a href="<?= site_url('reports/monthly_profit'); ?>"><i class="fa fa-circle-o"></i> <?= lang('monthly_profit'); ?></a></li>
                                <li id="reports_index"><a href="<?= site_url('reports'); ?>"><i class="fa fa-circle-o"></i> <?= lang('sales_report'); ?></a></li>
                                <li class="divider"></li>
                                <li id="reports_payments"><a href="<?= site_url('reports/payments'); ?>"><i class="fa fa-circle-o"></i> <?= lang('payments_report'); ?></a></li>
                                <li id="reports_registers"><a href="<?= site_url('reports/registers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('registers_report'); ?></a></li>
                                <li class="divider"></li>
                                <li id="reports_top_products"><a href="<?= site_url('reports/top_products'); ?>"><i class="fa fa-circle-o"></i> <?= lang('top_products'); ?></a></li>
                                <li id="reports_products"><a href="<?= site_url('reports/products'); ?>"><i class="fa fa-circle-o"></i> <?= lang('products_report'); ?></a></li>
                                <li id="reports_allproducts"><a href="<?= site_url('reports/allproducts'); ?>"><i class="fa fa-circle-o"></i> <?= lang('allproducts_report'); ?></a></li>
                                <li id="reports_productsbysales"><a href="<?= site_url('reports/productsbysales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('products_by_sales'); ?></a></li>
                                <li id="reports_category"><a href="<?= site_url('reports/category'); ?>"><i class="fa fa-circle-o"></i> <?= lang('category_report'); ?></a></li>
                                <li id="reports_due"><a href="<?= site_url('reports/due'); ?>"><i class="fa fa-circle-o"></i> <?= lang('due_report'); ?></a></li>
                                <li id="reports_purchases"><a href="<?= site_url('reports/purchases'); ?>"><i class="fa fa-circle-o"></i> <?= lang('Purchse_report'); ?></a></li>
                            </ul>
                        </li>
                        <?php } else if($Staff) { ?>
                        <li class="mm_products"><a href="<?= site_url('products'); ?>"><i class="fa fa-barcode"></i> <span><?= lang('products'); ?></span></a></li>
                        <li class="mm_categories"><a href="<?= site_url('categories'); ?>"><i class="fa fa-folder-open"></i> <span><?= lang('categories'); ?></span></a></li>
                        <?php if ($this->session->userdata('store_id')) { ?>
                        <li class="treeview mm_sales">
                            <a href="#">
                                <i class="fa fa-shopping-cart"></i>
                                <span><?= lang('sales'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="sales_index"><a href="<?= site_url('sales'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_sales'); ?></a></li>
                                <li id="sales_opened"><a href="<?= site_url('sales/opened'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_opened_bills'); ?></a></li>
                            </ul>
                        </li>
                        <li class="treeview mm_purchases">
                            <a href="#">
                                <i class="fa fa-plus"></i>
                                <span><?= lang('expenses'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="purchases_expenses"><a href="<?= site_url('purchases/expenses'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_expenses'); ?></a></li>
                                <li id="purchases_add_expense"><a href="<?= site_url('purchases/add_expense'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_expense'); ?></a></li>
                            </ul>
                        </li>
                        <?php } ?>
                        <?/*
                        <li class="treeview mm_gift_cards">
                            <a href="#">
                                <i class="fa fa-credit-card"></i>
                                <span><?= lang('gift_cards'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="gift_cards_index"><a href="<?= site_url('gift_cards'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_gift_cards'); ?></a></li>
                                <li id="gift_cards_add"><a href="<?= site_url('gift_cards/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_gift_card'); ?></a></li>
                            </ul>
                        </li>
                        */?>
                        <li class="treeview mm_customers">
                            <a href="#">
                                <i class="fa fa-users"></i>
                                <span><?= lang('customers'); ?></span>
                                <i class="fa fa-angle-left pull-right"></i>
                            </a>
                            <ul class="treeview-menu">
                                <li id="customers_index"><a href="<?= site_url('customers'); ?>"><i class="fa fa-circle-o"></i> <?= lang('list_customers'); ?></a></li>
                                <li id="customers_add"><a href="<?= site_url('customers/add'); ?>"><i class="fa fa-circle-o"></i> <?= lang('add_customer'); ?></a></li>
                            </ul>
                        </li>
                        <?php } ?>
                    </ul>
                </section>
            </aside>

            <div class="content-wrapper">

                <div class="col-lg-12 alerts">
                <?php if ($error)  { ?>
                    <div class="alert alert-danger alert-dismissable">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <h4><i class="icon fa fa-ban"></i> <?= lang('error'); ?></h4>
                        <?= $error; ?>
                    </div>
                    <?php } if ($message) { ?>
                    <div class="alert alert-success alert-dismissable">
                        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                        <h4><i class="icon fa fa-check"></i> <?= lang('Success'); ?></h4>
                        <?= $message; ?>
                    </div>
                    <?php } ?>
                </div>

                <table style="width:100%;" class="layout-table">
                    <tr>
                        <td class="pos-toggle">                
                     
                            <div id="pos">
                                <?= form_open('pos', 'id="pos-sale-form" class="pos-toggle"'); ?>
                                <div class="well well-sm" id="leftdiv">
                                    <div id="lefttop" style="margin-bottom:5px;">
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <div class="input-group">
                                                <?php foreach($customers as $customer){
                                                    $cus_name = $customer->name;
                                                    if($customer->phone != ''){$cus_name = $cus_name . '-' . $customer->phone;} 
                                                    if($customer->cf1 != ''){$cus_name = $cus_name . '-' . $customer->cf1;} 
                                                    $cus[$customer->id] = $cus_name; 
                                                } ?>
                                                <?= form_dropdown('customer_id', $cus, set_value('customer_id', $Settings->default_customer), 'id="spos_customer" data-placeholder="' . lang("select") . ' ' . lang("customer") . '" required="required" class="form-control select2" style="width:100%;position:absolute;"'); ?>
                                                <div class="input-group-addon no-print" style="padding: 2px 5px;">
                                                    <a href="#" id="add-customer" class="external" data-toggle="modal" data-target="#myModal"><i class="fa fa-2x fa-plus-circle" id="addIcon"></i></a>
                                                </div>
                                            </div>
                                            <div style="clear:both;"></div>
                                        </div>
                                        <?php if ($eid && $Admin) { ?>
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <?php
                                            $us[""] = "";
                                            foreach ($users as $user) {
                                                $us[$user->id] = $user->first_name . " " . $user->last_name;
                                            }
                                            echo form_dropdown('created_by', $us, (isset($_POST['created_by']) ? $_POST['created_by'] : ""), 'class="form-control select2" id="user" data-placeholder="' . lang("select") . " " . lang("user") . '" style="width:100%;"');
                                            ?>                                            
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <?= form_input('date', set_value('date', $sale->date), 'id="date" required="required" class="form-control"'); ?>
                                        </div>
                                        <?php } ?>
                                        <?= form_input('date_in', set_value('date_in', isset($sale->date_in)?$sale->date_in:NULL), 'id="date_in" style="display:none;" class="form-control"'); ?>
                                        <? if ($Settings->show_wholesale) { ?>
                                        <div class="form-group" style="margin-bottom:5px;">
                                        <? } else { ?>
                                            <div class="form-group" style="margin-bottom:5px; display:none;">
                                        <? } ?>
                                            <?php $price_type = array('retail' => lang('price_retail'), 'wholesale' => lang('price_wholesale'), 'vip' => lang('price_vip')); ?>
                                            <?= form_dropdown('price_type', $price_type, 'retail', 'id="price_type" class="form-control select2" style="width:100%;position:absolute;"'); ?>
                                        </div>
                                        <? if ($Settings->show_customer_group) { ?>
                                        <div class="form-group" style="margin-bottom:5px;">
                                        <? } else { ?>
                                        <div class="form-group" style="margin-bottom:5px; display:none;">
                                        <? } ?>
                                            <?php
                                            $grp[''] = lang("select")." ".lang("customer_group");
                                            foreach($customer_group as $group) {
                                                $grp[$group->id] = $group->name;
                                            }
                                            ?>
                                            <?= form_dropdown('sale_group_id', $grp, set_value('sale_group_id'), 'class="form-control select2 tip" id="sale_group_id" style="width:100%;"'); ?>
                                        </div>
                                        <? if ($Settings->pos_prodtype_filter) { ?>
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <?php //$opts = array('all' => lang('all'),'standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service'), 'other' => lang('other')); ?>
                                            <?php $opts = array('all' => lang('all'),'standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service')); ?>
                                            <?= form_dropdown('type', $opts, set_value('type', 'all'), 'class="form-control tip select2" id="type" style="width:100%;"'); ?>
                                        </div>
                                        <? } else { ?>
                                        <div class="form-group" style="margin-bottom:5px; display:none;">
                                            <?php //$opts = array('all' => lang('all'),'standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service'), 'other' => lang('other')); ?>
                                            <?php $opts = array('all' => lang('all'),'standard' => lang('standard'), 'combo' => lang('combo'), 'service' => lang('service')); ?>
                                            <?= form_dropdown('type', $opts, set_value('type', 'all'), 'class="form-control tip select2" id="type" style="width:100%;"'); ?>
                                        </div>
                                        <? } ?>    
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <input type="hidden" name="hold_ref" value="<?= $reference_note; ?>" id="hold_ref" class="form-control kb-text" placeholder="<?=lang('reference_note')?>" />
                                            <? if ($Settings->each_spent > 0) { ?>
                                            <input type="text" name="award_points" id="award_points" class="form-control kb-text" placeholder="<?=lang('award_points')?>" readonly />
                                            <? } ?>
                                            <? if ($Settings->show_previous_due) { ?>
                                            <input type="text" name="previous_due" id="previous_due" class="form-control kb-text" placeholder="<?=lang('previous_due')?>" readonly />
                                            <? } ?>
                                            <input type="hidden" name="inv_number" id="inv_number" value="<?= $sale->inv_number; ?>" class="form-control kb-text" placeholder="<?=lang('invoice')?>" />
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom:5px;">
                                            <input type="text" name="code" id="add_item" class="form-control" placeholder="<?=lang('search__scan')?>" />
                                        </div>
                                        <? if ($Settings->show_alert_payment) { ?>
                                        <div style="padding-left:0px; padding-right:5px;" class="col-sm-6">
                                            <div class="form-group" style="margin-bottom:0px; ">                                        
                                                <?= form_input('next_payment', (isset($_POST['next_payment']) ? $_POST['next_payment'] : ""), 'class="form-control datetimepicker" id="next_payment" placeholder="'. lang('next_payment') . '"'); ?>
                                            </div>
                                        </div>
                                        <div style="padding-right:0px; padding-left:5px;" class="col-sm-6">
                                            <div class="form-group" style="margin-bottom:0px; ">                                                                                 
                                                <input type="text" name="alert_payment_day" id="alert_payment_day" class="form-control kb-text" placeholder="<?=lang('alert_payment_day')?>"/>
                                            </div>
                                        </div>
                                        <? } ?>
                                        <div style="clear:both;"></div>
                                    </div>
                                    <div id="printhead" class="print">
                                        <?= $Settings->header; ?>
                                        <p><?= lang('date'); ?>: <?=date($Settings->dateformat)?></p>
                                    </div>
                                    <div id="print" class="fixed-table-container">
                                        <div id="list-table-div">
                                            <!--
                                            <div class="fixed-table-header">
                                                <table class="table table-striped table-condensed table-hover list-table" style="margin:0;">
                                                    <thead>
                                                        <tr class="success">
                                                            <th>< ?=lang('product')?></th>
                                                            <th style="width: 15%;text-align:center;">< ?=lang('price')?></th>
                                                            < ? if ($Settings->show_item_length) { ?>
                                                            <th style="width: 15%;text-align:center;">< ?=lang('length')?></th>
                                                            < ? } ?>
                                                            <th style="width: 15%;text-align:center;">< ?=lang('qty')?></th>
                                                            <th style="width: 15%;text-align:center;">< ?=lang('disc')?></th>
                                                            <th style="width: 20%;text-align:center;">< ?=lang('subtotal')?></th>
                                                            <th style="width: 20px;" class="satu"><i class="fa fa-trash-o"></i></th>
                                                        </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                                            -->
                                            <table id="posTable" class="table table-striped table-condensed table-hover list-table" style="margin:0px;width:100%" data-height="100">
                                                <thead>
                                                    <tr class="success">
                                                        <th style="width: 30%;text-align:center;"><?=lang('product')?></th>
                                                        <th style="width: 15%;text-align:center;"><?=lang('price')?></th>

                                                       <!-- < ? if ($Settings->show_item_length) { ?>
                                                        <th style="width: 15%;text-align:center;">< ?=lang('length')?></th>
                                                        < ? } ?>
                                                       -->
                                                        <th style="width: 15%;text-align:center;"><?=lang('qty')?></th>
                                                        <th style="width: 15%;text-align:center;"><?=lang('disc')?></th>
                                                        <th style="width: 20%;text-align:center;"><?=lang('subtotal')?></th>
                                                        <th style="width: 5%;text-align:center" class="satu"><i class="fa fa-trash-o"></i></th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                        <div style="clear:both;"></div>
                                        <div id="totaldiv">
                                            <table id="totaltbl" class="table table-condensed totals" style="margin-bottom:10px;">
                                                <tbody>
                                                    <tr class="info">
                                                        <td width="25%"><?=lang('total_items')?></td>
                                                        <td class="text-right" style="padding-right:10px;"><span id="count">0</span></td>
                                                        <td width="25%"><?=lang('total')?></td>
                                                        <td class="text-right" colspan="2"><span id="total">0</span></td>
                                                    </tr>
                                                    <tr class="info">
                                                        <?if ($Settings->staff_change_pos_discount == 0 && !$Admin) { ?>
                                                        <td width="25%"><?=lang('discount')?></td>
                                                        <?} else {?>
                                                        <td width="25%"><a href="#" id="add_discount"><?=lang('discount')?></a></td>
                                                        <?}?>
                                                        <td class="text-right" style="padding-right:10px;"><span id="ds_con">0</span></td>
                                                        <td width="25%"><a href="#" id="add_tax"><?=lang('order_tax')?></a></td>
                                                        <td class="text-right"><span id="ts_con">0</span></td>
                                                    </tr>
                                                    <tr class="success">
                                                        <td colspan="2" style="font-weight:bold;">
                                                            <?=lang('total_payable')?>
                                                            <a role="button" data-toggle="modal" data-target="#noteModal">
                                                                <i class="fa fa-comment"></i>
                                                            </a>
                                                        </td>
                                                        <td class="text-right" colspan="2" style="font-weight:bold;"><span id="total-payable">0</span></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <?php if($Settings->show_orderbill) { ?>
                                    <?php if($this->Order) { ?>
                                        <div id="botbuttons" class="col-xs-12 text-center">
                                        <div class="row">
                                            <div class="col-xs-4" style="padding: 0;">
                                                <div class="btn-group-vertical btn-block">                                                
                                                    <button type="button" class="btn btn-danger btn-block btn-flat" id="reset" style="height:67px;"><?= lang('clear'); ?></button>
                                                </div>

                                            </div>
                                            <div class="col-xs-4" style="padding: 0 5px;">												
                                                <div class="btn-group-vertical btn-block">
                                                    <button type="button" class="btn bg-purple btn-block btn-flat" id="print_order" style="height:67px;"><?= lang('print_order'); ?></button>
                                                </div>												
                                            </div>
                                            <div class="col-xs-4" style="padding: 0 5px;">												
                                                <div class="btn-group-vertical btn-block">
                                                    <button type="button" class="btn btn-warning btn-block btn-flat" id="suspend" style="height:67px;"><?= lang('hold'); ?></button>
                                                </div>												
                                            </div>
                                        </div>
                                    </div>
                                    <?php } else { ?>
                                    <div id="botbuttons" class="col-xs-12 text-center">
                                        <div class="row">
                                            <div class="col-xs-4" style="padding: 0;">
                                                <div class="btn-group-vertical btn-block">
                                                    <button type="button" class="btn btn-warning btn-block btn-flat" id="suspend"><?= lang('hold'); ?></button>
                                                    <button type="button" class="btn btn-danger btn-block btn-flat" id="reset"><?= lang('clear'); ?></button>
                                                </div>

                                            </div>
                                            <div class="col-xs-4" style="padding: 0 5px;">												
                                                <div class="btn-group-vertical btn-block">
                                                    <button type="button" class="btn bg-purple btn-block btn-flat" id="print_order"><?= lang('print_order'); ?></button>

                                                    <button type="button" class="btn bg-navy btn-block btn-flat" id="print_bill"><?= lang('print_bill'); ?></button>
                                                </div>												
                                            </div>
                                            <div class="col-xs-4" style="padding: 0;">
                                                <button type="button" class="btn btn-success btn-block btn-flat" id="<?= $eid ? 'submit-sale' : 'payment'; ?>" style="height:67px;"><?= $eid ? lang('submit') : lang('payment'); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <?php } else { ?>
                                    <div id="botbuttons" class="col-xs-12 text-center">
                                        <div class="row">
                                            <div class="col-xs-4" style="padding: 0;">
                                                <div class="btn-group-vertical btn-block">                                                
                                                    <button type="button" class="btn btn-danger btn-block btn-flat" id="reset" style="height:67px;"><?= lang('clear'); ?></button>
                                                </div>

                                            </div>
                                            <div class="col-xs-4" style="padding: 0 5px;">												
                                                <div class="btn-group-vertical btn-block">
                                                    <button type="button" class="btn btn-warning btn-block btn-flat" id="suspend" style="height:67px;"><?= lang('hold'); ?></button>
                                                </div>												
                                            </div>
                                            <div class="col-xs-4" style="padding: 0;">
                                                <button type="button" class="btn btn-success btn-block btn-flat" id="<?= $eid ? 'submit-sale' : 'payment'; ?>" style="height:67px;"><?= $eid ? lang('submit') : lang('payment'); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                    <? } ?>
                                    <div class="clearfix"></div>
                                    <span id="hidesuspend"></span>
                                    <input type="hidden" name="spos_note" value="" id="spos_note">

                                    <div id="payment-con">
                                        <input type="hidden" name="amount" id="amount_val" value="<?= $eid ? $sale->paid : ''; ?>"/>
                                        <input type="hidden" name="amount_main" id="amount_main_val" value=""/>
                                        <input type="hidden" name="amount_exc" id="amount_exc_val" value=""/>
                                        <input type="hidden" name="amount_exc2" id="amount_exc2_val" value=""/>
                                        <input type="hidden" name="balance_amount" id="balance_val" value=""/>
                                        <input type="hidden" name="paid_by" id="paid_by_val" value="cash"/>
                                        <input type="hidden" name="cc_no" id="cc_no_val" value=""/>
                                        <input type="hidden" name="paying_gift_card_no" id="paying_gift_card_no_val" value=""/>
                                        <input type="hidden" name="cc_holder" id="cc_holder_val" value=""/>
                                        <input type="hidden" name="cheque_no" id="cheque_no_val" value=""/>
                                        <input type="hidden" name="cc_month" id="cc_month_val" value=""/>
                                        <input type="hidden" name="cc_year" id="cc_year_val" value=""/>
                                        <input type="hidden" name="cc_type" id="cc_type_val" value=""/>
                                        <input type="hidden" name="cc_cvv2" id="cc_cvv2_val" value=""/>
                                        <input type="hidden" name="balance" id="balance_val" value=""/>
                                        <input type="hidden" name="payment_note" id="payment_note_val" value=""/>
                                    </div>
                                    <input type="hidden" name="customer" id="customer" value="<?=$Settings->default_customer?>" />
                                    <input type="hidden" name="order_tax" id="tax_val" value="" />
                                    <input type="hidden" name="order_discount" id="discount_val" value="" />
                                    <input type="hidden" name="count" id="total_item" value="" />
                                    <input type="hidden" name="did" id="is_delete" value="<?=$sid;?>" />
                                    <input type="hidden" name="eid" id="is_delete" value="<?=$eid;?>" />
                                    <input type="hidden" name="total_items" id="total_items" value="0" />
                                    <input type="hidden" name="total_quantity" id="total_quantity" value="0" />
                                    <input type="hidden" name="sale_customer_group" id="sale_customer_group_val" value="" />
                                    <input type="submit" id="submit" value="Submit Sale" style="display: none;" />
                                </div>
                                <?=form_close();?>
                                </div>

                        </td>
                        <td>
                            

                        
                            <div class="contents" id="right-col">
                                <div id="item-list">
                                    <div class="items">
                                        <?php echo $products; ?>
                                    </div>
                                </div>
                                <div class="product-nav">
                                    <div class="btn-group btn-group-justified">
                                        <div class="btn-group">
                                            <button style="z-index:10002;" class="btn btn-warning pos-tip btn-flat" type="button" id="previous"><i class="fa fa-chevron-left"></i></button>
                                        </div>
                                        <?/*
                                        <div class="btn-group">
                                            <button style="z-index:10003;" class="btn btn-success pos-tip btn-flat" type="button" id="sellGiftCard"><i class="fa fa-credit-card" id="addIcon"></i> <?= lang('sell_gift_card') ?></button>
                                        </div>
                                        */?>
                                        <div class="btn-group">
                                            <button style="z-index:10004;" class="btn btn-warning pos-tip btn-flat" type="button" id="next"><i class="fa fa-chevron-right"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </td>
                    </tr>
                </table>
                                        
                        </div>
                    </div>
            
        </div>

        <aside class="control-sidebar control-sidebar-dark" id="categories-list">
            <div class="tab-content sb">
                <div class="tab-pane active sb" id="control-sidebar-home-tab">
                    <div id="filter-categories-con">
                        <input type="text" autocomplete="off" data-list=".control-sidebar-menu" name="filter-categories" id="filter-categories" class="form-control sb col-xs-12 kb-text" placeholder="<?= lang('filter_categories'); ?>" style="margin-bottom: 20px;">
                    </div>
                    <div class="clearfix sb"></div>
                    <div id="category-sidebar-menu">
                        <ul class="control-sidebar-menu">
                            <?php
                            foreach($categories as $category) {
                                echo '<li><a href="#" class="category'.($category->id == $Settings->default_category ? ' active' : '').'" id="'.$category->id.'">';
                                if ($category->image) {
                                    echo '<div class="menu-icon"><img src="'.base_url('uploads/thumbs/'.$category->image).'" alt="" class="img-thumbnail img-responsive"></div>';
                                } else {
                                    echo '<i class="menu-icon fa fa-folder-open bg-red"></i>';
                                }
                                echo '<div class="menu-info"><h4 class="control-sidebar-subheading">'.$category->name.'</h4><p></p></div>
                            </a></li>';
                        }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </aside>
    <div class="control-sidebar-bg sb"></div>
</div>
</div>

<? if ($this->Settings->receipt_format == 2) { ?>
<div id="order_tbl" style="overflow:hidden; max-height:0; margin: 0 auto;">
<? } else { ?>
    <div id="order_tbl" style="overflow:hidden; max-height:0; max-width:370px; margin: 0 auto;">
<? } ?>
	<div style="text-align:center;" class="text-center">
        <?php
            if ($store) {
                echo '<p style="text-align:center;">';
                echo '<h2 style="margin:0; text-align:center;">'. nl2br($store->name) .'</h2>';
            }
            if($Settings->show_waiting_number){
                echo '<p style="margin:0;">'.lang('waiting_number').':</p>';
                echo '<p style="margin:0; font-weight:bold;">'. ($Settings->waiting_number + 1) .'</p>';
            }
        ?>
    </div>
	<span id="order_span" style="font-family: 'Battambang', 'Battambang'; font-size:10px;"></span>
    <table id="order-table" class="prT table table-striped table-condensed" style="width:100%;margin-bottom:0; font-family: 'Battambang', 'Battambang'; font-size:10px;"></table>
</div>

<? if ($this->Settings->receipt_format == 2) { ?>
<div id="order_tbl1" style="overflow:hidden; max-height:0; margin: 0 auto;">
<? } else { ?>
    <div id="order_tbl1" style="overflow:hidden; max-height:0; max-width:370px; margin: 0 auto;">
<? } ?>
	<div style="text-align:center;" class="text-center">
        <?php
            if ($store) {
                echo '<p style="text-align:center;">';
                echo '<h2 style="margin:0; text-align:center;">'. nl2br($store->name) .'</h2>';
            }
            if($Settings->show_waiting_number){
                echo '<p style="margin:0;">'.lang('waiting_number').':</p>';
                echo '<p style="margin:0; font-weight:bold;">'. ($Settings->waiting_number + 1) .'</p>';
            }
        ?>
    </div>
    <span id="order_span1" style="font-family: 'Battambang', 'Battambang'; font-size:10px;"></span>    
    <table id="order-table1" class="prT table table-striped table-condensed" style="width:100%;margin-bottom:0; font-family: 'Battambang', 'Battambang'; font-size:10px;"></table>
</div>

<? if ($this->Settings->receipt_format == 2) { ?>
<div id="bill_tbl" style="overflow:hidden; max-height:0; margin: 0 auto;">
<? } else { ?>
    <div id="bill_tbl" style="overflow:hidden; max-height:0; max-width:370px; margin: 0 auto;">
<? } ?>
	<div style="text-align:center;" class="text-center">
        <?php
            if ($store) {
                if (!empty($store->logo)) {
					echo '<img src="'.base_url('uploads/'.$store->logo).'" height="80px" alt="'.$store->name.'">';
				}                
                echo '<p style="text-align:center; font-size:11px;">'; 
                echo '<strong>' . nl2br($store->name). '</strong><br></p>';               
                echo '<p>'.$store->address1.'<br>'.$store->address2;
                echo $store->city.'<br>'.$store->phone;
                echo '</p>';
                echo '<p>'.nl2br($store->receipt_header).'</p>';
            }
            if($Settings->show_waiting_number){
                echo '<p style="margin:0;">'.lang('waiting_number').':</p>';
                echo '<p style="margin:0; font-weight:bold;">'. ($Settings->waiting_number + 1).'</p>';
            }
        ?>
    </div>
	<span id="bill_span"></span>	
    <table id="bill-table" width="100%" class="prT table table-striped table-condensed"></table>
    <table id="bill-total-table" width="100%" class="prT table table-striped table-condensed"></table>
    <? if ($Settings->show_refbarcode == 1 || $Settings->show_refbarcode == 3) { ?>
        <div id="barcode" style="text-align:center;"></div>
    <? } ?>
    <? if ($store->aba_qrstring || $store->acleda_qrstring) { ?>
        <div id="qrcode" style="text-align:center;">
            <table width="100%">
                    <tr>
                        <? if($store->aba_qrstring) {
                            echo '<td>ABA</td>';
                        } ?>
                        <? if($store->acleda_qrstring) {
                            echo '<td>ACLEDA</td>';
                        } ?>
                    </tr>
                    <tr>
                        <? if($store->aba_qrstring) {
                            echo '<td>' . $this->tec->qrcode('text', $store->aba_qrstring , 2) . '</td>';
                        } ?>
                        <? if($store->acleda_qrstring) {
                            echo '<td>' . $this->tec->qrcode('text', $store->acleda_qrstring , 2) . '</td>';
                        } ?>
                </tr>
            </table>                                   
        </div>
    <? } ?>
</div>
<div style="width:380px;background:#FFF;display:block">
    <div id="order-data" style="display:none;" class="text-center">
        <h1><?= nl2br($store->name); ?></h1>
        <h2><?= lang('order'); ?></h2>
        <div id="preo" class="text-left"></div>
    </div>
    <div id="bill-data" style="display:none;" class="text-center">
        <h1><?= nl2br($store->name); ?></h1>
        <h2><?= lang('bill'); ?></h2>
        <div id="preb" class="text-left"></div>
    </div>
</div>

<div id="ajaxCall"><i class="fa fa-spinner fa-pulse"></i></div>

<div class="modal" data-easein="flipYIn" id="gcModal" tabindex="-1" role="dialog" aria-labelledby="mModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="myModalLabel"><?= lang('sell_gift_card'); ?></h4>
            </div>
            <div class="modal-body">
                <p><?= lang('enter_info'); ?></p>

                <div class="alert alert-danger gcerror-con" style="display: none;">
                    <button data-dismiss="alert" class="close" type="button">×</button>
                    <span id="gcerror"></span>
                </div>
                <div class="form-group">
                    <?= lang("card_no", "gccard_no"); ?> *
                    <div class="input-group">
                        <?php echo form_input('gccard_no', '', 'class="form-control" id="gccard_no"'); ?>
                        <div class="input-group-addon" style="padding-left: 10px; padding-right: 10px;"><a href="#" id="genNo"><i class="fa fa-cogs"></i></a></div>
                    </div>
                </div>
                <input type="hidden" name="gcname" value="<?= lang('gift_card') ?>" id="gcname"/>
                <div class="form-group">
                    <?= lang("value", "gcvalue"); ?> *
                    <?php echo form_input('gcvalue', '', 'class="form-control" id="gcvalue"'); ?>
                </div>
                <div class="form-group">
                    <?= lang("price", "gcprice"); ?> *
                    <?php echo form_input('gcprice', '', 'class="form-control" id="gcprice"'); ?>
                </div>
                <div class="form-group">
                    <?= lang("expiry_date", "gcexpiry"); ?>
                    <?php echo form_input('gcexpiry', '', 'class="form-control" id="gcexpiry"'); ?>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?=lang('close')?></button>
                <button type="button" id="addGiftCard" class="btn btn-primary"><?= lang('sell_gift_card') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="dsModal" tabindex="-1" role="dialog" aria-labelledby="dsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="dsModalLabel"><?= lang('discount_title'); ?></h4>
            </div>
            <div class="modal-body">
                <input type='text' class='form-control input-sm kb-pad' id='get_ds' onClick='this.select();' value=''>

                <label class="checkbox" for="apply_to_order">
                    <input type="radio" name="apply_to" value="order" id="apply_to_order" checked="checked"/>
                    <?= lang('apply_to_order') ?>
                </label>
                <label class="checkbox" for="apply_to_products">
                    <input type="radio" name="apply_to" value="products" id="apply_to_products"/>
                    <?= lang('apply_to_products') ?>
                </label>
                <label class="checkbox" for="apply_to_beverage">
                    <input type="radio" name="apply_to" value="beverage" id="beverage"/>
                    <?= lang('beverage') ?>
                </label>
                <label class="checkbox" for="apply_to_food">
                    <input type="radio" name="apply_to" value="food" id="food"/>
                    <?= lang('food') ?>
                </label>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm pull-left" data-dismiss="modal"><?=lang('close')?></button>
                <button type="button" id="updateDiscount" class="btn btn-primary btn-sm"><?= lang('update') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="tsModal" tabindex="-1" role="dialog" aria-labelledby="tsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="tsModalLabel"><?= lang('tax_title'); ?></h4>
            </div>
            <div class="modal-body">
                <input type='text' class='form-control input-sm kb-pad' id='get_ts' onClick='this.select();' value=''>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm pull-left" data-dismiss="modal"><?=lang('close')?></button>
                <button type="button" id="updateTax" class="btn btn-primary btn-sm"><?= lang('update') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="noteModal" tabindex="-1" role="dialog" aria-labelledby="noteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="noteModalLabel"><?= lang('note'); ?></h4>
            </div>
            <div class="modal-body">
                <textarea name="snote" id="snote" class="pa form-control kb-text"></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm pull-left" data-dismiss="modal"><?=lang('close')?></button>
                <button type="button" id="update-note" class="btn btn-primary btn-sm"><?= lang('update') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="proModal" tabindex="-1" role="dialog" aria-labelledby="proModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header modal-primary">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="proModalLabel">
                    <?=lang('payment')?>
                </h4>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table-striped">
                    <tr>
                        <th style="width:25%;"><?= lang('net_price'); ?></th>
                        <th style="width:25%;"><span id="net_price"></span></th>
                        <th style="width:25%;"><?= lang('product_tax'); ?></th>
                        <th style="width:25%;"><span id="pro_tax"></span> <span id="pro_tax_method"></span></th>
                    </tr>
                </table>
                <input type="hidden" id="row_id" />
                <input type="hidden" id="item_id" />
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?=lang('unit_price', 'nPrice')?>
                            <?if ($Settings->staff_change_pos_price == 0 && !$Admin) { ?>
                            <input type="text" class="form-control input-sm kb-pad" id="nPrice" readonly onClick="this.select();" placeholder="<?=lang('new_price')?>">
                            <?} else { ?>
                            <input type="text" class="form-control input-sm kb-pad" id="nPrice" onClick="this.select();" placeholder="<?=lang('new_price')?>">
                            <?}?>
                            <input type="hidden" id="nNet_Price" name="nNet_Price">
                            <input type="hidden" id="nNet_Price_wholesale" name="nNet_Price_wholesale">
                        </div>                        
                        <div class="form-group">
                            <?=lang('quantity', 'nQuantity')?>
                            <input type="number" class="form-control input-sm kb-pad" id="nQuantity" onClick="this.select();" placeholder="<?=lang('current_quantity')?>">
                        </div>
                        <div class="form-group">
                            <?=lang('discount', 'nDiscount')?>
                            <?if ($Settings->staff_change_pos_discount == 0 && !$Admin) { ?>
                            <input type="text" class="form-control input-sm kb-pad" id="nDiscount" readonly onClick="this.select();" placeholder="<?=lang('discount')?>">
                            <?} else { ?>
                            <input type="text" class="form-control input-sm kb-pad" id="nDiscount" onClick="this.select();" placeholder="<?=lang('discount')?>">
                            <?}?>
                        </div>
                        <?php if ($Settings->show_product_options) { ?>
                        <div class="form-group">
                            <?= lang('product_options_group', 'poptions_group'); ?>
                            <?php
                                $cat['0'] = lang("select")." ".lang("group");
                                foreach($groups as $group) {
                                    $cat[$group->id] = $group->name;
                                }
                            ?>
                            <?= form_dropdown('poptions_group', $cat, '0', 'class="form-control select2 tip" id="poptions_group" style="width:100%;"'); ?>
                        </div>     
                        <?php } ?>  
                    </div>
                    <?php /* if ($Settings->show_icesugar) { ?>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?=lang('Sugar', 'nSugar')?>
                            <?php $opts = array('0' => 'Select One...', '1' => '100%', '2' => '80%', '3' => '50%', '4' => '30%'); ?>
                            <?= form_dropdown('nSugar', $opts, 0,'class="form-control select2" id="nSugar" style="width:100%;"'); ?>
                        </div>
                        <div class="form-group">
                            <?=lang('Ice', 'nIce')?>
                            <?php $opts = array('0' => 'Select One...', '1' => 'Normal', '2' => 'Medium', '3' => 'Less'); ?>
                            <?= form_dropdown('nIce', $opts, 0,'class="form-control select2" id="nIce" style="width:100%;"'); ?>
                        </div>
                    </div>
                    <?php } */?>
                    <?php if ($Settings->show_product_options) { ?>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?=lang('text_modifier', 'nProduct_options')?>
                            <input type="text" class="form-control input-sm kb-pad" id="nProduct_options" onClick="this.select();" placeholder="<?=lang('text_modifier')?>">
                        </div>
                        <div class="form-group">
                            <?=lang('pro_opt1', 'nPro_opt1')?>
                            <?php $opt1 = array('0' => 'Select One...'); ?>
                            <?php foreach($pro_opt1s as $pro_opt1){ $opt1[$pro_opt1->id] = $pro_opt1->name; } ?>
                            <?= form_dropdown('nPro_opt1', $opt1, '0','class="form-control select2" id="nPro_opt1" style="width:100%;"'); ?>
                            <input type="hidden" name="nPro_opt1_price" id="nPro_opt1_price">
                        </div>
                        <div class="form-group">
                            <?=lang('pro_opt2', 'nPro_opt2')?>
                            <?php $opt2 = array('0' => 'Select One...'); ?>
                            <?php foreach($pro_opt2s as $pro_opt2){ $opt2[$pro_opt2->id] = $pro_opt2->name; } ?>
                            <?= form_dropdown('nPro_opt2', $opt2, '0','class="form-control select2" id="nPro_opt2" style="width:100%;"'); ?>
                            <input type="hidden" name="nPro_opt2_price" id="nPro_opt2_price">
                        </div>                        
                        <div class="form-group">
                            <?=lang('pro_opt3', 'nPro_opt3')?>
                            <?php $opt3 = array('0' => 'Select One...'); ?>
                            <?php foreach($pro_opt3s as $pro_opt3){ $opt3[$pro_opt3->id] = $pro_opt3->name; } ?>
                            <?= form_dropdown('nPro_opt3', $opt3, '0','class="form-control select2" id="nPro_opt3" style="width:100%;"'); ?>
                            <input type="hidden" name="nPro_opt3_price" id="nPro_opt3_price">
                        </div>
                        <div class="form-group">
                            <?=lang('pro_opt4', 'nPro_opt4')?>
                            <?php $opt4 = array('0' => 'Select One...'); ?>
                            <?php foreach($pro_opt4s as $pro_opt4){ $opt4[$pro_opt4->id] = $pro_opt4->name; } ?>
                            <?= form_dropdown('nPro_opt4', $opt4, '0','class="form-control select2" id="nPro_opt4" style="width:100%;"'); ?>
                            <input type="hidden" name="nPro_opt4_price" id="nPro_opt4_price">
                        </div>                        
                    </div>
                    <?php } ?>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <?=lang('comment', 'nComment')?>
                            <textarea class="form-control kb-text" id="nComment"></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?=lang('close')?></button>
                <button class="btn btn-success" id="editItem"><?=lang('update')?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="susModal" tabindex="-1" role="dialog" aria-labelledby="susModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="susModalLabel"><?= lang('suspend_sale'); ?></h4>
            </div>
            <div class="modal-body">
                <p><?= lang('type_reference_note'); ?></p>

                <div class="form-group">
                    <?= lang("reference_note", "reference_note"); ?>
                    <?php echo form_input('reference_note', $reference_note, 'class="form-control kb-text" id="reference_note"'); ?>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal"> <?=lang('close')?> </button>
                <button type="button" id="suspend_sale" class="btn btn-primary"><?= lang('submit') ?></button>
            </div>
        </div>
    </div>
</div>



<div class="modal" data-easein="flipYIn" id="saleModal" tabindex="-1" role="dialog" aria-labelledby="saleModalLabel" aria-hidden="true"></div>
<div class="modal" data-easein="flipYIn" id="opModal" tabindex="-1" role="dialog" aria-labelledby="opModalLabel" aria-hidden="true"></div>

<div class="modal" data-easein="flipYIn" id="payModal" tabindex="-1" role="dialog" aria-labelledby="payModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-success">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="payModalLabel">
                    <?=lang('payment')?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-xs-9">
                        <div class="font16">
                            <table class="table table-bordered table-condensed" style="margin-bottom: 0;">
                                <tbody>
                                    <tr>
                                        <td width="25%" style="border-right-color: #FFF !important;"><?= lang("total_items"); ?></td>
                                        <td width="25%" class="text-right"><span id="item_count">0.00</span></td>
                                        <td width="25%" style="border-right-color: #FFF !important;"><?= lang("total_paying"); ?></td>
                                        <td width="25%" class="text-right"><span id="total_paying">0.00</span></td>
                                        
                                    </tr>
                                    <tr>
                                        <td style="border-right-color: #FFF !important;"><?= lang("total_payable"); ?> (<?=$Settings->symbol?>)</td>
                                        <td class="text-right"><span id="twt">0.00</span></td>
                                        <td style="border-right-color: #FFF !important;"><?= lang("balance"); ?></td>
                                        <td class="text-right"><span id="balance">0.00</span></td>                                                                                
                                    </tr>
                                    <?php if ($Settings->exchange_rate > 0) { ?>
                                    <tr>                                        
                                        <td style="border-right-color: #FFF !important;"><?= lang("total_payable"); ?> (<?=$Settings->exchange_rate_symbol?>)</td>
                                        <td class="text-right"><span id="twt_exc">0.00</span></td>                               
                                        <td style="border-right-color: #FFF !important;"><?= lang("balance"); ?> (<?=$Settings->exchange_rate_symbol?>)</td>                                        
                                        <td class="text-right"><span id="balance_exc">0.00</span></td>    
                                    </tr>
                                    <?php } ?> 
                                    <?php if ($Settings->exchange_rate2 > 0) { ?>
                                    <tr>
                                        <td style="border-right-color: #FFF !important;"><?= lang("total_payable"); ?> (<?=$Settings->exchange_rate2_symbol?>)</td>
                                        <td class="text-right"><span id="twt_exc2">0.00</span></td>                                    
                                        <td style="border-right-color: #FFF !important;"><?= lang("balance"); ?> (<?=$Settings->exchange_rate2_symbol?>)</td>
                                        <td class="text-right"><span id="balance_exc2">0.00</span></td>      
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                            <div class="clearfix"></div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang('note', 'note'); ?>
                                    <input name="note" id="note" class="pa form-control kb-text"/>
                                </div>
                            </div>                            
                        </div>
                        <div class="row">
                            <div class="col-xs-12" style="display:none;">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?>
                                    <input name="amount" type="text" id="amount" class="pa form-control kb-pad amount"/>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?> (<?=$Settings->symbol?>)
                                    <input name="amount_main" type="text" id="amount_main" onClick='this.select();' class="pa form-control kb-pad amount_main"/>
                                </div>
                            </div>
                            <?php if ($Settings->exchange_rate > 0) { ?>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?> (<?=$Settings->exchange_rate_symbol?>)
                                    <input name="amount_exc" type="text" id="amount_exc" onClick='this.select();' class="pa form-control kb-pad amount_exc"/>
                                </div>
                            </div>
                            <?php } else { ?>
                            <div class="col-xs-12" style="display:none;">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?> (<?=$Settings->exchange_rate_symbol?>)
                                    <input name="amount_exc" type="text" id="amount_exc" onClick='this.select();' class="pa form-control kb-pad amount_exc"/>
                                </div>
                            </div>
                            <?php } ?>
                            <?php if ($Settings->exchange_rate2 > 0) { ?>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?> (<?=$Settings->exchange_rate2_symbol?>)
                                    <input name="amount_exc2" type="text" id="amount_exc2" onClick='this.select();' class="pa form-control kb-pad amount_exc2"/>
                                </div>
                            </div>
                            <?php } else { ?>
                            <div class="col-xs-12" style="display:none;">
                                <div class="form-group">
                                    <?= lang("amount", "amount"); ?> (<?=$Settings->exchange_rate2_symbol?>)
                                    <input name="amount_exc2" type="text" id="amount_exc2" onClick='this.select();' class="pa form-control kb-pad amount_exc2"/>
                                </div>
                            </div>
                            <?php } ?>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang("paying_by", "paid_by"); ?>
                                    <select id="paid_by" class="form-control paid_by select2" style="width:100%;">
                                        <option value="cash"><?= lang("cash"); ?></option>
                                        <option value="ABA"><?= lang("ABA"); ?></option>
                                        <option value="ACLEDA"><?= lang("ACLEDA"); ?></option>
                                        <option value="WING"><?= lang("WING"); ?></option>
                                        <?//= isset($Settings->stripe) ? '<option value="stripe">' . lang("stripe") . '</option>' : ''; ?>
                                        <option value="other"><?= lang("other_sale"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <?= lang("payment_note", "payment_note"); ?>
                                    <input type="text" id="payment_note"
                                    class="form-control payment_note kb-text"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group gc" style="display: none;">
                                    <?= lang("gift_card_no", "gift_card_no"); ?>
                                    <input type="text" id="gift_card_no"
                                    class="pa form-control kb-pad gift_card_no gift_card_input"/>

                                    <div id="gc_details"></div>
                                </div>
                                <div class="pcc" style="display:none;">
                                    <div class="form-group">
                                        <input type="text" id="swipe" class="form-control swipe swipe_input"
                                        placeholder="<?= lang('focus_swipe_here') ?>"/>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-6">
                                            <div class="form-group">
                                                <input type="text" id="pcc_no"
                                                class="form-control kb-pad"
                                                placeholder="<?= lang('cc_no') ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-xs-6">
                                            <div class="form-group">

                                                <input type="text" id="pcc_holder"
                                                class="form-control kb-text"
                                                placeholder="<?= lang('cc_holder') ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-xs-3">
                                            <div class="form-group">
                                                <select id="pcc_type"
                                                class="form-control pcc_type select2"
                                                placeholder="<?= lang('card_type') ?>">
                                                <option value="Visa"><?= lang("Visa"); ?></option>
                                                <option
                                                value="MasterCard"><?= lang("MasterCard"); ?></option>
                                                <option value="Amex"><?= lang("Amex"); ?></option>
                                                <option
                                                value="Discover"><?= lang("Discover"); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xs-3">
                                        <div class="form-group">
                                            <input type="text" id="pcc_month"
                                            class="form-control kb-pad"
                                            placeholder="<?= lang('month') ?>"/>
                                        </div>
                                    </div>
                                    <div class="col-xs-3">
                                        <div class="form-group">

                                            <input type="text" id="pcc_year"
                                            class="form-control kb-pad"
                                            placeholder="<?= lang('year') ?>"/>
                                        </div>
                                    </div>
                                    <div class="col-xs-3">
                                        <div class="form-group">

                                            <input type="text" id="pcc_cvv2"
                                            class="form-control kb-pad"
                                            placeholder="<?= lang('cvv2') ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pcheque" style="display:none;">
                                <div class="form-group"><?= lang("cheque_no", "cheque_no"); ?>
                                    <input type="text" id="cheque_no"
                                    class="form-control cheque_no kb-text"/>
                                </div>
                            </div>
                            <!--<div class="pcash"> -->
                            <div class="cash">
                                <div class="form-group">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-3 text-center">
                    <!-- <span style="font-size: 1.2em; font-weight: bold;"><?= lang('quick_cash'); ?></span> -->

                    <div class="btn-group btn-group-vertical" style="width:100%;">
                        <button type="button" class="btn btn-info btn-block quick-cash" id="quick-payable">0.00
                        </button>
                        <?php
                        foreach (lang('quick_cash_notes') as $cash_note_amount) {
                            echo '<button type="button" class="btn btn-block btn-warning quick-cash">' . $cash_note_amount . '</button>';
                        }
                        ?>
                        <button type="button" class="btn btn-block btn-danger"
                        id="clear-cash-notes"><?= lang('clear'); ?></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal"> <?=lang('close')?> </button>
            <button class="btn btn-primary" id="<?= $eid ? '' : 'submit-sale'; ?>"><?=lang('submit')?></button>
        </div>
    </div>
</div>
</div>

<div class="modal" data-easein="flipYIn" id="customerModal" tabindex="-1" role="dialog" aria-labelledby="cModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header modal-primary">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="cModalLabel">
                    <?=lang('add_customer')?>
                </h4>
            </div>
            <?= form_open('pos/add_customer', 'id="customer-form"'); ?>
            <div class="modal-body">
                <div id="c-alert" class="alert alert-danger" style="display:none;"></div>
                <div class="row">
                    <div class="col-xs-12">
                        <div class="form-group">
                            <label class="control-label" for="code">
                                <?= lang("name"); ?>
                            </label>
                            <?= form_input('name', '', 'class="form-control input-sm kb-text" id="cname"'); ?>
                        </div>
                        <?php if ($Settings->show_customer_group) { ?>
                        <div class="form-group">
                        <?php } else { ?>
                        <div class="form-group" style="display:none;">
                        <?php } ?>
                            <?= lang('customer_group', 'customer_group'); ?>
                            <?php
                            $cat[''] = lang("select")." ".lang("customer_group");
                            foreach($customer_group as $group) {
                                $cat[$group->id] = $group->name;
                            }
                            ?>
                            <?= form_dropdown('group_id', $cat, set_value('group_id'), 'class="form-control select2 tip" id="group_id" style="width:100%;"'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">                    
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="phone">
                                <?= lang("phone"); ?>
                            </label>
                            <?= form_input('phone', '', 'class="form-control input-sm kb-pad" id="cphone"');?>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="cf1">
                                <?= lang("ccf1"); ?>
                            </label>
                            <?= form_input('cf1', '', 'class="form-control input-sm kb-text" id="cf1"'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">                                        
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="cf2">
                                <?= lang("ccf2"); ?>
                            </label>
                            <?= form_input('cf2', '', 'class="form-control input-sm kb-text" id="cf2"');?>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="cemail">
                                <?= lang("email_address"); ?>
                            </label>
                            <?= form_input('email', '', 'class="form-control input-sm kb-text" id="cemail"'); ?>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label class="control-label" for="discount">
                                <?= lang("discount"); ?>
                            </label>
                            <?= form_input('discount', '', 'class="form-control input-sm kb-text" id="discount"');?>
                        </div>
                    </div>
                </div>

            </div>
            <div class="modal-footer" style="margin-top:0;">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal"> <?=lang('close')?> </button>
                <button type="submit" class="btn btn-primary" id="add_customer"> <?=lang('add_customer')?> </button>
            </div>
            <?= form_close(); ?>
        </div>
    </div>
</div>

<div class="modal" data-easein="flipYIn" id="posModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"></div>
<div class="modal" data-easein="flipYIn" id="posModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel2" aria-hidden="true"></div>

<script type="text/javascript">
    var base_url = '<?=base_url();?>', assets = '<?= $assets ?>';
    var dateformat = '<?=$Settings->dateformat;?>', timeformat = '<?= $Settings->timeformat ?>';
    <?php unset($Settings->protocol, $Settings->smtp_host, $Settings->smtp_user, $Settings->smtp_pass, $Settings->smtp_port, $Settings->smtp_crypto, $Settings->mailpath, $Settings->timezone, $Settings->setting_id, $Settings->default_email, $Settings->version, $Settings->stripe, $Settings->stripe_secret_key, $Settings->stripe_publishable_key); ?>
    var Settings = <?= json_encode($Settings); ?>;
    var sid = false, username = '<?=$this->session->userdata('username');?>', spositems = {};
    $(window).load(function () {
        $('#mm_<?=$m?>').addClass('active');
        $('#<?=$m?>_<?=$v?>').addClass('active');
        $("#spos_customer").change();
    });
    var pro_limit = <?=$Settings->pro_limit?>, java_applet = 0, count = 1, total = 0, an = 1, p_page = 0, page = 0, cat_id = <?=$Settings->default_category?>, tcp = <?=$tcp?>;
    var gtotal = 0, order_discount = 0, order_tax = 0, protect_delete = <?= ($Admin) ? 0 : ($Settings->pin_code ? 1 : 0); ?>;
    var order_data = {}, bill_data = {};
    var csrf_hash = '<?= $this->security->get_csrf_hash(); ?>';
    <?php
    if ($Settings->remote_printing == 2) {

        ?>
        var ob_store_name = "<?= printText($store->name, (!empty($printer) ? $printer->char_per_line : '')); ?>\r\n";
        order_data.store_name = ob_store_name;
        bill_data.store_name = ob_store_name;

        ob_header = "";
        ob_header += "<?= printText($store->name.' ('.$store->code.')', (!empty($printer) ? $printer->char_per_line : '')); ?>\r\n";
        <?php
        if ($store->address1) { ?>
            ob_header += "<?= printText($store->address1, (!empty($printer) ? $printer->char_per_line : ''));?>\r\n";
            <?php
        }
        if ($store->address2) { ?>
            ob_header += "<?= printText($store->address2, (!empty($printer) ? $printer->char_per_line : ''));?>\r\n";
            <?php
        }
        if ($store->city) { ?>
            ob_header += "<?= printText($store->city, (!empty($printer) ? $printer->char_per_line : ''));?>\r\n";
            <?php
        } ?>
        ob_header += "<?= printText(lang('tel').': '.$store->phone, (!empty($printer) ? $printer->char_per_line : ''));?>\r\n\r\n";
        ob_header += "<?= printText(str_replace( array( "\n", "\r" ), array( "\\n", "\\r" ), $store->receipt_header), (!empty($printer) ? $printer->char_per_line : ''));?>\r\n\r\n";

        order_data.header = ob_header + "<?= printText(lang('order'), (!empty($printer) ? $printer->char_per_line : '')); ?>\r\n\r\n";
        bill_data.header = ob_header + "<?= printText(lang('bill'), (!empty($printer) ? $printer->char_per_line : '')); ?>\r\n\r\n";
        order_data.totals = '';
        order_data.payments = '';
        bill_data.payments = '';
        order_data.footer = '';
        bill_data.footer = "<?= $store->receipt_footer ?> \n";
        <?php
    }
    ?>
    var lang = new Array();
    lang['code_error'] = '<?= lang('code_error'); ?>';
    lang['r_u_sure'] = '<?= lang('r_u_sure'); ?>';
    lang['please_add_product'] = '<?= lang('please_add_product'); ?>';
    lang['paid_less_than_amount'] = '<?= lang('paid_less_than_amount'); ?>';
    lang['x_suspend'] = '<?= lang('x_suspend'); ?>';
    lang['discount_title'] = '<?= lang('discount_title'); ?>';
    lang['update'] = '<?= lang('update'); ?>';
    lang['tax_title'] = '<?= lang('tax_title'); ?>';
    lang['leave_alert'] = '<?= lang('leave_alert'); ?>';
    lang['close'] = '<?= lang('close'); ?>';
    lang['delete'] = '<?= lang('delete'); ?>';
    lang['no_match_found'] = '<?= lang('no_match_found'); ?>';
    lang['wrong_pin'] = '<?= lang('wrong_pin'); ?>';
    lang['file_required_fields'] = '<?= lang('file_required_fields'); ?>';
    lang['enter_pin_code'] = '<?= lang('enter_pin_code'); ?>';
    lang['incorrect_gift_card'] = '<?= lang('incorrect_gift_card'); ?>';
    lang['card_no'] = '<?= lang('card_no'); ?>';
    lang['value'] = '<?= lang('value'); ?>';
    lang['balance'] = '<?= lang('balance'); ?>';
    lang['unexpected_value'] = '<?= lang('unexpected_value'); ?>';
    lang['inclusive'] = '<?= lang('inclusive'); ?>';
    lang['exclusive'] = '<?= lang('exclusive'); ?>';
    lang['total'] = '<?= lang('total'); ?>';
    lang['total_items'] = '<?= lang('total_items'); ?>';
    lang['order_tax'] = '<?= lang('order_tax'); ?>';
    lang['order_discount'] = '<?= lang('order_discount'); ?>';
    lang['total_payable'] = '<?= lang('total_payable'); ?>';
    lang['rounding'] = '<?= lang('rounding'); ?>';
    lang['grand_total'] = '<?= lang('grand_total'); ?>';
    lang['register_open_alert'] = '<?= lang('register_open_alert'); ?>';
    lang['discount'] = '<?= lang('discount'); ?>';
    lang['order'] = '<?= lang('order'); ?>';
    lang['bill'] = '<?= lang('bill'); ?>';
    <?php /* lang['merchant_copy'] = '<?= lang('merchant_copy'); echo '<br><img src="'.base_url('uploads/'.$store->promotion_photo).'" alt="'.$store->name.'" height="120px">';?>'; */?>
    lang['merchant_copy'] = '<?= lang('merchant_copy'); ?>';
    lang['description'] = '<?=lang('description');?>';
    lang['quantity'] = '<?=lang('quantity');?>';
    lang['subtotal'] = '<?=lang('subtotal');?>';
    lang['date'] = '<?=lang('date');?>';
    lang['sale_no_ref'] = '<?=lang('sale_no_ref');?>';
    lang['customer'] = '<?=lang('customer');?>';
    lang['sales_person'] = '<?=lang('sales_person');?>';
    lang['date_in'] = '<?=lang('date_in');?>';
    lang['date_out'] = '<?=lang('date_out');?>';
    lang['duration'] = '<?=lang('duration');?>';
    lang['price'] = '<?=lang('price');?>';
    lang['unit'] = '<?=lang('unit');?>';
	
    $(document).ready(function() {
        
        $(".slide-toggle").click(function(){
            $(".pos-toggle").animate({
                width: "toggle"
            });
        });
        <?php if ($this->session->userdata('rmspos')) { ?>
            if (get('spositems')) { remove('spositems'); }
            if (get('spos_discount')) { remove('spos_discount'); }
            if (get('spos_tax')) { remove('spos_tax'); }
            if (get('spos_note')) { remove('spos_note'); }
            if (get('spos_customer')) { remove('spos_customer'); }
            if (get('amount')) { remove('amount'); }
            <?php $this->tec->unset_data('rmspos'); } ?>

            if (get('rmspos')) {
                if (get('spositems')) { remove('spositems'); }
                if (get('spos_discount')) { remove('spos_discount'); }
                if (get('spos_tax')) { remove('spos_tax'); }
                if (get('spos_note')) { remove('spos_note'); }
                if (get('spos_customer')) { remove('spos_customer'); }
                if (get('amount')) { remove('amount'); }
                remove('rmspos');
            }
            <?php if ($sid) { ?>

                store('spositems', JSON.stringify(<?=$items;?>));
                store('spos_discount', '<?=$suspend_sale->order_discount_id;?>');
                store('spos_tax', '<?=$suspend_sale->order_tax_id;?>');
                store('spos_customer', '<?=$suspend_sale->customer_id;?>');
                <? if ($Settings->hold_customer) { ?>
                    $('#spos_customer').append('<option value="<?=$suspend_sale->customer_id;?>"><?=$suspend_sale->customer_name;?></option>');
                <? } ?>            
                $('#spos_customer').select2().select2('val', '<?=$suspend_sale->customer_id;?>');
                store('rmspos', '1');
                $('#tax_val').val('<?=$suspend_sale->order_tax_id;?>');
                $('#discount_val').val('<?=$suspend_sale->order_discount_id;?>');
                $('#date_in').val('<?=$suspend_sale->date_in;?>');
                <?php } elseif ($eid) { ?>
                    $('#date').inputmask("y-m-d h:s:s", { "placeholder": "YYYY/MM/DD HH:mm:ss" });
                    store('spositems', JSON.stringify(<?=$items;?>));
                    store('spos_discount', '<?=$sale->order_discount_id;?>');
                    store('spos_tax', '<?=$sale->order_tax_id;?>');
                    store('spos_customer', '<?=$sale->customer_id;?>');
                    store('sale_date', '<?=$sale->date;?>');
                    <? if ($Settings->hold_customer) { ?>
                        $('#spos_customer').append('<option value="<?=$suspend_sale->customer_id;?>"><?=$suspend_sale->customer_name;?></option>');
                    <? } ?>
                    $('#spos_customer').select2().select2('val', '<?=$sale->customer_id;?>');
                    $('#date').val('<?=$sale->date;?>');
                    $('#date_in').val('<?=$sale->date_in;?>');
                    store('rmspos', '1');
                    $('#tax_val').val('<?=$sale->order_tax_id;?>');
                    $('#discount_val').val('<?=$sale->order_discount_id;?>');
                    <?php } else { ?>
                        if (! get('spos_discount')) {
                            store('spos_discount', '<?=$Settings->default_discount;?>');
                            $('#discount_val').val('<?=$Settings->default_discount;?>');
                        }
                        if (! get('spos_tax')) {
                            store('spos_tax', '<?=$Settings->default_tax_rate;?>');
                            $('#tax_val').val('<?=$Settings->default_tax_rate;?>');
                        }
                        <?php } ?>

                        if (ots = get('spos_tax')) {
                            $('#tax_val').val(ots);
                        }
                        if (ods = get('spos_discount')) {
                            $('#discount_val').val(ods);
                        }
                        bootbox.addLocale('bl',{OK:'<?= lang('ok'); ?>',CANCEL:'<?= lang('cancel'); ?>',CONFIRM:'<?= lang('yes'); ?>'});
                        bootbox.setDefaults({closeButton:false,locale:"bl"});
                        <?php if ($eid) { ?>
                            $('#suspend').attr('disabled', true);
                            $('#print_order').attr('disabled', true);
                            $('#print_bill').attr('disabled', true);
                            <?php } ?>
                        });
                    </script>
                    <script type="text/javascript">
                        var socket = null;
                        <?php
                        if ($Settings->remote_printing == 2) {
                            ?>
                            try {
                                socket = new WebSocket('ws://127.0.0.1:6441');
                                socket.onopen = function () {
                                    console.log('Connected');
                                    return;
                                };
                                socket.onclose = function () {
                                    console.log('Connection closed');
                                    return;
                                };
                            } catch (e) {
                                console.log(e);
                            }
                            <?php
                        }
                        ?>									
                        function printBill(bill) {
                            if (Settings.remote_printing == 1) {
                                //Popup2($('#bill_tbl').html());
                                
                                printJS({
                                    printable:'bill_tbl',
                                    type:'html',
                                    style:'@page{margin:5px 10px 5px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:10px; line-height: 1.5;} h5{margin:5px; font-size:11px; font-weight:normal;} table{font-size:10px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid; margin-top:10px;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%; margin-top:10px;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:12px; color:#fff;} td{padding:5px;} div#qrcode{text-align:center;}'
                                });  
                                                         
                            } else if (Settings.remote_printing == 2) {
                                if (socket.readyState == 1) {
                                    if (Settings.print_img == 1) {
                                        $('#bill-data').show();
                                        $('#preb').html(
                                            '<pre style="background:#FFF;font-size:20px;margin:0;border:0;color:#000 !important;">' +
                                            bill_data.info +
                                            bill_data.items +
                                            '\n' +
                                            bill_data.totals +
                                            '</pre>'
                                            );
                                        var element = $('#bill-data').get(0);
                                        html2canvas(element, {scrollY: 0, scale: 1.7}).then(function(canvas) {
                                            var dataURL = canvas.toDataURL();
                                            var socket_data = {
                                                'printer': <?= $Settings->local_printers ? "''" : json_encode($printer); ?>,
                                                'text': dataURL, 'cash_drawer': 0
                                            };
                                            socket.send(JSON.stringify({
                                                type: 'print-img',
                                                data: socket_data
                                            }));
                                            // return Canvas2Image.saveAsPNG(canvas);
                                        });
                                        setTimeout(function() {
                                            $('#bill-data').hide();
                                        }, 500);
                                    } else {
                                        var socket_data = {'printer': <?= $Settings->local_printers ? "''" : json_encode($printer); ?>, 'logo': '<?= !empty($store->logo) ? base_url('uploads/'.$store->logo) : ''; ?>', 'text': bill};
                                        socket.send(JSON.stringify({
                                            type: 'print-receipt',
                                            data: socket_data
                                        }));
                                    }
                                    return false;
                                } else {
                                    bootbox.alert('<?= lang('pos_print_error'); ?>');
                                    return false;
                                }
                            }
                        }
                        var order_printers = <?= $Settings->local_printers ? "''" : json_encode($order_printers); ?>;
                        function printOrder(order) {
                            if (Settings.remote_printing == 1) {
                                //Popup2($('#order_tbl').html());
                                
                                printJS({
                                    printable:'order_tbl',
                                    type:'html',
                                    style:'@page{margin:5px 10px 5px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:10px; line-height: 1.5;} h5{margin:5px; font-size:11px; font-weight:normal;} table{font-size:10px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%; margin-top:10px;} p{font-size:13px; font-weight:bold; margin:0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:12px; color:#fff;} td{padding:5px;}'
                                });
                                
                            } else if (Settings.remote_printing == 2) {
                                if (socket.readyState == 1) {
                                    if (Settings.print_img == 1) {
                                        $('#order-data').show();
                                        $('#preo').html(
                                            '<pre style="background:#FFF;font-size:20px;margin:0;border:0;color:#000 !important;">' + order_data.info + order_data.items + '</pre>'
                                            );
                                        var element = $('#order-data').get(0);
                                        html2canvas(element, {scrollY: 0, scale: 1.7}).then(function(canvas) {
                                            var dataURL = canvas.toDataURL();
                                            var socket_data = {
                                                'printer': <?= $Settings->local_printers ? "''" : json_encode($printer); ?>,
                                                'text': dataURL, 'order': 1, 'cash_drawer': 0
                                            };
                                            socket.send(JSON.stringify({
                                                type: 'print-img',
                                                data: socket_data
                                            }));
                                            // return Canvas2Image.saveAsPNG(canvas);
                                        });
                                        setTimeout(function() {
                                            $('#order-data').hide();
                                        }, 500);										
                                    } else {
                                        if (order_printers == '') {
                                            var socket_data = { 'printer': false, 'order': true,
                                            'logo': '<?= !empty($store->logo) ? base_url('uploads/'.$store->logo) : ''; ?>',
                                            'text': order };
                                            socket.send(JSON.stringify({type: 'print-receipt', data: socket_data}));
                                        } else {
                                            $.each(order_printers, function() {
                                                var socket_data = {'printer': this, 'logo': '<?= !empty($store->logo) ? base_url('uploads/'.$store->logo) : ''; ?>', 'text': order};
                                                socket.send(JSON.stringify({type: 'print-receipt', data: socket_data}));
                                            });
                                        }
                                    }
                                    return false;
                                } else {
                                    bootbox.alert('<?= lang('pos_print_error'); ?>');
                                    return false;
                                }
                            }
                        }
						function Popup2(data) {
							var mywindow = window.open('', 'spos_print', 'height=500,width=300');
							mywindow.document.write('<html><head><title>Print</title>');
                            //mywindow.document.write('<link rel="stylesheet" href="<?= $assets ?>bootstrap/css/bootstrap.min.css" type="text/css" />');
                            mywindow.document.write('<style type="text/css">@page{margin:2px 5px;} * { -webkit-print-color-adjust: exact !important; /* Chrome, Safari */ color-adjust: exact !important; /*Firefox*/ } body{font-family:"Battambang", "Khmer OS Battambang"; font-size:'+<?= $Settings->receipt_font_size?>+'px; line-height: 1.5;} h5{margin:0; font-size:'+<?= $Settings->receipt_font_size+1;?>+'px; font-weight:normal;} table{font-size:'+<?= $Settings->receipt_font_size?>+'px; border-collapse: collapse;} thead{background-color:#000; color:#fff;} table#bill-table{border-bottom: 1px solid; border-top: 1px solid;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; margin-top:10px;} p{margin:5px 0;}</style>');
							mywindow.document.write('</head><body >');
							mywindow.document.write('<div id="order_tbl">');
							mywindow.document.write(data);
							mywindow.document.write('</div></body></html>');
							setTimeout(function() {
								mywindow.print();
								mywindow.close();
							}, 250);
							return true;
                        }                                            
                    </script>
                    <?php
                    if (isset($print) && !empty($print)) {
                        /* include FCPATH.'themes'.DIRECTORY_SEPARATOR.$Settings->theme.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'pos'.DIRECTORY_SEPARATOR.'remote_printing.php'; */
                        include 'remote_printing.php';
                    }
                    ?>
					
                    <script src="<?= $assets ?>dist/js/libraries.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/scripts.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/pos.min.js" type="text/javascript"></script>
                    <script src="<?= $assets ?>dist/js/print.min.js" type="text/javascript"></script>
                    <?php if($Settings->remote_printing != 1 && $Settings->print_img) { ?>
                    <script src="<?= $assets ?>dist/js/htmlimg.js"></script>
                    <?php } ?>
    </body>
</html>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    });
    function toggleFullScreen(elem) {
    // ## The below if statement seems to work better ## if ((document.fullScreenElement && document.fullScreenElement !== null) || (document.msfullscreenElement && document.msfullscreenElement !== null) || (!document.mozFullScreen && !document.webkitIsFullScreen)) {
        if ((document.fullScreenElement !== undefined && document.fullScreenElement === null) || (document.msFullscreenElement !== undefined && document.msFullscreenElement === null) || (document.mozFullScreen !== undefined && !document.mozFullScreen) || (document.webkitIsFullScreen !== undefined && !document.webkitIsFullScreen)) {
            if (elem.requestFullScreen) {
                elem.requestFullScreen();
            } else if (elem.mozRequestFullScreen) {
                elem.mozRequestFullScreen();
            } else if (elem.webkitRequestFullscreen) {
                elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
            } else if (elem.msRequestFullscreen) {
                elem.msRequestFullscreen();
            }
        } else {
            if (document.cancelFullScreen) {
                document.cancelFullScreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    }
    $('#submit-sale').click(function(event){
        event.preventDefault;
        $('#submit-sale').attr('disabled','disabled');
    });
</script>
