<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('update_info'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">
                        <?php echo form_open_multipart("adjustments/edit/".$adjustment->id, 'class="validation edit-po-form"'); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('date', 'date'); ?>
                                    <?= form_input('date', set_value('date', $adjustment->date), 'class="form-control tip datetimepicker" id="date"  required="required"'); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('reference', 'reference'); ?>
                                    <?= form_input('reference', $adjustment->reference, 'class="form-control tip" id="reference"'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="text" placeholder="<?= lang('search_product_by_name_code'); ?>" id="add_item" class="form-control">
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table id="poTable" class="table table-striped table-bordered">
                                        <thead>
                                            <tr class="active">
                                                <th><?= lang('product'); ?></th>
                                                <th class="col-xs-2"><?= lang('quantity'); ?></th>
                                                <? if ($Settings->show_unit) { ?>
                                                <th class="col-xs-2"><?= lang('unit'); ?></th>
                                                <? } ?>
                                                <th class="col-xs-2"><?= lang('type'); ?></th>
                                                <th style="width:25px;"><i class="fa fa-trash-o"></i></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                        <tfoot>
                                            <tr class="active">
                                                
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                            <?if (($this->Settings->multi_store) && ($this->Admin)){ ?>
                            
                                <div class="form-group">
                                    <?= lang("store", "store_id"); ?>
                                    <?php
                                    $st[""] = "";
                                    foreach ($stores as $store) {
                                        $st[$store->id] = $store->name;
                                    }
                                    echo form_dropdown('store_id', $st, $adjustment->store_id, 'id="store_id" data-placeholder="' . lang("select") . ' ' . lang("store") . '" class="form-control input-tip select2" style="width:100%;"');
                                    ?>
                                </div>
                            
                            <? } ?>
                            
                        
                        <div class="form-group">
                            <?= lang('attachment', 'attachment'); ?>
                            <input type="file" name="userfile" class="form-control tip" id="attachment">
                        </div>
                        <div class="form-group">
                            <?= lang("note", 'note'); ?>
                            <?= form_textarea('note', $adjustment->note, 'class="form-control redactor" id="note"'); ?>
                        </div>
                        <div class="form-group">
                            <?= form_submit('edit_adjustment', lang('edit_adjustment'), 'class="btn btn-primary" id="edit_adjustment"'); ?>
                            <button type="button" id="reset" class="btn btn-danger"><?= lang('clear'); ?></button>
                        </div>

                        <?php echo form_close();?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script type="text/javascript">
    var spoitems_adj = {};

    $(document).ready(function() {
       store('spoitems_adj', JSON.stringify(<?= $items; ?>));
    });
    $(window).bind('beforeunload', function (e) {
        localStorage.setItem('remove_spo_adj', true);
        $('.animsition').removeClass('fade-out');
        var message = "You will loss data!";
        return message;
    });
    $('#reset').click(function (e) {
        $(window).unbind('beforeunload');
    });
    $('#edit_adjustment').click(function () {
        $(window).unbind('beforeunload');
        $('form.edit-po-form').submit();
    });
</script>

<script src="<?= $assets ?>dist/js/adjustments.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/moment.min.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script type="text/javascript">
    $(function () {
        $('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD HH:mm:ss'
        });
    });
</script>
