<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sales_model extends CI_Model
{

    public function __construct() {
        parent::__construct();
    }

    public function getSaleByID($id) {
        $q = $this->db->get_where('sales', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteInvoice($id) { 
        $osale = $this->getSaleByID($id);
        $oitems = $this->getAllSaleItems($id);
        ($this->Settings->multistore_quantity) ? $store_id = 1 : $store_id = $osale->store_id;
        foreach ($oitems as $oitem) {
            $product = $this->site->getProductByID($oitem->product_id, $store_id);
            if ($product->type == 'standard') {
                $this->db->update('product_store_qty', array('quantity' => ($product->quantity+($oitem->quantity*($oitem->length>0?$oitem->length:1)))), array('product_id' => $product->id, 'store_id' => $store_id));
            } elseif ($product->type == 'combo') {
                $combo_items = $this->getComboItemsByPID($product->id);
                foreach ($combo_items as $combo_item) {
                    $cpr = $this->site->getProductByID($combo_item->id, $store_id);
                    if($cpr->type == 'standard') {
                        $qty = $combo_item->qty * $oitem->quantity;
                        $this->db->update('product_store_qty', array('quantity' => ($cpr->quantity+$qty)), array('product_id' => $cpr->id, 'store_id' => $store_id));
                    }
                }
            }
        }        
        if($this->db->delete('sale_items', array('sale_id' => $id)) &&
        $this->db->delete('sales', array('id' => $id)) && $this->db->delete('payments', array('sale_id' => $id))) {
            //Set Inv Number back to MAX
            if($this->Settings->continue_inv_number) {
                $max_inv_number = $this->getMaxStoreInvNumber($store_id);
                $this->db->update('stores',array('inv_number'=>$max_inv_number),array('id'=>$store_id));
            }
            return true;            
        }        
        return FALSE;
    }

    public function deleteOpenedSale($id) {
        if($this->db->delete('suspended_items', array('suspend_id' => $id)) && $this->db->delete('suspended_sales', array('id' => $id))) {            
            return true;
        }
        return FALSE;
    }

    public function getSalePayments($sale_id) {
        $this->db->order_by('id', 'asc');
        $q = $this->db->get_where('payments', array('sale_id' => $sale_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getPaymentByID($id) {
        $q = $this->db->get_where('payments', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addPayment($data = array()) {
        if ($this->db->insert('payments', $data)) {
            if ($data['paid_by'] == 'gift_card') {
                $gc = $this->site->getGiftCard($data['gc_no']);
                $this->db->update('gift_cards', array('balance' => ($gc->balance - $data['amount'])), array('card_no' => $data['gc_no']));
            }
            $this->syncSalePayments($data['sale_id']);
            return true;
        }
        return false;
    }

    public function updatePayment($id, $data = array()) {
        $payment = $this->getPaymentByID($id);
        if ($payment->paid_by == 'gift_card') {
            $gc = $this->site->getGiftCard($payment->gc_no);
            $this->db->update('gift_cards', array('balance' => ($gc->balance + $payment->amount)), array('card_no' => $payment->gc_no));
        }
        if ($this->db->update('payments', $data, array('id' => $id))) {
            if ($data['paid_by'] == 'gift_card') {
                $gc = $this->site->getGiftCard($data['gc_no']);
                $this->db->update('gift_cards', array('balance' => ($gc->balance - $data['amount'])), array('card_no' => $data['gc_no']));
            }
            $this->syncSalePayments($data['sale_id']);
            return true;
        }
        return false;
    }

    public function deletePayment($id) {
        $payment = $this->getPaymentByID($id);
        if ($payment->paid_by == 'gift_card') {
            $gc = $this->site->getGiftCard($payment->gc_no);
            $this->db->update('gift_cards', array('balance' => ($gc->balance + $payment->amount)), array('card_no' => $payment->gc_no));
        }
        if ($this->db->delete('payments', array('id' => $id))) {
            $this->syncSalePayments($payment->sale_id);
            return true;
        }
        return FALSE;
    }

    public function syncSalePayments($id) {
        $sale = $this->getSaleByID($id);
        $payments = $this->getSalePayments($id);
        $paid = 0;
        $next = '';
        $day =0;
        if($payments) {
            foreach ($payments as $payment) {
                $paid += $payment->amount;
            }
            $day = $payment->alert_payment_day;
            $next = $payment->next_payment;
        }
        $status = $paid <= 0 ? 'due' : ($sale->grand_total <= $paid ? 'paid' : 'partial');
        if ($this->db->update('sales', array('paid' => $paid, 'status' => $status, 'next_payment' => $next, 'alert_payment_day' => $day), array('id' => $id))) {
            return true;
        }

        return FALSE;
    }

    public function updateStatus($id, $status) {
        if ($this->db->update('sales', array('status' => $status), array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function getAllSaleItems($sale_id) {
        $j = "(SELECT id, code, name, tax_method from {$this->db->dbprefix('products')}) P";
        $this->db->select("sale_items.*,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_code IS NULL THEN {$this->db->dbprefix('products')}.code ELSE {$this->db->dbprefix('sale_items')}.product_code END) as product_code,
            (CASE WHEN {$this->db->dbprefix('sale_items')}.product_name IS NULL THEN {$this->db->dbprefix('products')}.name ELSE {$this->db->dbprefix('sale_items')}.product_name END) as product_name,
            {$this->db->dbprefix('products')}.tax_method as tax_method", FALSE)
        ->join('products', 'products.id=sale_items.product_id', 'left outer')
        ->order_by('sale_items.id');
        $q = $this->db->get_where('sale_items', array('sale_id' => $sale_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getAllSalePayments($sale_id) {
        $q = $this->db->get_where('payments', array('sale_id' => $sale_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getCustomerByID($id) {
        $q = $this->db->get_where('customers', array('id' => $id), 1);
          if( $q->num_rows() > 0 ) {
            return $q->row();
          }
          return FALSE;
    }

    public function getComboItemsByPID($product_id) {
        $this->db->select($this->db->dbprefix('products') . '.id as id, ' . $this->db->dbprefix('products') . '.code as code, ' . $this->db->dbprefix('combo_items') . '.quantity as qty, ' . $this->db->dbprefix('products') . '.name as name, ' . $this->db->dbprefix('products') . '.quantity as quantity')
        ->join('products', 'products.code=combo_items.item_code', 'left')
        ->group_by('combo_items.id');
        $q = $this->db->get_where('combo_items', array('product_id' => $product_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getSaleItemByID($id) {
        $this->db->select($this->db->dbprefix('sale_items').".id as id, ". $this->db->dbprefix('sales').".id as saleid, ".$this->db->dbprefix('sales').".date, ".$this->db->dbprefix('sale_items').".product_name, ".$this->db->dbprefix('sale_items').".product_code, ".$this->db->dbprefix('customers').".name as customer_name, ".$this->db->dbprefix('customers').".phone as customer_phone, ".$this->db->dbprefix('sale_items').".next_service_date, ".$this->db->dbprefix('sale_items').".quantity, ".$this->db->dbprefix('sale_items').".subtotal",FALSE)
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left')
        ->join('customers','customers.id=sales.customer_id','left')
        ->where('sale_items.id',$id);
        $q = $this->db->get('sale_items');
        if( $q->num_rows() > 0 ) {
            return $q->row();
        }
        return FALSE;
    }

    public function updateService($id, $data = NULL) {
        if ($this->db->update('sale_items', array('next_service_date' => $data), array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function updateDelivery($id, $data = NULL) {
        if ($this->db->update('sales', array(
                'delivery_by' => $data['delivery_by'],
                'delivery_status' => $data['delivery_status'],
                'delivery_note' => $data['delivery_note'],
                'delivery_staff' => $data['delivery_staff'],
                'delivery_date' => $data['delivery_date'],
                'delivery_attachment' => $data['delivery_attachment']
            ), array('id' => $id))) {
            return true;
        }
        return false;
    }

    public function getDueInvoicesByID($customer_id, $start_date = NULL, $end_date = NULL, $user_id = NULL) {
        $this->db->order_by('id', 'desc');
        if (!$user_id) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->db->select('id, date, customer_name, total, total_tax, total_discount, grand_total, paid, (grand_total-paid) as balance, status, total_cost, (grand_total-total_cost) as profit, inv_number')
            ->where('status <>', 'paid');
        if ($user_id && (! ($this->Admin || $this->Manager))) {
            $this->db->where('created_by', $user_id);
        }
        if ($start_date) {
            $this->db->where('date >=', $start_date . ' 00:00');
        }
        if ($end_date) {
            $this->db->where('date <=', $end_date . ' 23:59');
        }
        $q = $this->db->get_where('sales', array('customer_id' => $customer_id));
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getDueInvoices($customer_id) {
        //$this->db->order_by('id', 'asc');
        $q = $this->db->get_where('sales', array('customer_id' => $customer_id,'status <>' => 'paid'));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function addPaymentMultiple($data = array(),$payment = array()) {
        $due_invoices = $this->getDueInvoices($data['customer_id']);
        $amount_paid = $data['amount-paid'];

        foreach($due_invoices as $due_invoice) {            
            $payment['sale_id'] = $due_invoice->id;
            $payment['amount'] = $amount_paid > $due_invoice->grand_total - $due_invoice->paid ? $due_invoice->grand_total - $due_invoice->paid : $amount_paid;            
            if ($amount_paid > 0 && ($this->db->insert('payments', $payment))) {
                if ($payment['paid_by'] == 'gift_card') {
                    $gc = $this->site->getGiftCard($payment['gc_no']);
                    $this->db->update('gift_cards', array('balance' => ($gc->balance - $payment['amount'])), array('card_no' => $payment['gc_no']));
                }
                $this->syncSalePayments($payment['sale_id']);
                $amount_paid = $amount_paid - $payment['amount'];                
            }   
        }
        return true;
    }

    public function getMaxStoreInvNumber($store_id = 1) {
        $this->db->select_max('inv_number');
        $this->db->from('sales');
        $this->db->where('store_id',$store_id);
        return $this->db->get()->row()->inv_number;
    }

}
