<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Products_model extends CI_Model
{

    public function __construct() {
        parent::__construct();
    }

    public function getAllProducts() {
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getProductsByCategory($category_id = NULL) {
        if ($category_id) {
            $this->db->where('category_id', $category_id);
        }
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function products_count($category_id = NULL) {
        if ($category_id) {
            $this->db->where('category_id', $category_id);
            return $this->db->count_all_results("products");
        } else {
            return $this->db->count_all("products");
        }
    }

    public function fetch_products($limit, $start = null, $category_id = NULL) {
        $this->db->select('name, code, barcode_symbology, price, image')
        ->limit($limit, $start)->order_by("code", "asc");
        if ($category_id) {
            $this->db->where('category_id', $category_id);
        }
        $q = $this->db->get("products");

        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getProductByCode($code) {
        $q = $this->db->get_where('products', array('code' => $code), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addProduct($data, $store_quantities, $items = array()) {
        if ($this->db->insert('products', $data)) {
            $product_id = $this->db->insert_id();
            if(! empty($store_quantities)) {
                foreach ($store_quantities as $store_quantity) {
                    $store_quantity['product_id'] = $product_id;
                    $this->db->insert('product_store_qty', $store_quantity);
                }
            }
            if(! empty($items)) {
                foreach ($items as $item) {
                    $item['product_id'] = $product_id;
                    $this->db->insert('combo_items', $item);
                }
            }
            return true;
        }
        return false;
    }

    public function add_products($data = array()) {
        if ($this->db->insert_batch('products', $data)) {
            return true;
        }
        return false;
    }

    public function updatePriceOld($data = array()) {
        if ($this->db->update_batch('products', $data, 'code')) {
            return true;
        }
        return false;
    }

    public function updateProduct($id, $data = array(), $store_quantities = array(), $items = array(), $photo = NULL) {
        if ($photo) { $data['image'] = $photo; }
        if ($this->db->update('products', $data, array('id' => $id))) {
            if(! empty($store_quantities)) {
                foreach ($store_quantities as $store_quantity) {
                    $store_quantity['product_id'] = $id;
                    $this->setStoreQuantity($store_quantity);
                }
            }
            if(! empty($items)) {
                $this->db->delete('combo_items', array('product_id' => $id));
                foreach ($items as $item) {
                    $item['product_id'] = $id;
                    $this->db->insert('combo_items', $item);
                }
            }
            return true;
        }
        return false;
    }

    public function updatePrice($type = 'increase',$category_id = 0,$percentage,$from = 'price',$price = 0, $price_wholesale = 0, $price_vip = 0) {
        if($type == 'increase'){
            $multiply = 1 + ($percentage/100);
        } else {
            $multiply = 1 - ($percentage/100); 
        }
        if($from == 'price'){
            $new_price = 'price * ' . $multiply;
            $new_price_wholesale = 'price_wholesale * ' . $multiply;
            $new_price_vip = 'price_vip * ' . $multiply;
        } else {
            $new_price = 'cost * ' . $multiply;
            $new_price_wholesale = 'cost * ' . $multiply;
            $new_price_vip = 'cost * ' . $multiply;
        }
        if($type == 'assign') {
            $new_price = $price > 0 ? $price : 'price';
            $new_price_wholesale = $price_wholesale > 0 ? $price_wholesale : 'price_wholesale';
            $new_price_vip = $price_vip > 0 ? $price_vip : 'price_vip';
        }
        if($category_id == 0){
            $this->db->query('update tec_products set price = '.$new_price. ', price_wholesale = '.$new_price_wholesale. ', price_vip = '.$new_price_vip);
            $products = $this->getAllProducts();
            if($from == 'price'){
                $this->db->query('update tec_product_store_qty set price = '.$new_price. ', price_wholesale = '.$new_price_wholesale. ', price_vip = '.$new_price_vip);
            }else{
                foreach ($products as $pr) {
                    $stq_new_price = $pr->cost . ' * ' . $multiply;
                    $stq_new_price_wholesale = $pr->cost . ' * ' . $multiply;
                    $stq_new_price_vip = $pr->cost . ' * ' . $multiply;
                    $this->db->query('update tec_product_store_qty set price = '.$stq_new_price. ', price_wholesale = '.$stq_new_price_wholesale. ', price_vip = '.$stq_new_price_vip.' where product_id='.$pr->id);
                }
            }
            return true;
        } else {
            $this->db->query('update tec_products set price = '.$new_price. ', price_wholesale = '.$new_price_wholesale. ', price_vip = '.$new_price_vip.' where category_id='.$category_id);
            $products = $this->getProductsByCategory($category_id);
            if ($this->Settings->multi_store) {
                $stores = $this->site->getAllStores();
                foreach ($stores as $store) {
                    foreach ($products as $pr) {
                        if($from == 'price'){
                            $stq_new_price = 'price * ' . $multiply;
                            $stq_new_price_wholesale = 'price_wholesale * ' . $multiply;
                            $stq_new_price_vip = 'price_vip * ' . $multiply;
                        }else{
                            $stq_new_price = $pr->cost . ' * ' . $multiply;
                            $stq_new_price_wholesale = $pr->cost . ' * ' . $multiply;
                            $stq_new_price_vip = $pr->cost . ' * ' . $multiply;
                        }
                        $this->db->query('update tec_product_store_qty set price = '.$stq_new_price. ', price_wholesale = '.$stq_new_price_wholesale. ', price_vip = '.$stq_new_price_vip.' where product_id='.$pr->id.' and store_id='.$store->id);
                    }
                }
            } else {
                foreach ($products as $pr) {
                    if($from == 'price'){
                        $stq_new_price = 'price * ' . $multiply;
                        $stq_new_price_wholesale = 'price_wholesale * ' . $multiply;
                        $stq_new_price_vip = 'price_vip * ' . $multiply;
                    }else{
                        $stq_new_price = $pr->cost . ' * ' . $multiply;
                        $stq_new_price_wholesale = $pr->cost . ' * ' . $multiply;
                        $stq_new_price_vip = $pr->cost . ' * ' . $multiply;
                    }
                    $this->db->query('update tec_product_store_qty set price = '.$stq_new_price . ', price_wholesale = '.$stq_new_price_wholesale. ', price_vip = '.$stq_new_price_vip.' where product_id='.$pr->id.' and store_id=1');
                }
            }            
            return true;
        }
        
        return false;
    }

    public function setStoreQuantity($data) {
        if ($this->getStoreQuantity($data['product_id'], $data['store_id'])) {
            $this->db->update('product_store_qty', array('quantity' => $data['quantity'], 'price' => $data['price'], 'price_wholesale' => $data['price_wholesale'], 'price_vip' => $data['price_vip']), array('product_id' => $data['product_id'], 'store_id' => $data['store_id']));
        } else {
            $this->db->insert('product_store_qty', $data);
        }
    }

    public function getStoreQuantity($product_id, $store_id = NULL) {
        if(!$store_id) {
            $store_id = $this->session->userdata('store_id') ? $this->session->userdata('store_id') : 1;
        }
        $q = $this->db->get_where('product_store_qty', array('product_id' => $product_id, 'store_id' => $store_id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getStoresQuantity($product_id) {
        $q = $this->db->get_where('product_store_qty', array('product_id' => $product_id));
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getComboItemsByPID($product_id) {
        $this->db->select($this->db->dbprefix('products') . '.id as id, ' . $this->db->dbprefix('products') . '.code as code, ' . $this->db->dbprefix('combo_items') . '.quantity as qty, ' . $this->db->dbprefix('products') . '.name as name')
        ->join('products', 'products.code=combo_items.item_code', 'left')
        ->group_by('combo_items.id');
        $q = $this->db->get_where('combo_items', array('product_id' => $product_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function deleteProduct($id) {
        if ($this->db->delete('products', array('id' => $id))) {
            return true;
        }
        return FALSE;
    }

    public function getProductNames($term, $limit = 10) {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->where("type != 'combo' AND (name LIKE '%" . $term . "%' OR code LIKE '%" . $term . "%' OR  (name || ' (' || code || ')') LIKE '%" . $term . "%')");
        } else {
            $this->db->where("type != 'combo' AND (name LIKE '%" . $term . "%' OR code LIKE '%" . $term . "%' OR  concat(name, ' (', code, ')') LIKE '%" . $term . "%')");
        }
        $this->db->limit($limit);
        $q = $this->db->get('products');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

}
