<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Unit extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('unit_model');
    }

    function index() {

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['unit'] = $this->site->getAllUnit();
        $this->data['page_title'] = lang('unit');
        $bc = array(array('link' => '#', 'page' => lang('unit')));
        $meta = array('page_title' => lang('unit'), 'bc' => $bc);
        $this->page_construct('unit/index', $this->data, $meta);

    }

    function get_unit() {

        $this->load->library('datatables');
        $this->datatables->select("id, code, name,");
        $this->datatables->from('unit');
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('unit/edit/$1') . "' title='" . lang("edit_unit") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('unit/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_category') . "')\" title='" . lang("delete_unit") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

    function add() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('name', lang('unit_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'), 'name' => $this->input->post('name'));            
        }

        if ($this->form_validation->run() == true && $this->unit_model->addUnit($data)) {

            $this->session->set_flashdata('message', lang('unit_added'));
            redirect("unit");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_unit');
            $bc = array(array('link' => site_url('unit'), 'page' => lang('unit')), array('link' => '#', 'page' => lang('add_unit')));
            $meta = array('page_title' => lang('add_unit'), 'bc' => $bc);
            $this->page_construct('unit/add', $this->data, $meta);
        }
    }

    function edit($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('name', lang('unit_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'), 'name' => $this->input->post('name'));         
        }

        if ($this->form_validation->run() == true && $this->unit_model->updateUnit($id, $data)) {

            $this->session->set_flashdata('message', lang('unit_updated'));
            redirect("unit");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['unit'] = $this->site->getUnitByID($id);
            $this->data['page_title'] = lang('new_unit');
            $bc = array(array('link' => site_url('unit'), 'page' => lang('unit')), array('link' => '#', 'page' => lang('edit_unit')));
            $meta = array('page_title' => lang('edit_unit'), 'bc' => $bc);
            $this->page_construct('unit/edit', $this->data, $meta);

        }
    }

    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->unit_model->deleteUnit($id)) {
            $this->session->set_flashdata('message', lang("unit_deleted"));
            redirect('unit');
        }
    }    
}
