<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sales extends MY_Controller {

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        $this->load->library('form_validation');
        $this->load->model('sales_model');
        $this->load->model('pos_model');
        $this->load->model('reports_model');

        $this->digital_file_types = 'zip|pdf|doc|docx|xls|xlsx|jpg|jpeg|png|gif';

    }

    function index() {
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('sales');
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['customer_group'] = $this->site->getAllCustomerGroup();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('sales')));
        $meta = array('page_title' => lang('sales'), 'bc' => $bc);
        $this->page_construct('sales/index', $this->data, $meta);
    }

    function get_sales() {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $customer_group = $this->input->get('customer_group') ? $this->input->get('customer_group') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select("id, strftime('%Y-%m-%d %H:%M', date) as date, customer_name, (total) as total, (grand_total-paid) as pdue, total_tax, total_discount, grand_total, paid, status, delivery_by, delivery_status, delivery_note, next_payment, alert_payment_day");
        } else {
            $this->datatables->select("{$this->db->dbprefix('sales')}.id, DATE_FORMAT({$this->db->dbprefix('sales')}.date, '%Y-%m-%d %H:%i') as date, {$this->db->dbprefix('sales')}.customer_name, ({$this->db->dbprefix('sales')}.grand_total-{$this->db->dbprefix('sales')}.paid) as pdue, {$this->db->dbprefix('sales')}.total_tax,{$this->db->dbprefix('sales')}.total_discount, {$this->db->dbprefix('sales')}.grand_total, {$this->db->dbprefix('sales')}.paid, {$this->db->dbprefix('sales')}.status, {$this->db->dbprefix('sales')}.delivery_by, {$this->db->dbprefix('sales')}.delivery_status, {$this->db->dbprefix('sales')}.delivery_note, {$this->db->dbprefix('sales')}.next_payment, {$this->db->dbprefix('sales')}.alert_payment_day, {$this->db->dbprefix('customers')}.cf1, {$this->db->dbprefix('customers')}.phone, {$this->db->dbprefix('sales')}.inv_number, ({$this->db->dbprefix('sales')}.total + {$this->db->dbprefix('sales')}.product_discount) as total, ({$this->db->dbprefix('sales')}.total - {$this->db->dbprefix('sales')}.order_discount) as net_total, CONCAT({$this->db->dbprefix('users')}.first_name,' ',{$this->db->dbprefix('users')}.last_name) as sales_person, {$this->db->dbprefix('sales')}.customer_group_name, {$this->db->dbprefix('customers')}.phone, {$this->db->dbprefix('customers')}.cf1");
        }
        $this->datatables->join('customers','customers.id = sales.customer_id','left');
        $this->datatables->join('users','users.id = sales.created_by','left');
        $this->datatables->from('sales');
        if (! ($this->Admin || $this->Manager || $this->Print || $this->SalesReport || $this->AllReports) && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        }
        $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        if ($this->Print) {
            $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1/'.$this->Settings->receipt_format) . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a></div></div>", "id");
        } else {
            if ($this->Settings->show_delivery){
                $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1/'.$this->Settings->receipt_format) . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a> <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a> <a href='" . site_url('pos/?edit=$1') . "' title='".lang("edit_invoice")."' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='".site_url('sales/edit_delivery/$1')."' title='" . lang("edit_delivery") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-truck'></i></a> <a href='" . site_url('sales/delete/$1') . "' onClick=\"return confirm('". lang('alert_x_sale') ."')\" title='".lang("delete_sale")."' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a> </div></div>", "id");
            } else {
                $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1/'.$this->Settings->receipt_format) . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a> <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a> <a href='" . site_url('pos/?edit=$1') . "' title='".lang("edit_invoice")."' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('sales/delete/$1') . "' onClick=\"return confirm('". lang('alert_x_sale') ."')\" title='".lang("delete_sale")."' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a> </div></div>", "id");
            }
        }
        
        // $this->datatables->unset_column('id');
        if($customer) { $this->datatables->where('customer_id', $customer); }
        if($customer_group) { $this->datatables->where('sale_customer_group', $customer_group); }
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();

    }

    function opened() {
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('opened_bills');
        $bc = array(array('link' => '#', 'page' => lang('opened_bills')));
        $meta = array('page_title' => lang('opened_bills'), 'bc' => $bc);
        $this->page_construct('sales/opened', $this->data, $meta);
    }

    function get_opened_list() {

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select("id, date, customer_name, hold_ref, (total_items || ' (' || total_quantity || ')') as items, grand_total", FALSE);
        } else {
            $this->datatables->select("id, date, customer_name, hold_ref, CONCAT(total_items, ' (', total_quantity, ')') as items, grand_total", FALSE);
        }
        $this->datatables->from('suspended_sales');
        if(! ($this->Admin || $this->Manager)) {
            $user_id = $this->session->userdata('user_id');
            $this->datatables->where('created_by', $user_id);
        }
        $this->datatables->where('store_id', $this->session->userdata('store_id'));
        $this->datatables->add_column("Actions",
            "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/?hold=$1') . "' title='".lang("click_to_add")."' class='tip btn btn-info btn-xs'><i class='fa fa-th-large'></i></a>
            <a href='" . site_url('sales/delete_holded/$1') . "' onClick=\"return confirm('". lang('alert_x_holded') ."')\" title='".lang("delete_sale")."' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id")
        ->unset_column('id');

        echo $this->datatables->generate();

    }


    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }

        if($this->input->get('id')){ $id = $this->input->get('id'); }

        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang("access_denied"));
            redirect('sales');
        }

        if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
            $this->telegram_delete_sale($id);
        }

        if ( $this->sales_model->deleteInvoice($id) ) {
            $this->session->set_flashdata('message', lang("sale_deleted"));
            redirect('sales');
        }

    }

    function delete_holded($id = NULL) {

        if($this->input->get('id')){ $id = $this->input->get('id'); }

        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang("access_denied"));
            redirect('sales/opened');
        }

        $Settings = $this->site->getSettings();            
        if($Settings->hold_customer){
            $suspendsale = $this->pos_model->getSuspendedSaleByID($id);
            $show_customer = array('hide' => 0);
            $this->db->update('customers',$show_customer,array('id' => $suspendsale->customer_id));
        }
        if ( $this->sales_model->deleteOpenedSale($id) ) {            
            $this->session->set_flashdata('message', lang("opened_bill_deleted"));
            redirect('sales/opened');
        }

    }

    /* -------------------------------------------------------------------------------- */

    function payments($id = NULL) {
        $this->data['payments'] = $this->sales_model->getSalePayments($id);
        $this->load->view($this->theme . 'sales/payments', $this->data);
    }

    function payment_note($id = NULL) {
        $payment = $this->sales_model->getPaymentByID($id);
        $inv = $this->sales_model->getSaleByID($payment->sale_id);
        $this->data['customer'] = $this->site->getCompanyByID($inv->customer_id);
        $this->data['inv'] = $inv;
        $this->data['payment'] = $payment;
        $this->data['page_title'] = $this->lang->line("payment_note");

        $this->load->view($this->theme . 'sales/payment_note', $this->data);
    }

    function add_payment($id = NULL, $cid = NULL) {
        $this->load->helper('security');
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('amount-paid', lang("amount"), 'required');
        $this->form_validation->set_rules('paid_by', lang("paid_by"), 'required');
        $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
        if ($this->form_validation->run() == true) {
            if ($this->Admin || $this->Manager) {
                $date = $this->input->post('date');
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $payment = array(
                'date' => $date,
                'sale_id' => $id,
                'customer_id' => $cid,
                'reference' => $this->input->post('reference'),
                'amount' => $this->input->post('amount-paid'),
                'paid_by' => $this->input->post('paid_by'),
                'cheque_no' => $this->input->post('cheque_no'),
                'gc_no' => $this->input->post('gift_card_no'),
                'cc_no' => $this->input->post('pcc_no'),
                'cc_holder' => $this->input->post('pcc_holder'),
                'cc_month' => $this->input->post('pcc_month'),
                'cc_year' => $this->input->post('pcc_year'),
                'cc_type' => $this->input->post('pcc_type'),
                'note' => $this->input->post('note'),
                'created_by' => $this->session->userdata('user_id'),
                'store_id' => $this->session->userdata('store_id'),
                'next_payment' => $this->input->post('next_payment'),
                'alert_payment_day' => $this->input->post('alert_payment_day'),
            );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->digital_file_types;
                $config['max_size'] = 2048;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $payment['attachment'] = $photo;
            }

            // $this->tec->print_arrays($payment);

        } elseif ($this->input->post('add_payment')) {
            $this->session->set_flashdata('error', validation_errors());
            $this->tec->dd();
        }


        if ($this->form_validation->run() == true && $this->sales_model->addPayment($payment)) {
            //Send Telegram notification
            if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
                $store = $this->site->getStoreByID($payment['store_id']);  
                $sale = $this->sales_model->getSaleByID($payment['sale_id']);
                $user = $this->site->getUser($payment['created_by']);
                $text = lang('payment_added') . ": \n";
                $text = $text . lang('store') . ": " . $store->name . " \n";  
                $text = $text . lang('customer') . ": " . $sale->customer_name . " \n";
                $text = $text . lang('date').': ' . $this->tec->hrld($payment['date']) . " \n";
                $text = $text . lang('sale_no_ref') . ": " . $sale->inv_number . " \n";                
                $text = $text . lang('paid_amount').': '. $this->tec->formatMoney($payment['amount']) . " \n";
                if($sale->paid < $sale->grand_total){$text = $text . lang('due_amount').': '. $this->tec->formatMoney($sale->grand_total - $sale->paid) . " \n";}
                $text = $text . lang('paid_by') . ": " . lang($payment['paid_by']) . " \n";
                $text = $text . lang('status') . ": " . lang($sale->status) . " \n";
                $text = $text . lang('created_by') . ": " . $user->first_name . ' ' . $user->last_name . " \n";
                $this->telegram_lib->sendmsg($text);
            }
            $this->session->set_flashdata('message', lang("payment_added"));
            redirect($_SERVER["HTTP_REFERER"]);
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $sale = $this->sales_model->getSaleByID($id);
            $this->data['inv'] = $sale;

            $this->load->view($this->theme . 'sales/add_payment', $this->data);
        }
    }

    function edit_payment($id = NULL, $sid = NULL) {

        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang("access_denied"));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        $this->load->helper('security');
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('amount-paid', lang("amount"), 'required');
        $this->form_validation->set_rules('paid_by', lang("paid_by"), 'required');
        $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
        if ($this->form_validation->run() == true) {
            $payment = array(
                'sale_id' => $sid,
                'reference' => $this->input->post('reference'),
                'amount' => $this->input->post('amount-paid'),
                'paid_by' => $this->input->post('paid_by'),
                'cheque_no' => $this->input->post('cheque_no'),
                'gc_no' => $this->input->post('gift_card_no'),
                'cc_no' => $this->input->post('pcc_no'),
                'cc_holder' => $this->input->post('pcc_holder'),
                'cc_month' => $this->input->post('pcc_month'),
                'cc_year' => $this->input->post('pcc_year'),
                'cc_type' => $this->input->post('pcc_type'),
                'note' => $this->input->post('note'),
                'updated_by' => $this->session->userdata('user_id'),
                'updated_at' => date('Y-m-d H:i:s'),
                'next_payment' => $this->input->post('next_payment'),
                'alert_payment_day' => $this->input->post('alert_payment_day'),
            );

            if ($this->Admin || $this->Manager) {
                $payment['date'] = $this->input->post('date');
            }

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->digital_file_types;
                $config['max_size'] = 2048;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $payment['attachment'] = $photo;
            }

            //$this->tec->print_arrays($payment);

        } elseif ($this->input->post('edit_payment')) {
            $this->session->set_flashdata('error', validation_errors());
            $this->tec->dd();
        }


        if ($this->form_validation->run() == true && $this->sales_model->updatePayment($id, $payment)) {
            //Send Telegram notification
            if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
                $e_payment = $this->sales_model->getPaymentByID($id);
                $sale = $this->sales_model->getSaleByID($e_payment->sale_id);
                $store = $this->site->getStoreByID($e_payment->store_id);  
                $user = $this->site->getUser($e_payment->updated_by);
                $text = lang('payment_updated') . ": \n";
                $text = $text . lang('store') . ": " . $store->name . " \n";  
                $text = $text . lang('sale_no_ref') . ": " . $sale->inv_number . " \n";
                $text = $text . lang('customer') . ": " . $sale->customer_name . " \n";
                $text = $text . lang("date").': '.$this->tec->hrld(date('Y-m-d H:i:s')) . " \n";         
                $text = $text . lang('paid_amount').': '. $this->tec->formatMoney($e_payment->amount-paid) . " \n";
                $text = $text . lang('paid_by') . ": " . lang($e_payment->paid_by) . " \n";
                $text = $text . lang('perform_by') . ": " . $user->first_name . ' ' . $user->last_name . " \n";
                $this->telegram_lib->sendmsg($text);
            }
            $this->session->set_flashdata('message', lang("payment_updated"));
            redirect("sales");
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $payment = $this->sales_model->getPaymentByID($id);
            if($payment->paid_by != 'cash') {
                $this->session->set_flashdata('error', lang('only_cash_can_be_edited'));
                $this->tec->dd();
            }
            $this->data['payment'] = $payment;
            $this->load->view($this->theme . 'sales/edit_payment', $this->data);
        }
    }

    function delete_payment($id = NULL) {

        if($this->input->get('id')){ $id = $this->input->get('id'); }

        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang("access_denied"));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        //Send Telegram notification
        if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
            $e_payment = $this->sales_model->getPaymentByID($id);
            $sale = $this->sales_model->getSaleByID($e_payment->sale_id);
            $store = $this->site->getStoreByID($e_payment->store_id);  
            $user = $this->site->getUser($this->session->userdata('user_id'));
            $text = lang('payment_deleted') . ": \n";
            $text = $text . lang('store') . ": " . $store->name . " \n";  
            $text = $text . lang('sale_no_ref') . ": " . $sale->inv_number . " \n";
            $text = $text . lang('customer') . ": " . $sale->customer_name . " \n";
            $text = $text . lang("date").': '.$this->tec->hrld(date('Y-m-d H:i:s')) . " \n";         
            $text = $text . lang('paid_amount').': '. $this->tec->formatMoney($e_payment->amount-paid) . " \n";
            $text = $text . lang('paid_by') . ": " . lang($e_payment->paid_by) . " \n";
            $text = $text . lang('perform_by') . ": " . $user->first_name . ' ' . $user->last_name . " \n";
            $this->telegram_lib->sendmsg($text);
        }

        if ( $this->sales_model->deletePayment($id) ) {
            $this->session->set_flashdata('message', lang("payment_deleted"));
            redirect('sales');
        }
    }

    public function status() {
        if ( ! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect('sales');
        }
        $this->form_validation->set_rules('sale_id', lang('sale_id'), 'required');
        $this->form_validation->set_rules('status', lang('status'), 'required');

        if ($this->form_validation->run() == true) {

            $this->sales_model->updateStatus($this->input->post('sale_id', TRUE), $this->input->post('status', TRUE));
            $this->session->set_flashdata('message', lang('status_updated'));
            redirect('sales');

        } else {

            $this->session->set_flashdata('error', validation_errors());
            redirect('sales');

        }
    }

    function service_items() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['products'] = $this->reports_model->getAllProducts();
		$this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['page_title'] = lang('service_items');
        $bc = array(array('link' => '#', 'page' => lang('service_items')));
        $meta = array('page_title' => lang('service_items'), 'bc' => $bc);
        $this->page_construct('sales/serviceitems', $this->data, $meta);

    }
	
	function get_serviceitems() {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('sale_items').".id as id, ". $this->db->dbprefix('sales').".id as saleid, ".$this->db->dbprefix('sales').".date, ".$this->db->dbprefix('sale_items').".product_name, ".$this->db->dbprefix('sale_items').".product_code, ".$this->db->dbprefix('customers').".name as customer_name, ".$this->db->dbprefix('customers').".phone as customer_phone, ".$this->db->dbprefix('sale_items').".next_service_date, ".$this->db->dbprefix('sale_items').".quantity , ".$this->db->dbprefix('unit').".name as unit, ".$this->db->dbprefix('sale_items').".subtotal, ". $this->db->dbprefix('sales').".inv_number", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left')
        ->join('customers','customers.id=sales.customer_id','left')
		->join('categories','categories.id=products.category_id','left')
        ->where('next_service_date IS NOT NULL');
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='" . site_url('sales/edit_service/$1') . "' class='btn btn-xs btn-primary ap tip' data-id='$1' title='".lang('update_service')."'><i class='fa fa-file-text-o'></i></a></div>", "id");
        if($product) { $this->datatables->where('products.id', $product); }
		if($customer){ $this->datatables->where('customer_id', $customer);   }
        if($start_date) { $this->datatables->where('next_service_date >=', $start_date); }
        if($end_date) { $this->datatables->where('next_service_date <=', $end_date); }
        echo $this->datatables->generate();
    }

    function edit_service($id = NULL) {
        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('sales');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('next_service_date', lang('next_service_date'), 'required');

        if ($this->form_validation->run() == true) {
            $next_service_date = $this->input->post('next_service_date');         
        }

        if ($this->form_validation->run() == true && $this->sales_model->updateService($id, $next_service_date)) {

            $this->session->set_flashdata('message', lang('Service_Updated'));
            redirect("sales/service_items");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['saleitem'] = $this->sales_model->getSaleItemByID($id);
            $this->data['page_title'] = lang('update_service');
            $bc = array(array('link' => site_url('sales'), 'page' => lang('sales')), array('link' => '#', 'page' => lang('update_service')));
            $meta = array('page_title' => lang('update_service'), 'bc' => $bc);
            $this->page_construct('sales/edit_service', $this->data, $meta);

        }
    }

    function delivery_list() {
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('delivery');
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('delivery')));
        $meta = array('page_title' => lang('delivery'), 'bc' => $bc);
        $this->page_construct('sales/delivery_list', $this->data, $meta);
    }

    function get_delivery() {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select("id, strftime('%Y-%m-%d %H:%M', date) as date, customer_name, total, (grand_total-paid) as pdue, total_tax, total_discount, grand_total, paid, status, delivery_by, delivery_status, delivery_note, delivery_staff, delivery_date, delivery_attachment, inv_number");
        } else {
            $this->datatables->select("id, DATE_FORMAT(date, '%Y-%m-%d %H:%i') as date, customer_name, total, (grand_total-paid) as pdue, total_tax,total_discount, grand_total, paid, status, delivery_by, delivery_status, delivery_note, delivery_staff, delivery_date, delivery_attachment, inv_number");
        }
        $this->datatables->from('sales');
        $this->datatables->where("delivery_by <>''");
        if (! ($this->Admin || $this->Manager) && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        }
        $this->datatables->where('store_id', $this->session->userdata('store_id'));
        //$this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1/1') . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs' data-toggle='ajax-modal'><i class='fa fa-list'></i></a> <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a> <a href='" . site_url('pos/?edit=$1') . "' title='".lang("edit_invoice")."' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('sales/delete/$1') . "' onClick=\"return confirm('". lang('alert_x_sale') ."')\" title='".lang("delete_sale")."' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
		$this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('sales/edit_delivery/$1')."' title='" . lang("edit_delivery") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-edit'></i></a> </div></div>", "id");
        // $this->datatables->unset_column('id');
        if($customer) { $this->datatables->where('customer_id', $customer); }
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('delivery_date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('delivery_date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();

    }

    function edit_delivery($id = NULL) {
        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('sales');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('delivery_status', lang('delivery_status'), 'required');

        if ($this->form_validation->run() == true) {            
            $delivery = array(
                'delivery_by' => $this->input->post('delivery_by'),
                'delivery_status' => $this->input->post('delivery_status'),
                'delivery_note' => $this->input->post('delivery_note'),
                'delivery_staff' => $this->input->post('delivery_staff'),
                'delivery_date' => $this->input->post('delivery_date'),
            );  
        }

        if ($_FILES['userfile']['size'] > 0) {

            $this->load->library('upload');
            $config['upload_path'] = 'uploads/';
            $config['allowed_types'] = $this->digital_file_types;
            $config['max_size'] = '200000';
            $config['overwrite'] = FALSE;
            $config['encrypt_name'] = TRUE;
            $this->upload->initialize($config);
            if (!$this->upload->do_upload()) {
                $error = $this->upload->display_errors();
                $this->upload->set_flashdata('error', $error);
                redirect("sales/delivery_list");
            }
            $delivery['delivery_attachment'] = $this->upload->file_name;
        }

        if ($this->form_validation->run() == true && $this->sales_model->updateDelivery($id, $delivery)) {
            $this->session->set_flashdata('message', lang('delivery_updated'));
            redirect("sales/delivery_list");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['sales'] = $this->sales_model->getSaleByID($id);
            $this->load->view($this->theme . 'sales/edit_delivery', $this->data);

        }
    }

    function get_alertspayment() {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select("id, strftime('%Y-%m-%d %H:%M', date) as date, customer_name, (total+product_discount) as total, (grand_total-paid) as pdue, total_tax, total_discount, grand_total, paid, status, delivery_by, delivery_status, delivery_note, next_payment, alert_payment_day, inv_number");
        } else {
            $this->datatables->select("id, DATE_FORMAT(date, '%Y-%m-%d %H:%i') as date, customer_name, (total+product_discount) as total, (grand_total-paid) as pdue, total_tax,total_discount, grand_total, paid, status, delivery_by, delivery_status, delivery_note, next_payment, alert_payment_day, inv_number");
        }
        $this->datatables->from('sales');
        $this->datatables->where("(CASE WHEN DATEDIFF({$this->db->dbprefix('sales')}.next_payment,now()) IS NULL THEN 0 ELSE DATEDIFF({$this->db->dbprefix('sales')}.next_payment,now()) END) < {$this->db->dbprefix('sales')}.alert_payment_day", NULL, FALSE);        
        if (! ($this->Admin || $this->Manager) && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        }
        $this->datatables->where('store_id', $this->session->userdata('store_id'));
        //$this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1/1') . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs' data-toggle='ajax-modal'><i class='fa fa-list'></i></a> <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a> <a href='" . site_url('pos/?edit=$1') . "' title='".lang("edit_invoice")."' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('sales/delete/$1') . "' onClick=\"return confirm('". lang('alert_x_sale') ."')\" title='".lang("delete_sale")."' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
		$this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('pos/view/$1') . "' title='".lang("view_invoice")."' class='tip btn btn-primary btn-xs'><i class='fa fa-list'></i></a> <a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a> </div></div>", "id");
        // $this->datatables->unset_column('id');
        if($customer) { $this->datatables->where('customer_id', $customer); }
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();

    }

    function alertspayment() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('alert_payment');
        $bc = array(array('link' => '#', 'page' => lang('alert_payment')));
        $meta = array('page_title' => lang('alert_payment'), 'bc' => $bc);
        $this->page_construct('sales/alertspayment', $this->data, $meta);

    }

    function add_payment_multiple($cid = NULL) {
        $this->load->helper('security');

        $this->form_validation->set_rules('amount-paid', lang("amount"), 'required');
        $this->form_validation->set_rules('paid_by', lang("paid_by"), 'required');
        $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
        if ($this->form_validation->run() == true) {
            if ($this->Admin || $this->Manager) {
                $date = $this->input->post('date');
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $payment = array(
                'date' => $date,
                'customer_id' => $cid,
                'reference' => $this->input->post('reference'),
                'paid_by' => $this->input->post('paid_by'),
                'cheque_no' => $this->input->post('cheque_no'),
                'gc_no' => $this->input->post('gift_card_no'),
                'cc_no' => $this->input->post('pcc_no'),
                'cc_holder' => $this->input->post('pcc_holder'),
                'cc_month' => $this->input->post('pcc_month'),
                'cc_year' => $this->input->post('pcc_year'),
                'cc_type' => $this->input->post('pcc_type'),
                'note' => $this->input->post('note'),
                'created_by' => $this->session->userdata('user_id'),
                'store_id' => $this->session->userdata('store_id'),
                'next_payment' => $this->input->post('next_payment'),
                'alert_payment_day' => $this->input->post('alert_payment_day'),
            );

            $data = array(
                'date' => $date,
                'customer_id' => $cid,
                'amount-paid' => $this->input->post('amount-paid'),
            );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->digital_file_types;
                $config['max_size'] = 2048;
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $payment['attachment'] = $photo;
            }

            // $this->tec->print_arrays($payment);

        } elseif ($this->input->post('add_payment')) {
            $this->session->set_flashdata('error', validation_errors());
            $this->tec->dd();
        }


        if ($this->form_validation->run() == true && $this->sales_model->addPaymentMultiple($data,$payment)) {
            //Send Telegram notification
            if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
                $store = $this->site->getStoreByID($payment['store_id']);  
                $customer = $this->site->getCustomerByID($cid);
                $user = $this->site->getUser($payment['created_by']);
                $text = lang('payment_added') . ": \n";
                $text = $text . lang('store') . ": " . $store->name . " \n";  
                $text = $text . lang('customer') . ": " . $customer->name . " \n";
                $text = $text . lang('date').': ' . $this->tec->hrld($payment['date']) . " \n";          
                $text = $text . lang('paid_amount').': '. $this->tec->formatMoney($data['amount-paid']) . " \n";
                $text = $text . lang('paid_by') . ": " . lang($payment['paid_by']) . " \n";
                $text = $text . lang('created_by') . ": " . $user->first_name . ' ' . $user->last_name . " \n";
                $this->telegram_lib->sendmsg($text);
            }
            $this->session->set_flashdata('message', lang("payment_added"));
            redirect($_SERVER["HTTP_REFERER"]);
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['due_invoices'] = $this->sales_model->getDueInvoicesByID($cid);
            $this->data['customer'] = $this->site->getCustomerByID($cid);
            $this->load->view($this->theme . 'sales/add_payment_multiple', $this->data);
        }
    }

    function telegram_delete_sale($sale_id = NULL) {        
        $inv = $this->pos_model->getSaleByID($sale_id);
        $items = $this->pos_model->getAllSaleItems($sale_id);
        $store = $this->site->getStoreByID($inv->store_id);
        $deleted_by = $this->site->getUser($this->session->userdata('user_id'));
        $text = lang('sale_deleted') . ": \n";
        $text = $text . lang('store') . ": " . $store->name . " \n";
        $text = $text . lang('sale_no_ref') . ": " . $inv->inv_number . " \n";
        $text = $text . lang("customer").': '. $inv->customer_name . " \n";
        $text = $text . lang("perform_by").': '. $deleted_by->first_name." ".$deleted_by->last_name . " \n";
        $text = $text . lang("date").': '.$this->tec->hrld(date('Y-m-d H:i:s')) . " \n";
        $text = $text . lang('grand_total') . ": " . $this->tec->formatMoney($inv->grand_total) . " \n";
        //$text = $text . lang('status') . ": " . lang($inv->status) . " \n";
        if ($inv->note != '') {$text = $text . lang('note') . ": " . lang($inv->note) . " \n";}
        $text = $text . lang('item_des') . " \n";
        $no = 0;
        foreach ($items as $item) {
            $no = $no + 1;
            $text = $text . $no . ' - ' . $item->product_name . ' : ' . $this->tec->formatMoney($item->unit_price) . ' x ' .  $this->tec->formatQuantity($item->quantity) . ' = ' .  $this->tec->formatMoney($item->subtotal) . " \n";
        }
        $this->telegram_lib->sendmsg($text);
    }
}
