<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if ( ! $this->loggedIn) {
            redirect('login');
        }

        if ( ! ($this->Admin || $this->Manager || $this->Print || $this->SalesReport || $this->AllReports)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->load->model('reports_model');
    }

    function daily_sales($year = NULL, $month = NULL) {
        if (!$year) { $year = date('Y'); }
        if (!$month) { $month = date('m'); }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->lang->load('calendar');
        $config = array(
            'show_next_prev' => TRUE,
            'next_prev_url' => site_url('reports/daily_sales'),
            'month_type' => 'long',
            'day_type' => 'long'
            );
        $config['template'] = '

        {table_open}<table border="0" cellpadding="0" cellspacing="0" class="table table-bordered table-calendar" style="min-width:522px;">{/table_open}

        {heading_row_start}<tr class="active">{/heading_row_start}

        {heading_previous_cell}<th><div class="text-center"><a href="{previous_url}">&lt;&lt;</div></a></th>{/heading_previous_cell}
        {heading_title_cell}<th colspan="{colspan}"><div class="text-center">{heading}</div></th>{/heading_title_cell}
        {heading_next_cell}<th><div class="text-center"><a href="{next_url}">&gt;&gt;</a></div></th>{/heading_next_cell}

        {heading_row_end}</tr>{/heading_row_end}

        {week_row_start}<tr>{/week_row_start}
        {week_day_cell}<td class="cl_equal"><div class="cl_wday">{week_day}</div></td>{/week_day_cell}
        {week_row_end}</tr>{/week_row_end}

        {cal_row_start}<tr>{/cal_row_start}
        {cal_cell_start}<td>{/cal_cell_start}

        {cal_cell_content}{day}<br>{content}{/cal_cell_content}
        {cal_cell_content_today}<div class="highlight">{day}</div>{content}{/cal_cell_content_today}

        {cal_cell_no_content}{day}{/cal_cell_no_content}
        {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}

        {cal_cell_blank}&nbsp;{/cal_cell_blank}

        {cal_cell_end}</td>{/cal_cell_end}
        {cal_row_end}</tr>{/cal_row_end}

        {table_close}</table>{/table_close}
        ';

        $this->load->library('calendar', $config);

        $sales = $this->reports_model->getDailySales($year, $month); 

        if (!empty($sales)) {
            foreach ($sales as $sale) {
                $sale->date = intval($sale->date);
                $daily_sale[$sale->date] = 
                "<table class='table table-condensed table-striped' style='margin-bottom:0;'><tr><td>".lang('invoice').
                "</td><td style='text-align:right;'>{$sale->nbr_sales}</td></tr><tr><td>".lang('total').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->total)}</td></tr><tr><td>".lang('discount').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->discount)}</td></tr><tr><td>".lang('net_total').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->net_total)}</td></tr><tr><td class='violet'>".lang('tax').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->total_tax)}</td></tr><tr><td class='violet'>".lang('grand_total').
                "</td><td style='text-align:right;' class='violet'>{$this->tec->formatMoney($sale->grand_total)}</td></tr><tr><td class='green'>".lang('paid').
                "</td><td style='text-align:right;' class='green'>{$this->tec->formatMoney($sale->paid)}</td></tr><tr><td class='orange'>".lang('balance').
                "</td><td style='text-align:right;' class='orange'>{$this->tec->formatMoney(($sale->grand_total+$sale->rounding) - $sale->paid)}</td></tr></table>";
            }
        } else {
            $daily_sale = array();
        }

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['calender'] = $this->calendar->generate($year, $month, $daily_sale);

        $start = $year.'-'.$month.'-01 00:00:00';
        $end = $year.'-'.$month.'-'.days_in_month($month, $year).' 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_cost'] = $this->reports_model->getTotalCost($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);

        $this->data['page_title'] = $this->lang->line("daily_sales");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('daily_sales')));
        $meta = array('page_title' => lang('daily_sales'), 'bc' => $bc);
        $this->page_construct('reports/daily', $this->data, $meta);

    }

    function daily_profit($year = NULL, $month = NULL) {
        if (!$year) { $year = date('Y'); }
        if (!$month) { $month = date('m'); }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->lang->load('calendar');
        $config = array(
            'show_next_prev' => TRUE,
            'next_prev_url' => site_url('reports/daily_profit'),
            'month_type' => 'long',
            'day_type' => 'long'
            );
        $config['template'] = '

        {table_open}<table border="0" cellpadding="0" cellspacing="0" class="table table-bordered table-calendar" style="min-width:522px;">{/table_open}

        {heading_row_start}<tr class="active">{/heading_row_start}

        {heading_previous_cell}<th><div class="text-center"><a href="{previous_url}">&lt;&lt;</div></a></th>{/heading_previous_cell}
        {heading_title_cell}<th colspan="{colspan}"><div class="text-center">{heading}</div></th>{/heading_title_cell}
        {heading_next_cell}<th><div class="text-center"><a href="{next_url}">&gt;&gt;</a></div></th>{/heading_next_cell}

        {heading_row_end}</tr>{/heading_row_end}

        {week_row_start}<tr>{/week_row_start}
        {week_day_cell}<td class="cl_equal"><div class="cl_wday">{week_day}</div></td>{/week_day_cell}
        {week_row_end}</tr>{/week_row_end}

        {cal_row_start}<tr>{/cal_row_start}
        {cal_cell_start}<td>{/cal_cell_start}

        {cal_cell_content}{day}<br>{content}{/cal_cell_content}
        {cal_cell_content_today}<div class="highlight">{day}</div>{content}{/cal_cell_content_today}

        {cal_cell_no_content}{day}{/cal_cell_no_content}
        {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}

        {cal_cell_blank}&nbsp;{/cal_cell_blank}

        {cal_cell_end}</td>{/cal_cell_end}
        {cal_row_end}</tr>{/cal_row_end}

        {table_close}</table>{/table_close}
        ';

        $this->load->library('calendar', $config);

        $sales = $this->reports_model->getDailySales($year, $month);

        if (!empty($sales)) {
            foreach ($sales as $sale) {
                $expense = $this->reports_model->getDailyExpenses($sale->sale_date);
                $sale->date = intval($sale->date);
                $daily_sale[$sale->date] = 
                "<table class='table table-condensed table-striped' style='margin-bottom:0;'><tr><td>".lang('invoice').
                "</td><td style='text-align:right;'>{$sale->nbr_sales}</td></tr><tr><td>".lang('total').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->total)}</td></tr><tr><td>".lang('discount').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->discount)}</td></tr><tr><td>".lang('net_total').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->net_total)}</td></tr><tr><td class='violet'>".lang('tax').
                "</td><td style='text-align:right;'>{$this->tec->formatMoney($sale->total_tax)}</td></tr><tr><td class='violet'>".lang('grand_total').
                "</td><td style='text-align:right;' class='violet'>{$this->tec->formatMoney($sale->grand_total)}</td></tr><tr><td class='green'>".lang('cost').
                "</td><td style='text-align:right;' class='green'>{$this->tec->formatMoney($sale->cost)}</td></tr><tr><td class='orange'>".lang('expense').
                "</td><td style='text-align:right;' class='green'>{$this->tec->formatMoney($expense->total)}</td></tr><tr><td class='orange'>".lang('profit').
                "</td><td style='text-align:right;' class='orange'>{$this->tec->formatMoney(($sale->grand_total+$sale->rounding) - $sale->cost - $sale->total_tax - $expense->total)}</td></tr></table>";
            }
        } else {
            $daily_sale = array();
        }

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['calender'] = $this->calendar->generate($year, $month, $daily_sale);

        $start = $year.'-'.$month.'-01 00:00:00';
        $end = $year.'-'.$month.'-'.days_in_month($month, $year).' 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_cost'] = $this->reports_model->getTotalCost($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);

        $this->data['page_title'] = $this->lang->line("daily_profit");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('daily_profit')));
        $meta = array('page_title' => lang('daily_profit'), 'bc' => $bc);
        $this->page_construct('reports/daily_profit', $this->data, $meta);

    }

    function monthly_sales($year = NULL) {
        if(!$year) { $year = date('Y'); }
        $this->load->language('calendar');
        $this->lang->load('calendar');
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $start = $year.'-01-01 00:00:00';
        $end = $year.'-12-31 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_cost'] = $this->reports_model->getTotalCost($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);
        $this->data['year'] = $year;
        $this->data['sales'] = $this->reports_model->getMonthlySales($year);
        $this->data['page_title'] = $this->lang->line("monthly_sales");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('monthly_sales')));
        $meta = array('page_title' => lang('monthly_sales'), 'bc' => $bc);
        $this->page_construct('reports/monthly', $this->data, $meta);
    }

    function monthly_profit($year = NULL) {
        if(!$year) { $year = date('Y'); }
        $this->load->language('calendar');
        $this->lang->load('calendar');
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $start = $year.'-01-01 00:00:00';
        $end = $year.'-12-31 23:59:59';
        $this->data['total_purchases'] = $this->reports_model->getTotalPurchases($start, $end);
        $this->data['total_cost'] = $this->reports_model->getTotalCost($start, $end);
        $this->data['total_sales'] = $this->reports_model->getTotalSales($start, $end);
        $this->data['total_expenses'] = $this->reports_model->getTotalExpenses($start, $end);
        $this->data['year'] = $year;
        $this->data['sales'] = $this->reports_model->getMonthlySales($year);
        $this->data['page_title'] = $this->lang->line("monthly_profit");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('monthly_profit')));
        $meta = array('page_title' => lang('monthly_profit'), 'bc' => $bc);
        $this->page_construct('reports/monthly_profit', $this->data, $meta);
    }

    function index() {
        if ($this->input->post('customer')) {
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $this->input->post('user') ? $this->input->post('user') : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalCustomerSales($this->input->post('customer'), $user, $start_date, $end_date);
        }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $this->data['customer_group'] = $this->site->getAllCustomerGroup();
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['page_title'] = $this->lang->line("sales_report");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('sales_report')));
        $meta = array('page_title' => lang('sales_report'), 'bc' => $bc);
        $this->page_construct('reports/sales', $this->data, $meta);
    }

    function get_sales() {
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $customer_group = $this->input->get('customer_group') ? $this->input->get('customer_group') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select("id, date, customer_name, (total + product_discount) as total, total_tax, total_discount, grand_total, paid, (grand_total-paid) as balance, status, total_cost, (grand_total-total_cost-total_tax) as profit, inv_number, (total-order_discount) as net_total, customer_group_name")
        ->from('sales');
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('store_id', $this->session->userdata('store_id'));
        }
        
        $this->datatables->unset_column('id');
        if($customer) { $this->datatables->where('customer_id', $customer); }
        if($customer_group) { $this->datatables->where('sale_customer_group', $customer_group); }
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }

        echo $this->datatables->generate();
    }

    function get_due() { 
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select("id, date, customer_name, total, total_tax, total_discount, grand_total, paid, (grand_total-paid) as balance, status, total_cost, (grand_total-total_cost) as profit, inv_number")
        ->from('sales');
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('store_id', $this->session->userdata('store_id'));
        }
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('sales/payments/$1')."' title='" . lang("view_payments") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-money'></i></a> <a href='".site_url('sales/add_payment/$1')."' title='" . lang("add_payment") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-briefcase'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
		$this->datatables->where('status <>', 'paid');
        if($customer) { $this->datatables->where('customer_id', $customer); }
        if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }

        echo $this->datatables->generate();
    }

    function due() {
        if ($this->input->post('customer')) {
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $this->input->post('user') ? $this->input->post('user') : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalCustomerSales($this->input->post('customer'), $user, $start_date, $end_date);
            $this->data['customer_id'] = $this->input->post('customer');
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('due_report')));
        $meta = array('page_title' => lang('due_report'), 'bc' => $bc);
        $this->page_construct('reports/customerdue', $this->data, $meta);
    }

    function due_summary($customer_id = NULL, $start_date = NULL, $end_date = NULL, $user_id = NULL) {
        if ( ! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->data['due_invoices'] = $this->reports_model->getDueInvoicesByID($customer_id, $start_date, $end_date, $user_id);
        $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        $this->data['customer'] = $this->site->getCustomerByID($customer_id);
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['page_title'] = lang('due_summary');
        $this->load->view($this->theme.'reports/due_summary', $this->data);
    }
	
    function products() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("products_report");
        $this->data['page_title'] = $this->lang->line("products_report");
        $this->data['category'] = $this->reports_model->getAllCategory();
		$this->data['suppliers'] = $this->reports_model->getAllSupplier();
		$this->data['customers'] = $this->reports_model->getAllCustomers();
		$this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('products_report')));
        $meta = array('page_title' => lang('products_report'), 'bc' => $bc);
        $this->page_construct('reports/products', $this->data, $meta);
    }

    function products2() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("products_report");
        $this->data['page_title'] = $this->lang->line("products_report");
        $this->data['category'] = $this->reports_model->getAllCategory();
		$this->data['suppliers'] = $this->reports_model->getAllSupplier();
		$this->data['customers'] = $this->reports_model->getAllCustomers();
		$this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('products_report')));
        $meta = array('page_title' => lang('products_report'), 'bc' => $bc);
        $this->page_construct('reports/products_2', $this->data, $meta);
    }
    
    //Custom function to call Custom report
    function category() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['categories'] = $this->reports_model->getAllCategory();
        $this->data['page_title'] = $this->lang->line("category_report");
        $this->data['page_title'] = $this->lang->line("category_report");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('category_report')));
        $meta = array('page_title' => lang('category_report'), 'bc' => $bc);
        $this->page_construct('reports/category', $this->data, $meta);
    }
    function allproducts() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("allproducts_report");
        $this->data['page_title'] = $this->lang->line("allproducts_report");
        $this->data['category'] = $this->reports_model->getAllCategory();
		$this->data['suppliers'] = $this->reports_model->getAllSupplier();
		$this->data['customers'] = $this->reports_model->getAllCustomers();
		$this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('allproducts_report')));
        $meta = array('page_title' => lang('allproducts_report'), 'bc' => $bc);
        $this->page_construct('reports/allproducts', $this->data, $meta);
    }
	//Custom function to call Custom report
	function productsbysales() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("products_by_sales");
		$this->data['customers'] = $this->reports_model->getAllCustomers();
		$this->data['phone'] = $this->reports_model->getAllCustomers();
		$this->data['category'] = $this->reports_model->getAllCategory();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('products_by_sales')));
        $meta = array('page_title' => lang('products_by_sales'), 'bc' => $bc);
        $this->page_construct('reports/productsbysales', $this->data, $meta);
    }

    function get_products() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;
		$user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        //COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('products').".cost, 0) as cost,
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('products').".id as id, ".$this->db->dbprefix('products').".name, ".$this->db->dbprefix('categories').".name as cname, psq.quantity,".$this->db->dbprefix('products').".code, COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity), 0) as sold, ".$this->db->dbprefix('unit').".name as unit, ROUND(COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) as cost, (SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))) AS income, ROUND(SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)) - sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) -COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as profit", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('categories', 'categories.id=products.category_id', 'left')
        ->join("(SELECT * from {$this->db->dbprefix('product_store_qty')}) psq", 'products.id=psq.product_id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left');
		
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        }
        $this->datatables->group_by('products.id');

        if($product) { $this->datatables->where('products.id', $product); }
        if($customer) { $this->datatables->where('customer_id', $customer); }
		if($category){ $this->datatables->where('category_id', $category);   }
		if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function get_products2() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;
		$user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        //COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('products').".cost, 0) as cost,
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('products').".id as id, ".$this->db->dbprefix('products').".name, ".$this->db->dbprefix('categories').".name as cname, psq.quantity,".$this->db->dbprefix('products').".code, COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity), 0) as sold, ".$this->db->dbprefix('unit').".name as unit, ROUND(COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) as cost, (SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))) AS income, ROUND(SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)) - sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) -COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as profit", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('categories', 'categories.id=products.category_id', 'left')
        ->join("(SELECT * from {$this->db->dbprefix('product_store_qty')}) psq", 'products.id=psq.product_id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left');
		
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        }
        $this->datatables->group_by('products.name');

        if($product) { $this->datatables->where('products.id', $product); }
        if($customer) { $this->datatables->where('customer_id', $customer); }
		if($category){ $this->datatables->where('category_id', $category);   }
		if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function get_allproducts() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;
		$user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('products').".id as id, ".$this->db->dbprefix('products').".name, ".$this->db->dbprefix('products').".price as selling_price, ".$this->db->dbprefix('categories').".name as cname, psq.quantity,".$this->db->dbprefix('products').".code, COALESCE(sum(sitm.quantity), 0) as sold, ".$this->db->dbprefix('unit').".name as unit, ROUND(COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * sitm.subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, COALESCE(sum(sitm.quantity*sitm.cost),0) as cost, COALESCE(SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * sitm.subtotal)),0) as income, ROUND(COALESCE(SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * sitm.subtotal)) - sum(sitm.quantity*sitm.cost) -((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * sitm.subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as profit,".$this->db->dbprefix('products').".cost as unit_cost, (IF(psq.quantity>0,psq.quantity,0) * ".$this->db->dbprefix('products').".cost) as stock_value, COALESCE(SUM(sitm.item_discount),0) as discount", FALSE)
        ->from('products')
        ->join("(SELECT * from {$this->db->dbprefix('sale_items')}) sitm", 'products.id=sitm.product_id', 'left')
        ->join('categories', 'categories.id=products.category_id', 'left')
        ->join("(SELECT * from {$this->db->dbprefix('product_store_qty')}) psq", 'products.id=psq.product_id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sitm.sale_id=sales.id', 'left');
		
        //if ($this->session->userdata('store_id')) {
        //    $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        //}
        $this->datatables->group_by('products.id');

        if($product) { $this->datatables->where('products.id', $product); }
        if($customer) { $this->datatables->where('customer_id', $customer); }
		if($category){ $this->datatables->where('category_id', $category);   }
		if($user) { $this->datatables->where('created_by', $user); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function get_purchasereport() {
        $supplier = $this->input->get('supplier') ? $this->input->get('supplier') : NULL;
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;	
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        $this->datatables->select("date,name,code,tec_purchase_items.quantity as quantity,tec_purchase_items.cost,tec_purchase_items.subtotal,purchase_id");
        $this->datatables->from('purchase_items')
        ->join('products','products.id=purchase_items.product_id','left')
        ->join('purchases','purchase_items.purchase_id=purchases.id','left');      

        if($supplier) { $this->datatables->where('purchases.supplier_id', $supplier); }
        if($product) { $this->datatables->where('products.id', $product); }
		if($category){ $this->datatables->where('category_id', $category);   }	
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function purchases() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("purchase_report");
        $this->data['category'] = $this->reports_model->getAllCategory();
		$this->data['suppliers'] = $this->reports_model->getAllSupplier();
		$this->data['customers'] = $this->reports_model->getAllCustomers();
		$this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('purchase_report')));
        $meta = array('page_title' => lang('purchase_report'), 'bc' => $bc);
        $this->page_construct('reports/purchases', $this->data, $meta);
    }
    
	//Custom function by Vichet
	
	function get_byproducts() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
		$customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
		$phone = $this->input->get('phone') ? $this->input->get('phone') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;       
        $this->load->library('datatables');
        $this->datatables        
        ->select($this->db->dbprefix('sales').".id as id, ".$this->db->dbprefix('sales').".date, ".$this->db->dbprefix('sale_items').".product_name, ".$this->db->dbprefix('sale_items').".product_code, ".$this->db->dbprefix('sales').".customer_name, (".$this->db->dbprefix('sale_items').".cost * ".$this->db->dbprefix('sale_items').".quantity) as cost, ".$this->db->dbprefix('sale_items').".real_unit_price, ".$this->db->dbprefix('sale_items').".quantity , ".$this->db->dbprefix('unit').".name as unit, (((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)) as subtotal, ((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)-(".$this->db->dbprefix('sale_items').".cost *".$this->db->dbprefix('sale_items').".quantity) as profit, ".$this->db->dbprefix('sales').".inv_number", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left')
		->join('categories','categories.id=products.category_id','left');
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        }       

        if($product) { $this->datatables->where('products.id', $product); }
		if($customer){ $this->datatables->where('customer_id', $customer);   }
		if($phone){ $this->datatables->where('customer_id', $phone);   }
		if($category){ $this->datatables->where('category_id', $category);   }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }
    //custom function by Rithy
    function get_category() {
        $category = $this->input->get('category') ? $this->input->get('category') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        //COALESCE(sum(".$this->db->dbprefix('sale_items').".quantity)*".$this->db->dbprefix('products').".cost, 0) as cost,
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('categories').".id as id, ".$this->db->dbprefix('categories').".name, ".$this->db->dbprefix('categories').".code, sum(".$this->db->dbprefix('sale_items').".quantity) as sold, ROUND(COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2) as tax, sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) as cost, SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)) as income, ROUND(SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal)) - sum(".$this->db->dbprefix('sale_items').".quantity*".$this->db->dbprefix('sale_items').".cost) -COALESCE(((SUM(((1-(".$this->db->dbprefix('sales').".order_discount/ ".$this->db->dbprefix('sales').".total)) * ".$this->db->dbprefix('sale_items').".subtotal))*".$this->db->dbprefix('products').".tax)/100), 0), 2)
            as profit", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('categories','products.category_id = categories.id','left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left');

        if ($this->session->userdata('store_id')) {
            $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        }
        $this->datatables->group_by('categories.id');

        if($category) { $this->datatables->where('categories.id', $category); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }
	
	//Custom function by Vichet
	function get_productsbycustomber() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
		 $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;       
        $this->load->library('datatables');
        $this->datatables
         ->select("tec_sales.date,tec_sales.id,tec_sale_items.product_id,tec_sale_items.product_name,tec_sales.customer_name,tec_sale_items.cost,tec_sale_items.real_unit_price,tec_sale_items.quantity,tec_sale_items.subtotal,tec_sales.`status`")
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left');
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('sales.store_id', $this->session->userdata('store_id'));
        }      

        if($product) { $this->datatables->where('products.id', $product); }
		if($customer) { $this->datatables->where('customer_id', $customer); }
        if($start_date) { $this->datatables->where('date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }
	
	
    function profit( $income, $cost, $tax) {
        return floatval($income)." - ".floatval($cost)." - ".floatval($tax);
    }

    function top_products() {
        $this->data['topProducts'] = $this->reports_model->topProducts();
        $this->data['topProducts1'] = $this->reports_model->topProducts1();
        $this->data['topProducts3'] = $this->reports_model->topProducts3();
        $this->data['topProducts12'] = $this->reports_model->topProducts12();
        $this->data['page_title'] = $this->lang->line("top_products");
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('top_products')));
        $meta = array('page_title' => lang('top_products'), 'bc' => $bc);
        $this->page_construct('reports/top', $this->data, $meta);
    }

    function registers() {
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('registers_report')));
        $meta = array('page_title' => lang('registers_report'), 'bc' => $bc);
        $this->page_construct('reports/registers', $this->data, $meta);
    }

    function get_register_logs() {
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select("{$this->db->dbprefix('registers')}.id as id, date, closed_at, ({$this->db->dbprefix('users')}.first_name || ' ' || {$this->db->dbprefix('users')}.last_name || '<br>' || {$this->db->dbprefix('users')}.email) as user, cash_in_hand, (total_cc_slips || ' (' || total_cc_slips_submitted || ')') as cc_slips, (total_cheques || ' (' || total_cheques_submitted || ')') as total_cheques, (total_cash || ' (' || total_cash_submitted || ')') as total_cash, note, cash_sales, ch_sales, cc_sales, gc_sales, other_sales, total_sales", FALSE);
        } else {
            $this->datatables->select("{$this->db->dbprefix('registers')}.id as id, date, closed_at, CONCAT(" . $this->db->dbprefix('users') . ".first_name, ' ', " . $this->db->dbprefix('users') . ".last_name, '<br>', " . $this->db->dbprefix('users') . ".email) as user, cash_in_hand, CONCAT(total_cc_slips, ' (', total_cc_slips_submitted, ')') as cc_slips, CONCAT(total_cheques, ' (', total_cheques_submitted, ')') as total_cheques, CONCAT(total_cash, ' (', total_cash_submitted, ')') as total_cash, note, cash_sales, ch_sales, cc_sales, gc_sales, other_sales, total_sales, total_cash_1, total_cash_2, total_cash_3", FALSE);
        }
        $this->datatables->from("registers")
        ->join('users', 'users.id=registers.user_id', 'left');

        if ($user) {
            $this->datatables->where('registers.user_id', $user);
        }
        if ($start_date) {
            $this->datatables->where('date BETWEEN "' . $start_date . ' 00:00' . '" and "' . $end_date . ' 23:59' . '"');
        }
        if ($this->session->userdata('store_id')) {
            $this->datatables->where('registers.store_id', $this->session->userdata('store_id'));
        }

        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('reports/view_closedregister/$1')."' title='".lang('view_closed_register')."' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-file-text-o'></i></a></div></div>", "id");

        echo $this->datatables->generate();


    }

    function payments() {
        if ($this->input->post('customer')) {
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $this->input->post('user') ? $this->input->post('user') : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalCustomerSales($this->input->post('customer'), $user, $start_date, $end_date);
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('payments_report')));
        $meta = array('page_title' => lang('payments_report'), 'bc' => $bc);
        $this->page_construct('reports/payments', $this->data, $meta);
    }
	
	function paymentsbycustomer() {
        if ($this->input->post('customer')) {
            $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
            $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
            $user = $this->input->post('user') ? $this->input->post('user') : NULL;
            $this->data['total_sales'] = $this->reports_model->getTotalCustomerSales($this->input->post('customer'), $user, $start_date, $end_date);
        }
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->reports_model->getAllStaff();
        $this->data['customers'] = $this->reports_model->getAllCustomers();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('payments_report')));
        $meta = array('page_title' => lang('payments_report'), 'bc' => $bc);
        $this->page_construct('reports/paymentsbycustomer', $this->data, $meta);
    }

    function get_payments() {
        $user = $this->input->get('user') ? $this->input->get('user') : NULL;
        $ref = $this->input->get('payment_ref') ? $this->input->get('payment_ref') : NULL;
        $sale_id = $this->input->get('sale_no') ? $this->input->get('sale_no') : NULL;
        $customer = $this->input->get('customer') ? $this->input->get('customer') : NULL;
        $paid_by = $this->input->get('paid_by') ? $this->input->get('paid_by') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        $this->datatables
        ->select("{$this->db->dbprefix('payments')}.id as id, {$this->db->dbprefix('payments')}.date, {$this->db->dbprefix('payments')}.reference as ref, {$this->db->dbprefix('sales')}.id as sale_no, paid_by, amount, {$this->db->dbprefix('sales')}.customer_name, CONCAT({$this->db->dbprefix('users')}.first_name,' ',{$this->db->dbprefix('users')}.last_name) as sales_person")
        ->from('payments')
        ->join('sales', 'payments.sale_id=sales.id', 'left')
        ->join('users','users.id = payments.created_by','left')
        ->group_by('payments.id');

        if ($this->session->userdata('store_id')) {
            $this->datatables->where('payments.store_id', $this->session->userdata('store_id'));
        }
        if ($user) {
            $this->datatables->where('payments.created_by', $user);
        }
        if ($ref) {
            $this->datatables->where('payments.reference', $ref);
        }
        if ($paid_by) {
            $this->datatables->where('payments.paid_by', $paid_by);
        }
        if ($sale_id) {
            $this->datatables->where('sales.id', $sale_id);
        }
        if ($customer) {
            $this->datatables->where('sales.customer_id', $customer);
        }
        if ($start_date) {
            $this->datatables->where($this->db->dbprefix('payments').'.date BETWEEN "' . $start_date . ' 00:00' .'" and "' . $end_date . ' 23:59' . '"');
        }

        echo $this->datatables->generate();

    }

    function alerts() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('stock_alert');
        $bc = array(array('link' => '#', 'page' => lang('stock_alert')));
        $meta = array('page_title' => lang('stock_alert'), 'bc' => $bc);
        $this->page_construct('reports/alerts', $this->data, $meta);

    }

    function get_alerts() {
        $this->load->library('datatables');
        $this->datatables->select($this->db->dbprefix('products').".id as id, ".$this->db->dbprefix('products').".image as image, ".$this->db->dbprefix('products').".code as code, ".$this->db->dbprefix('products').".name as pname, type, ".$this->db->dbprefix('categories').".name as cname, (CASE WHEN psq.quantity IS NULL THEN 0 ELSE psq.quantity END) as quantity, alert_quantity, tax, tax_method, cost, (CASE WHEN psq.price > 0 THEN psq.price ELSE {$this->db->dbprefix('products')}.price END) as price", FALSE)
        ->from('products')
        ->join('categories', 'categories.id=products.category_id')
        ->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$this->session->userdata('store_id')}) psq", 'products.id=psq.product_id', 'left')
        ->where("(CASE WHEN psq.quantity IS NULL THEN 0 ELSE psq.quantity END) < {$this->db->dbprefix('products')}.alert_quantity", NULL, FALSE)
        ->where('products.alert_quantity >', 0)
        ->group_by('products.id');
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='#' class='btn btn-xs btn-primary ap tip' data-id='$1' title='".lang('add_to_purcahse_order')."'><i class='fa fa-plus'></i></a></div>", "id");
        // $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }

    function alertsexpired() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('stock_alert');
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['category'] = $this->reports_model->getAllCategory();
        $bc = array(array('link' => '#', 'page' => lang('stock_alert')));
        $meta = array('page_title' => lang('stock_alert'), 'bc' => $bc);
        $this->page_construct('reports/alertsexpired', $this->data, $meta);

    }
	
	function get_alertsday() {
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        $this->load->library('datatables');
        $this->datatables->select($this->db->dbprefix('products').".id as id, ".$this->db->dbprefix('products').".image as image, ".$this->db->dbprefix('products').".code as code, ".$this->db->dbprefix('products').".name as pname, type, ".$this->db->dbprefix('categories').".name as cname, (CASE WHEN psq.quantity IS NULL THEN 0 ELSE psq.quantity END) as quantity, alert_expiry, expiry_date, tax_method, cost, (CASE WHEN psq.price > 0 THEN psq.price ELSE {$this->db->dbprefix('products')}.price END) as price", FALSE)
        ->from('products')
        ->join('categories', 'categories.id=products.category_id')
        ->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$this->session->userdata('store_id')}) psq", 'products.id=psq.product_id', 'left')
        ->where("(CASE WHEN DATEDIFF({$this->db->dbprefix('products')}.expiry_date,now()) IS NULL THEN 0 ELSE DATEDIFF({$this->db->dbprefix('products')}.expiry_date,now()) END) < {$this->db->dbprefix('products')}.alert_expiry", NULL, FALSE)
        ->group_by('products.id');
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='#' class='btn btn-xs btn-primary ap tip' data-id='$1' title='".lang('add_to_purcahse_order')."'><i class='fa fa-plus'></i></a></div>", "id");
        // $this->datatables->unset_column('id');
        if($product) { $this->datatables->where('products.id', $product); }
		if($category){ $this->datatables->where('categories.id', $category);   }
        if($start_date) { $this->datatables->where('products.expiry_date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('products.expiry_date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function alertsservice() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('alert_service');
        $bc = array(array('link' => '#', 'page' => lang('alert_service')));
        $meta = array('page_title' => lang('alert_service'), 'bc' => $bc);
        $this->page_construct('reports/alertsservice', $this->data, $meta);

    }
	
	function get_alertsservice() {
        $this->load->library('datatables');
        $this->datatables
        ->select($this->db->dbprefix('sale_items').".id as id, ". $this->db->dbprefix('sales').".id as saleid, ".$this->db->dbprefix('sales').".date, ".$this->db->dbprefix('sale_items').".product_name, ".$this->db->dbprefix('sale_items').".product_code, ".$this->db->dbprefix('customers').".name as customer_name, ".$this->db->dbprefix('customers').".phone as customer_phone, ".$this->db->dbprefix('sale_items').".next_service_date, ".$this->db->dbprefix('sale_items').".quantity , ".$this->db->dbprefix('unit').".name as unit, ".$this->db->dbprefix('sale_items').".subtotal, ". $this->db->dbprefix('sales').".inv_number", FALSE)
        ->from('sale_items')
        ->join('products', 'sale_items.product_id=products.id', 'left')
        ->join('unit', 'unit.id=products.unit_id', 'left')
        ->join('sales', 'sale_items.sale_id=sales.id', 'left')
        ->join('customers','customers.id=sales.customer_id','left')
		->join('categories','categories.id=products.category_id','left')
        ->where("(CASE WHEN DATEDIFF({$this->db->dbprefix('sale_items')}.next_service_date,now()) IS NULL THEN 0 ELSE DATEDIFF({$this->db->dbprefix('sale_items')}.next_service_date,now()) END) < {$this->db->dbprefix('products')}.alert_service", NULL, FALSE);
        $this->datatables->add_column("Actions", "<div class='text-center'><a href='" . site_url('sales/edit_service/$1') . "' class='btn btn-xs btn-primary ap tip' data-id='$1' title='".lang('update_service')."'><i class='fa fa-file-text-o'></i></a></div>", "id");
        echo $this->datatables->generate();
    }

    function view_closedregister($id = null) {
        $closed_register = $this->reports_model->getClosedRegisterByID($id);
        $this->data['cash_in_hand'] =$closed_register->cash_in_hand;
        $this->data['register_open_time'] = $closed_register->date;
        $this->data['cc_sales'] = $closed_register->cc_sales;
        $this->data['cash_sales'] = $closed_register->cash_sales;
        $this->data['ch_sales'] = $closed_register->ch_sales;
        $this->data['other_sales'] = $closed_register->other_sales;
        $this->data['gc_sales'] = $closed_register->gc_sales;
        $this->data['total_sales'] = $closed_register->total_sales;
        $this->data['nbr_sales'] = $closed_register->nbr_sales;
        $this->data['user'] = $this->site->getUser($closed_register->user_id);
        $this->data['user_id'] = $closed_register->user_id;
        $this->data['expenses'] = $this->reports_model->getRegisterExpenses($closed_register->date, $closed_register->closed_at, $closed_register->user_id);
        $this->data['sale_items'] = $this->reports_model->getClosedRegisterSaleItems($closed_register->date, $closed_register->closed_at, $closed_register->user_id);
        $this->data['sales_discount_tax'] = $this->reports_model->getRegisterSalesDiscountTax($closed_register->date, $closed_register->closed_at, $closed_register->user_id);  
        $this->data['total_cash_1'] = $closed_register->total_cash_1;
        $this->data['total_cash_2'] = $closed_register->total_cash_2;
        $this->data['total_cash_3'] = $closed_register->total_cash_3;
        $this->load->view($this->theme . 'reports/close_register', $this->data);    
    }

    function get_adjustmentreport() {
        $type = $this->input->get('type') ? $this->input->get('type') : NULL;
        $product = $this->input->get('product') ? $this->input->get('product') : NULL;
		$category = $this->input->get('category') ? $this->input->get('category') : NULL;	
        $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;

        $this->load->library('datatables');
        $this->datatables->select("date,name,code,adjustment_items.quantity as quantity,adjustment_items.type,adjustment_id, reference");
        $this->datatables->from('adjustment_items')
        ->join('products','products.id=adjustment_items.product_id','left')
        ->join('adjustments','adjustment_items.adjustment_id=adjustments.id','left');       

        if($type) { $this->datatables->where('adjustment_items.type', $type); }
        if($product) { $this->datatables->where('products.id', $product); }
		if($category){ $this->datatables->where('category_id', $category);   }	
        if($start_date) { $this->datatables->where('adjustments.date >=', $start_date . ' 00:00'); }
        if($end_date) { $this->datatables->where('adjustments.date <=', $end_date . ' 23:59'); }
        echo $this->datatables->generate();
    }

    function adjustments() {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['products'] = $this->reports_model->getAllProducts();
        $this->data['page_title'] = $this->lang->line("adjustment_report");
        $this->data['category'] = $this->reports_model->getAllCategory();
		$this->data['users'] = $this->reports_model->getAllStaff();
        $bc = array(array('link' => '#', 'page' => lang('reports')), array('link' => '#', 'page' => lang('adjustment_report')));
        $meta = array('page_title' => lang('adjustment_report'), 'bc' => $bc);
        $this->page_construct('reports/adjustments', $this->data, $meta);
    }

}
