<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('products_model');
    }

    function index() {
        if($this->Print){
            redirect('sales');
        }
        $stores = $this->site->getAllStores();        
        if ($this->input->get('store_id') && !$this->session->userdata('has_store_id')) {
            $this->data['store'] = $this->site->getStoreByID($this->input->get('store_id', TRUE));
        } elseif ($this->session->userdata('store_id')) {
            $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        } else {
            $this->data['store'] = current($stores);
        }
        if ($this->input->get('category_id')){
            $this->data['category'] = $this->input->get('category_id');
        } else {
            $this->data['category'] = 0;
        }
        $this->data['stores'] = $stores;
        $this->data['categories'] = $this->site->getAllCategories();
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('products');
        $bc = array(array('link' => '#', 'page' => lang('products')));
        $meta = array('page_title' => lang('products'), 'bc' => $bc);
        $this->page_construct('products/index', $this->data, $meta);

    }

    function get_products($store_id, $category_id) {

        $this->load->library('datatables');
       // if ($this->Admin) {
            $this->datatables->select($this->db->dbprefix('products').".id as pid, ".$this->db->dbprefix('products').".image as image, ".$this->db->dbprefix('products').".code as code, ".$this->db->dbprefix('products').".name as pname, type, ".$this->db->dbprefix('categories').".name as cname, psq.quantity, ".$this->db->dbprefix('unit').".name as unit, tax, tax_method, cost, (CASE WHEN psq.price > 0 THEN psq.price ELSE {$this->db->dbprefix('products')}.price END) as price, (CASE WHEN psq.price_wholesale > 0 THEN psq.price_wholesale ELSE {$this->db->dbprefix('products')}.price_wholesale END) as price_wholesale, (CASE WHEN psq.price_vip > 0 THEN psq.price_vip ELSE {$this->db->dbprefix('products')}.price_vip END) as price_vip, barcode_symbology, (IF(psq.quantity>0,psq.quantity,0) * cost) as stock_value, ".$this->db->dbprefix('products').".second_name as second_name, (psq.quantity / ".$this->db->dbprefix('products').".divided1) as divided1, (psq.quantity / ".$this->db->dbprefix('products').".divided2) as divided2", FALSE);
        //} else {
            //$this->datatables->select($this->db->dbprefix('products').".id as pid, ".$this->db->dbprefix('products').".image as image, ".$this->db->dbprefix('products').".code as code, ".$this->db->dbprefix('products').".name as pname, type, ".$this->db->dbprefix('categories').".name as cname, psq.quantity, ".$this->db->dbprefix('unit').".name as unit, tax, tax_method, (CASE WHEN psq.price > 0 THEN psq.price ELSE {$this->db->dbprefix('products')}.price END) as price, barcode_symbology, ".$this->db->dbprefix('products').".second_name as second_name,", FALSE);
        //}

        if ($this->Settings->multistore_quantity) {$store_id=1;}
        if (($this->Settings->multi_store) && ($this->Settings->multistore_product)){ 
            $this->datatables->from('products')
            ->join('categories', 'categories.id=products.category_id', 'left')
            ->join('unit', 'unit.id=products.unit_id', 'left')
            //->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$store_id} AND price>0) psq", 'products.id=psq.product_id', 'right')
            ->join("(SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$store_id}) psq", 'products.id=psq.product_id', 'left')
            ->where("categories.store_id= {$store_id} ")
            ->group_by('products.id');
            //if($this->Settings->overselling == 0){
            //    $this->datatables->where('psq.quantity > 0');
            //} 
        }else{
            $this->datatables->from('products')
            ->join('categories', 'categories.id=products.category_id', 'left')
            ->join('unit', 'unit.id=products.unit_id', 'left')
            ->join("( SELECT * from {$this->db->dbprefix('product_store_qty')} WHERE store_id = {$store_id}) psq", 'products.id=psq.product_id', 'left')
            ->group_by('products.id');
            //if($this->Settings->overselling == 0){
            //    $this->datatables->where('psq.quantity > 0');
            //}    
        }
        if($category_id != 0){
            $this->datatables->where("products.category_id",$category_id);
        }

        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('products/view/$1')."' title='" . lang("view") . "' class='tip btn btn-primary btn-xs' data-toggle='ajax'><i class='fa fa-file-text-o'></i></a><a href='".site_url('products/single_label_pdf/$1')."' title='".lang('print_labels')."' class='tip btn btn-default btn-xs'><i class='fa fa-print'></i></a> <a href='" . site_url('products/edit/$1') . "' title='" . lang("edit_product") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('products/copy/$1') . "' title='" . lang("copy_product") . "' class='tip btn btn-default btn-xs'><i class='fa fa-copy'></i></a> <a href='" . site_url('products/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_product') . "')\" title='" . lang("delete_product") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "pid, image, code, pname, barcode_symbology");

        $this->datatables->unset_column('pid')->unset_column('barcode_symbology');
        echo $this->datatables->generate();

    }

    function view($id = NULL) {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $product = $this->site->getProductByID($id);
        $this->data['product'] = $product;
        $this->data['category'] = $this->site->getCategoryByID($product->category_id);
        $this->data['combo_items'] = $product->type == 'combo' ? $this->products_model->getComboItemsByPID($id) : NULL;
        $this->load->view($this->theme.'products/view', $this->data);

    }

    function barcode($product_code = NULL) {
        if ($this->input->get('code')) {
            $product_code = $this->input->get('code');
        }
        $data['product_details'] = $this->products_model->getProductByCode($product_code);
        $data['img'] = "<img src='" . base_url() . "index.php?products/gen_barcode&code={$product_code}' alt='{$product_code}' />";
        $this->load->view('barcode', $data);

    }

    function product_barcode($product_code = NULL, $bcs = 'code128', $height = 60) {
        if ($this->input->get('code')) {
            $product_code = $this->input->get('code');
        }
        return $this->tec->barcode($product_code, $bcs, $height);
    }

    function gen_barcode($product_code = NULL, $bcs = 'code128', $height = 60, $text = 1) {
        return $this->tec->barcode($product_code, $bcs, $height, $text);
    }

    function print_barcodes_old() {
        $limit = 10;
        $this->load->helper('pagination');
        $page = $this->input->get('page');
        $total = $this->products_model->products_count();
        $info = ['page' => $page, 'total' => ceil($total/$limit)];
        $pagination = pagination('products/print_barcodes', $total, $limit, true);
        $products = $this->products_model->fetch_products($limit, (!empty($page) ? (($page-1)*$limit) : 0));
        $r = 1;
        $html = "";
        $html .= '<table class="table table-bordered table-centered mb0">
        <tbody><tr>';
        foreach ($products as $pr) {
            if ($r != 1) {
                $rw = (bool)($r & 1);
                $html .= $rw ? '</tr><tr>' : '';
            }
            $html .= '<td><h4>' . $this->Settings->site_name . '</h4><strong>' . $pr->name . '</strong><br>' . $this->product_barcode($pr->code, $pr->barcode_symbology, 60) . '<br><span class="price">'.lang('price') .': ' . $this->tec->formatMoney($pr->price) . '</span></td>';
            $r++;
        }
        $html .= '</tr></tbody>
        </table>';
        $this->data['links'] = $pagination;
        $this->data['html'] = $html;
        $this->data['page_title'] = lang("print_barcodes");
        $this->load->view($this->theme.'products/print_barcodes', $this->data);
    }

    function print_barcodes() {
        $limit = 10;
        $this->load->helper('pagination');
        $page = $this->input->get('page');
        $total = $this->products_model->products_count();
        $info = ['page' => $page, 'total' => ceil($total/$limit)];
        $pagination = pagination('products/print_barcodes', $total, $limit, true);
        $products = $this->products_model->fetch_products($limit, (!empty($page) ? (($page-1)*$limit) : 0));
        $r = 1;
        $html = "";
        $html .= '<table class="table table-bordered table-centered mb0">
        <tbody><tr>';
        foreach ($products as $pr) {
            if ($r != 1) {
                $rw = (bool)($r & 1);
                $html .= $rw ? '</tr><tr>' : '';
            }
            $html .= "<td><div><img src=\"".base_url()."uploads/thumbs/".$pr->image."\" alt=\"".$pr->name."\" style=\"width: 110px; height: 110px;\"></div><strong>" . $pr->name . '</strong><br>' . $this->product_barcode($pr->code, $pr->barcode_symbology, 60) . '<br><span class="price">'.lang('price') .': ' . $this->tec->formatMoney($pr->price) . '</span></td>';
            $r++;
        }
        $html .= '</tr></tbody>
        </table>';
        $this->data['links'] = $pagination;
        $this->data['html'] = $html;
        $this->data['page_title'] = lang("print_barcodes");
        $this->load->view($this->theme.'products/print_barcodes', $this->data);
    }

    function print_labels() {
        $limit = 10;
        $this->load->helper('pagination');
        $page = $this->input->get('page');
        $total = $this->products_model->products_count();
        $info = ['page' => $page, 'total' => ceil($total/$limit)];
        $pagination = pagination('products/print_labels', $total, $limit, true);
        $products = $this->products_model->fetch_products($limit, (!empty($page) ? (($page-1)*$limit) : 0));
        $html = "";
        foreach ($products as $pr) {
            $html .= '<div class="text-center labels break-after" style="font-size:8px; margin:0; padding-top:10px; margin-left:-10px;"><p style="margin-bottom:5px;"><strong>' . $pr->name . '</p>' . $this->product_barcode($pr->code, $pr->barcode_symbology, 25) . '<br><p class="price" style="margin-top:5px;">'.lang('price') .': ' . $this->tec->formatMoney($pr->price) . '</p></div>';
        }
        $this->data['links'] = $pagination;
        $this->data['html'] = $html;
        $this->data['page_title'] = lang("print_labels");
        $this->load->view($this->theme.'products/print_labels', $this->data);
    }

    function single_barcode($product_id = NULL) {

        $product = $this->site->getProductByID($product_id);

        $html = "";
        $html .= '<table class="table table-bordered table-centered mb0">
        <tbody><tr>';
        /*
        if($product->quantity > 0) {
            for ($r = 1; $r <= $product->quantity; $r++) {
                if ($r != 1) {
                    $rw = (bool)($r & 1);
                    $html .= $rw ? '</tr><tr>' : '';
                }
                $html .= '<td><h4>' . $this->Settings->site_name . '</h4><strong>' . $product->name . '</strong><br>' . $this->product_barcode($product->code, $product->barcode_symbology, 60) . ' <br><span class="price">'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</span></td>';
            }
        } else {
            for ($r = 1; $r <= 5; $r++) {
                if ($r != 1) {
                    $rw = (bool)($r & 1);
                    $html .= $rw ? '</tr><tr>' : '';
                }
                $html .= '<td><h4>' . $this->Settings->site_name . '</h4><strong>' . $product->name . '</strong><br>' . $this->product_barcode($product->code, $product->barcode_symbology, 60) . ' <br><span class="price">'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</span></td>';
            }
        }
        */ 
        for ($r = 1; $r <= 5; $r++) { //print 25 barcode stickers
                for ($j = 1; $j<=5; $j++) {
                    $html .= '<td><h4>' . $this->Settings->site_name . '</h4><strong>' . $product->name . '</strong><br>' . $this->product_barcode($product->code, $product->barcode_symbology, 50) . ' <br><span class="price">'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</span></td>';
                }
                $html .= '</tr><tr>';
            }
        $html .= '</tr></tbody>
        </table>';

        $this->data['html'] = $html;
        $this->data['page_title'] = lang("print_barcodes").' ('.$product->name.')';
        $this->load->view($this->theme . 'products/single_barcode', $this->data);
    }

    function single_label($product_id = NULL, $warehouse_id = NULL) {

        $product = $this->site->getProductByID($product_id);
        $html = "";
        if($product->quantity > 0) {
            for ($r = 1; $r <= $product->quantity; $r++) {
                $html .= '<div class="text-center labels break-after" style="font-size:8px; margin:0; padding-top:10px; margin-left:-15px;"><p style="margin-bottom:5px;">' . $product->name . '</p>' . $this->product_barcode($product->code, $product->barcode_symbology, 25) . ' <br><p class="price" style="margin-top:5px;">'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p></div>';
            }
        } else {
            for ($r = 1; $r <= 10; $r++) {
                $html .= '<div class="text-center labels break-after" style="font-size:8px; margin:0; padding-top:10px; margin-left:-15px;"><p style="margin-bottom:5px;">' . $product->name . '</p>' . $this->product_barcode($product->code, $product->barcode_symbology, 25) . ' <br><p class="price" style="margin-top:5px;">'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p></div>';
            }
        }
        $this->data['html'] = $html;
        $this->data['page_title'] = lang("print_labels").' ('.$product->name.')';
        $this->load->view($this->theme . 'products/single_label', $this->data);

    }

    function single_label_pdf($product_id = NULL, $warehouse_id = NULL) {
        $product = $this->site->getProductByID($product_id);
		$label_fontsize = ($this->Settings->label_fontsize > 0) ? $this->Settings->label_fontsize : 8;
        $label_width = ($this->Settings->label_width > 0) ? $this->Settings->label_width : 40;
        $label_height = ($this->Settings->label_height > 0) ? $this->Settings->label_height : 25;
		//$price_fontsize = $label_fontsize + 2.5;
        /*
        if($this->Settings->exchange_rate>0) {
            if($this->Settings->exchange_rate_multiply == '*') {
                $price_exc = $product->price * $this->Settings->exchange_rate;
            } else {
                $price_exc = $product->price / $this->Settings->exchange_rate;
            }
            $html = '<div><p>' . $product->name . '</p><p>' . $this->product_barcode($product->code, $product->barcode_symbology, 25) . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) . ' (' .  $this->tec->formatMoneyExc($price_exc,$this->Settings->exchange_rate_symbol) . ')</p></div>';
        }
        */
        $html = '<div><p>' . $product->name . '</p><p>' . $this->product_barcode($product->code, $product->barcode_symbology, $label_height) . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p></div>';
        //$html = '<div><p>' . $product->name . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p><p class="mycode">' . $this->product_barcode($product->code, $product->barcode_symbology, $label_height) . '</p></div>';
        
        $stylesheet = '@page{margin:2px;} body{margin:0;padding:0;} p{margin:0;padding:0;color:#000;text-align:center;font-size:' . $label_fontsize . 'px;} td{text-align:center;} .mycode{margin-top:10px;}';
        $savepath = "label-" . $product->code . "-" . time() . ".pdf";    
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[$label_width, $label_height],"D");
    }

    //Sample for label printer with 3 columns size 30x15
    function single_label_pdf_3($product_id = NULL, $warehouse_id = NULL) {
        $product = $this->site->getProductByID($product_id);
        $html = '<table><tr><td><p>' . $product->name . '</p><p>' . $this->product_barcode($product->code, $product->barcode_symbology, 12) . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p></td>' . '<td style="padding-left:5px;"><p>' . $product->name . '</p><p>' . $this->product_barcode($product->code, $product->barcode_symbology, 12) . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) . '</p></td>' . '<td style="padding-left:5px;"><p>' . $product->name . '</p><p>' . $this->product_barcode($product->code, $product->barcode_symbology, 12) . '</p><p>'.lang('price') .': ' . $this->tec->formatMoney($product->price) .'</p></td></tr></table>';
        $label_fontsize = ($this->Settings->label_fontsize > 0) ? $this->Settings->label_fontsize : 8;
        $label_width = ($this->Settings->label_width > 0) ? $this->Settings->label_width : 40;
        $label_height = ($this->Settings->label_height > 0) ? $this->Settings->label_height : 25;
        $stylesheet = '@page{margin:3px;} body{margin:0;padding:0;} p{margin:0;padding:0;color:#000;text-align:center;font-size:' . $label_fontsize . 'px;} td{text-align:center;}';
        $savepath = "label-" . $product->code . "-" . time() . ".pdf";    
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[$label_width * 3, $label_height],"D");
    }

    function add() {
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('code', lang("product_code"), 'trim|is_unique[products.code]|min_length[2]|max_length[50]');
        $this->form_validation->set_rules('name', lang("product_name"), 'required');
        $this->form_validation->set_rules('category', lang("category"), 'required');
        if ($this->Settings->show_unit){
        $this->form_validation->set_rules('unit', lang("unit"), 'required');
        }
        $this->form_validation->set_rules('price', lang("product_price"), 'required|is_numeric');
        if ($this->input->post('type') != 'service') {
            $this->form_validation->set_rules('cost', lang("product_cost"), 'required|is_numeric');
        }
        $this->form_validation->set_rules('product_tax', lang("product_tax"), 'required|is_numeric');
        $this->form_validation->set_rules('alert_quantity', lang("alert_quantity"), 'is_numeric');
        $this->form_validation->set_rules('alert_expiry', lang("alert_expiry"), 'is_numeric');

        if ($this->form_validation->run() == true) {
            $last_product = $this->site->getLastTableRecord('products'); 
            $prod_code = $this->input->post('code') ? $this->input->post('code') : str_pad($last_product->id + 1, 6, '0', STR_PAD_LEFT);

            $data = array(
                'type' => $this->input->post('type'),
                'code' => $prod_code,
                'name' => $this->input->post('name'),
                'category_id' => $this->input->post('category'),
                'price' => $this->input->post('price'),
                'price_wholesale' => $this->input->post('price_wholesale'),
                'price_vip' => $this->input->post('price_vip'),
                'cost' => $this->input->post('cost'),
                'tax' => $this->input->post('product_tax'),
                'tax_method' => $this->input->post('tax_method'),
                'alert_quantity' => $this->input->post('alert_quantity'),
                'details' => $this->input->post('details'),
                'barcode_symbology' => $this->input->post('barcode_symbology'),
                'unit_id' => $this->input->post('unit'),
                'alert_expiry' => $this->input->post('alert_expiry'),
                'expiry_date' => $this->input->post('expiry_date'),
                'beverage' => $this->input->post('beverage'),
                'ingredient' => $this->input->post('ingredient'),
                'service_month' => $this->input->post('service_month'),
                'alert_service' => $this->input->post('alert_service'),
                'second_name' => $this->input->post('second_name'),
                'promotion' => $this->input->post('promotion'),
                'promo_price' => $this->input->post('promo_price'),
                'start_date' => $this->input->post('start_date'),
                'end_date' => $this->input->post('end_date'),
                'divided1' => $this->input->post('divided1'),
                'divided2' => $this->input->post('divided2'),
                );

            if ($this->Settings->multi_store) {
                $stores = $this->site->getAllStores();
                foreach ($stores as $store) {
                    if ($this->Settings->multistore_product) {$this->form_validation->set_rules('price'.$store->id, lang("product_price") . ' ' . $store->name, 'required|is_numeric');}
                    $store_quantities[] = array(
                        'store_id' => $store->id,
                        'quantity' => $this->input->post('quantity'.$store->id),
                        'price' => $this->input->post('price'.$store->id),
                        'price_wholesale' => $this->input->post('price_wholesale'.$store->id),
                        'price_vip' => $this->input->post('price_vip'.$store->id)                  
                        );
                }
            } else {
                $store_quantities[] = array(
                    'store_id' => 1,
                    'quantity' => $this->input->post('quantity'),
                    'price' => $this->input->post('price'),
                    'price_wholesale' => $this->input->post('price_wholesale'),
                    'price_vip' => $this->input->post('price_vip')                    
                    );
            }

            if ($this->input->post('type') == 'combo') {
                $c = sizeof($_POST['combo_item_code']) - 1;
                for ($r = 0; $r <= $c; $r++) {
                    if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
                        $items[] = array(
                            'item_code' => $_POST['combo_item_code'][$r],
                            'quantity' => $_POST['combo_item_quantity'][$r]
                        );
                    }
                }
            } else {
                $items = array();
            }

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = '5000';
                $config['max_width'] = '8000';
                $config['max_height'] = '8000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("products/add");
                }

                $photo = $this->upload->file_name;
                $data['image'] = $photo;

                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'uploads/' . $photo;
                $config['new_image'] = 'uploads/thumbs/' . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 110;
                $config['height'] = 110;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    $this->session->set_flashdata('error', $this->image_lib->display_errors());
                    redirect("products/add");
                }

            }
            // $this->tec->print_arrays($data, $items);
        }

        if ($this->form_validation->run() == true && $this->products_model->addProduct($data, $store_quantities, $items)) {

            $this->session->set_flashdata('message', lang("product_added"));
            redirect('products');

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['units'] = $this->site->getAllUnit();
            $this->data['page_title'] = lang('add_product');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('add_product')));
            $meta = array('page_title' => lang('add_product'), 'bc' => $bc);
            $this->page_construct('products/add', $this->data, $meta);

        }
    }

    function edit($id = NULL) {
        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $pr_details = $this->site->getProductByID($id);
        if ($this->input->post('code') != $pr_details->code) {
            $this->form_validation->set_rules('code', lang("product_code"), 'is_unique[products.code]');
        }
        $this->form_validation->set_rules('code', lang("product_code"), 'trim|min_length[2]|max_length[50]|required');
        $this->form_validation->set_rules('name', lang("product_name"), 'required');
        $this->form_validation->set_rules('category', lang("category"), 'required');
        if ($this->Settings->show_unit){
        $this->form_validation->set_rules('unit', lang("unit"), 'required');
        }
        $this->form_validation->set_rules('price', lang("product_price"), 'required|is_numeric');
        $this->form_validation->set_rules('price_wholesale', lang("product_price_wholesale"), 'required|is_numeric');
        $this->form_validation->set_rules('price_vip', lang("product_price_vip"), 'required|is_numeric');
        $this->form_validation->set_rules('cost', lang("product_cost"), 'required|is_numeric');
        $this->form_validation->set_rules('product_tax', lang("product_tax"), 'required|is_numeric');
        $this->form_validation->set_rules('alert_quantity', lang("alert_quantity"), 'is_numeric');
        $this->form_validation->set_rules('alert_expiry', lang("alert_expiry"), 'is_numeric');

        if ($this->form_validation->run() == true) {


            $data = array(
                'type' => $this->input->post('type'),
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'category_id' => $this->input->post('category'),
                'price' => $this->input->post('price'),
                'price_wholesale' => $this->input->post('price_wholesale'),
                'price_vip' => $this->input->post('price_vip'),
                'cost' => $this->input->post('cost'),
                'tax' => $this->input->post('product_tax'),
                'tax_method' => $this->input->post('tax_method'),
                'alert_quantity' => $this->input->post('alert_quantity'),
                'details' => $this->input->post('details'),
                'barcode_symbology' => $this->input->post('barcode_symbology'),
                'unit_id' => $this->input->post('unit'),
                'alert_expiry' => $this->input->post('alert_expiry'),
                'expiry_date' => $this->input->post('expiry_date'),
                'beverage' => $this->input->post('beverage'),
                'ingredient' => $this->input->post('ingredient'),
                'service_month' => $this->input->post('service_month'),
                'alert_service' => $this->input->post('alert_service'),
                'second_name' => $this->input->post('second_name'),
                'promotion' => $this->input->post('promotion'),
                'promo_price' => $this->input->post('promo_price'),
                'start_date' => $this->input->post('start_date'),
                'end_date' => $this->input->post('end_date'),
                'divided1' => $this->input->post('divided1'),
                'divided2' => $this->input->post('divided2'),
                );

            if ($this->Settings->multi_store) {
                $stores = $this->site->getAllStores();
                foreach ($stores as $store) {
                    $store_quantities[] = array(
                        'store_id' => $store->id,
                        'quantity' => $this->input->post('quantity'.$store->id),
                        'price' => $this->input->post('price'.$store->id),
                        'price_wholesale' => $this->input->post('price_wholesale'),
                        'price_vip' => $this->input->post('price_vip')
                        );
                }
            } else {
                $store_quantities[] = array(
                    'store_id' => 1,
                    'quantity' => $this->input->post('quantity'),
                    'price' => $this->input->post('price'),
                    'price_wholesale' => $this->input->post('price_wholesale'),
                    'price_vip' => $this->input->post('price_vip')
                    );
            }

            if ($this->input->post('type') == 'combo') {
                $c = sizeof($_POST['combo_item_code']) - 1;
                for ($r = 0; $r <= $c; $r++) {
                    if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
                        $items[] = array(
                            'item_code' => $_POST['combo_item_code'][$r],
                            'quantity' => $_POST['combo_item_quantity'][$r]
                        );
                    }
                }
            } else {
                $items = array();
            }

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = '5000';
                $config['max_width'] = '8000';
                $config['max_height'] = '8000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("products/edit/" . $id);
                }

                $photo = $this->upload->file_name;

                $this->load->helper('file');
                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'uploads/' . $photo;
                $config['new_image'] = 'uploads/thumbs/' . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 110;
                $config['height'] = 110;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    $this->session->set_flashdata('error', $this->image_lib->display_errors());
                    redirect("products/edit/" . $id);
                }

            } else {
                $photo = NULL;
            }

        }

        if ($this->form_validation->run() == true && $this->products_model->updateProduct($id, $data, $store_quantities, $items, $photo)) {

            $this->session->set_flashdata('message', lang("product_updated"));
            redirect("products/?category_id=".$data['category_id']);

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $product = $this->site->getProductByID($id);
            if($product->type == 'combo') {
                $combo_items = $this->products_model->getComboItemsByPID($id);
                foreach ($combo_items as $combo_item) {
                    $cpr = $this->site->getProductByID($combo_item->id);
                    $cpr->qty = $combo_item->qty;
                    $items[] = array('id' => $cpr->id, 'row' => $cpr);
                }
                $this->data['items'] = $items;
            }
            $this->data['product'] = $product;
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['stores_quantities'] = $this->Settings->multi_store ? $this->products_model->getStoresQuantity($id) : $this->products_model->getStoreQuantity($id);
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['units'] = $this->site->getAllUnit();
            $this->data['page_title'] = lang('edit_product');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('edit_product')));
            $meta = array('page_title' => lang('edit_product'), 'bc' => $bc);
            $this->page_construct('products/edit', $this->data, $meta);

        }
    }

    function import() {
        set_time_limit(0);
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        $this->load->helper('security');
        $this->form_validation->set_rules('userfile', lang("upload_file"), 'xss_clean');

        if ($this->form_validation->run() == true) {
            if (DEMO) {
                $this->session->set_flashdata('warning', lang("disabled_in_demo"));
                redirect('pos');
            }

            if (isset($_FILES["userfile"])) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'csv';
                $config['max_size'] = '500';
                $config['overwrite'] = TRUE;

                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("products/import");
                }


                $csv = $this->upload->file_name;

                $arrResult = array();
                $handle = fopen("uploads/" . $csv, "r");
                if ($handle) {
                    while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
                        $arrResult[] = $row;
                    }
                    fclose($handle);
                }
                array_shift($arrResult);

                $keys = array('code', 'name', 'second_name', 'cost', 'tax', 'price', 'category', 'type');

                $final = array();
                foreach ($arrResult as $key => $value) {
                    $final[] = array_combine($keys, $value);
                }

                if (sizeof($final) > 1001) {
                    $this->session->set_flashdata('error', lang("more_than_allowed"));
                    redirect("products/import");
                }

                foreach ($final as $csv_pr) {
                    if ($this->products_model->getProductByCode($csv_pr['code'])) {
                        $this->session->set_flashdata('error', lang("check_product_code") . " (" . $csv_pr['code'] . "). " . lang("code_already_exist"));
                        redirect("products/import");
                    }
                    if (!is_numeric($csv_pr['tax'])) {
                        $this->session->set_flashdata('error', lang("check_product_tax") . " (" . $csv_pr['tax'] . "). " . lang("tax_not_numeric"));
                        redirect("products/import");
                    }
                    if(! ($category = $this->site->getCategoryByCode($csv_pr['category']))) {
                        $this->session->set_flashdata('error', lang("check_category") . " (" . $csv_pr['category'] . "). " . lang("category_x_exist"));
                        redirect("products/import");
                    }
                    $data[] = array(
                        'type' => $csv_pr['type'],
                        'code' => $csv_pr['code'],
                        'name' => $csv_pr['name'],
                        'second_name' => $csv_pr['second_name'],
                        'cost' => $csv_pr['cost'],
                        'tax' => $csv_pr['tax'],
                        'price' => $csv_pr['price'],
                        'category_id' => $category->id
                        
                    );
                }
                //print_r($data); die();
            }

        }

        if ($this->form_validation->run() == true && $this->products_model->add_products($data)) {

            $this->session->set_flashdata('message', lang("products_added"));
            redirect('products');

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['page_title'] = lang('import_products');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('import_products')));
            $meta = array('page_title' => lang('import_products'), 'bc' => $bc);
            $this->page_construct('products/import', $this->data, $meta);

        }
    }


    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if (! ($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        if ($this->products_model->deleteProduct($id)) {
            $this->session->set_flashdata('message', lang("product_deleted"));
            redirect('products');
        }

    }

    function suggestions() {
         $term = $this->input->get('term', TRUE);

         $rows = $this->products_model->getProductNames($term);
         if ($rows) {
             foreach ($rows as $row) {
                 $row->qty = 1;
                 $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row);
             }
             echo json_encode($pr);
         } else {
             echo json_encode(array(array('id' => 0, 'label' => lang('no_match_found'), 'value' => $term)));
         }
    }
    function update_price() {
        if ($this->Staff) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        
        $this->form_validation->set_rules('type', lang("type"), 'required');
        $this->form_validation->set_rules('category', lang("category"), 'required'); 
        
        if($this->input->post('type') != 'assign'){
            $this->form_validation->set_rules('percentage', lang("percentage"), 'required');  
            $this->form_validation->set_rules('from', lang("from"), 'required');   
        }

        if ($this->form_validation->run() == true && $this->products_model->updatePrice($this->input->post('type'),$this->input->post('category'),$this->input->post('percentage'),$this->input->post('from'),$this->input->post('price'),$this->input->post('price_wholesale'),$this->input->post('price_vip'))) {

            $this->session->set_flashdata('message', lang("product_updated"));
            redirect('products');

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['page_title'] = lang('update_price');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('update_price')));
            $meta = array('page_title' => lang('update_price'), 'bc' => $bc);
            $this->page_construct('products/update_price', $this->data, $meta);

        }
    }

    function copy($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $pr_details = $this->site->getProductByID($id);
        if ($this->input->post('code') != $pr_details->code) {
            $this->form_validation->set_rules('code', lang("product_code"), 'is_unique[products.code]');
        }
        $this->form_validation->set_rules('code', lang("product_code"), 'trim|min_length[2]|max_length[50]|required');
        $this->form_validation->set_rules('name', lang("product_name"), 'required');
        $this->form_validation->set_rules('category', lang("category"), 'required');
        if ($this->Settings->show_unit){
        $this->form_validation->set_rules('unit', lang("unit"), 'required');
        }
        $this->form_validation->set_rules('price', lang("product_price"), 'required|is_numeric');
        $this->form_validation->set_rules('price_wholesale', lang("product_price_wholesale"), 'required|is_numeric');
        $this->form_validation->set_rules('price_vip', lang("product_price_vip"), 'required|is_numeric');
        $this->form_validation->set_rules('cost', lang("product_cost"), 'required|is_numeric');
        $this->form_validation->set_rules('product_tax', lang("product_tax"), 'required|is_numeric');
        $this->form_validation->set_rules('alert_quantity', lang("alert_quantity"), 'is_numeric');
        $this->form_validation->set_rules('alert_expiry', lang("alert_expiry"), 'is_numeric');

        if ($this->form_validation->run() == true) {


            $data = array(
                'type' => $this->input->post('type'),
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'category_id' => $this->input->post('category'),
                'price' => $this->input->post('price'),
                'price_wholesale' => $this->input->post('price_wholesale'),
                'price_vip' => $this->input->post('price_vip'),
                'cost' => $this->input->post('cost'),
                'tax' => $this->input->post('product_tax'),
                'tax_method' => $this->input->post('tax_method'),
                'alert_quantity' => $this->input->post('alert_quantity'),
                'details' => $this->input->post('details'),
                'barcode_symbology' => $this->input->post('barcode_symbology'),
                'unit_id' => $this->input->post('unit'),
                'alert_expiry' => $this->input->post('alert_expiry'),
                'expiry_date' => $this->input->post('expiry_date'),
                'beverage' => $this->input->post('beverage'),
                'ingredient' => $this->input->post('ingredient'),
                'service_month' => $this->input->post('service_month'),
                'alert_service' => $this->input->post('alert_service'),
                'second_name' => $this->input->post('second_name'),
                'promotion' => $this->input->post('promotion'),
                'promo_price' => $this->input->post('promo_price'),
                'start_date' => $this->input->post('start_date'),
                'end_date' => $this->input->post('end_date'),
                );

            if ($this->Settings->multi_store) {
                $stores = $this->site->getAllStores();
                foreach ($stores as $store) {
                    $store_quantities[] = array(
                        'store_id' => $store->id,
                        'quantity' => $this->input->post('quantity'.$store->id),
                        'price' => $this->input->post('price'.$store->id),
                        'price_wholesale' => $this->input->post('price_wholesale'),
                        'price_vip' => $this->input->post('price_vip')
                        );
                }
            } else {
                $store_quantities[] = array(
                    'store_id' => 1,
                    'quantity' => $this->input->post('quantity'),
                    'price' => $this->input->post('price'),
                    'price_wholesale' => $this->input->post('price_wholesale'),
                    'price_vip' => $this->input->post('price_vip')
                    );
            }

            if ($this->input->post('type') == 'combo') {
                $c = sizeof($_POST['combo_item_code']) - 1;
                for ($r = 0; $r <= $c; $r++) {
                    if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
                        $items[] = array(
                            'item_code' => $_POST['combo_item_code'][$r],
                            'quantity' => $_POST['combo_item_quantity'][$r]
                        );
                    }
                }
            } else {
                $items = array();
            }

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'gif|jpg|png|jpeg';
                $config['max_size'] = '5000';
                $config['max_width'] = '8000';
                $config['max_height'] = '8000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("products/copy/". $id);
                }

                $photo = $this->upload->file_name;
                $data['image'] = $photo;

                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'uploads/' . $photo;
                $config['new_image'] = 'uploads/thumbs/' . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 110;
                $config['height'] = 110;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    $this->session->set_flashdata('error', $this->image_lib->display_errors());
                    redirect("products/copy/". $id);
                }

            }

        }

        if ($this->form_validation->run() == true && $this->products_model->addProduct($data, $store_quantities, $items)) {

            $this->session->set_flashdata('message', lang("product_added"));
            redirect("products");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $product = $this->site->getProductByID($id);
            if($product->type == 'combo') {
                $combo_items = $this->products_model->getComboItemsByPID($id);
                foreach ($combo_items as $combo_item) {
                    $cpr = $this->site->getProductByID($combo_item->id);
                    $cpr->qty = $combo_item->qty;
                    $items[] = array('id' => $cpr->id, 'row' => $cpr);
                }
                $this->data['items'] = $items;
            }
            $this->data['product'] = $product;
            $this->data['stores'] = $this->site->getAllStores();
            $this->data['stores_quantities'] = $this->Settings->multi_store ? $this->products_model->getStoresQuantity($id) : $this->products_model->getStoreQuantity($id);
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['units'] = $this->site->getAllUnit();
            $this->data['page_title'] = lang('copy_product');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('copy_product')));
            $meta = array('page_title' => lang('copy_product'), 'bc' => $bc);
            $this->page_construct('products/copy', $this->data, $meta);

        }
    }

}
