<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product_options extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('product_options_model');
    }

    function index() {

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['product_options'] = $this->site->getAllProductOptions();
        $this->data['page_title'] = lang('product_options');
        $bc = array(array('link' => '#', 'page' => lang('product_options')));
        $meta = array('page_title' => lang('product_options'), 'bc' => $bc);
        $this->page_construct('product_options/index', $this->data, $meta);

    }

    function get_product_options() {

        $this->load->library('datatables');
        $this->datatables->select($this->db->dbprefix('product_options').".id, ".$this->db->dbprefix('product_options').".code, ".$this->db->dbprefix('product_options').".name,".$this->db->dbprefix('product_options').".type,".$this->db->dbprefix('product_options').".additional_price,".$this->db->dbprefix('product_options').".additional_price_wholesale,".$this->db->dbprefix('product_options_group').".name as gname");
        $this->datatables->from('product_options')
                        ->join('product_options_group', 'product_options_group.id=product_options.group_id', 'left');
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('product_options/edit/$1') . "' title='" . lang("edit_product_options") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('product_options/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_product_option') . "')\" title='" . lang("delete_product_options") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

    function add() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('name', lang('product_options_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'type' => $this->input->post('type'),
                'additional_price' => $this->input->post('additional_price') ? $this->input->post('additional_price') : 0,
                'additional_price_wholesale' => $this->input->post('additional_price_wholesale') ? $this->input->post('additional_price_wholesale') : 0,
                'group_id' => $this->input->post('poptions_group'),
            );     
        }

        if ($this->form_validation->run() == true && $this->product_options_model->addProductOptions($data)) {

            $this->session->set_flashdata('message', lang('product_options_added'));
            redirect("product_options");

        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_product_options');
            $this->data['groups'] = $this->site->getAllProductOptionsGroup();
            $bc = array(array('link' => site_url('product_options'), 'page' => lang('product_options')), array('link' => '#', 'page' => lang('add_product_options')));
            $meta = array('page_title' => lang('add_product_options'), 'bc' => $bc);
            $this->page_construct('product_options/add', $this->data, $meta);
        }
    }

    function edit($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('name', lang('product_options_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array(
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'type' => $this->input->post('type'),
                'additional_price' => $this->input->post('additional_price') ? $this->input->post('additional_price') : 0,
                'additional_price_wholesale' => $this->input->post('additional_price_wholesale') ? $this->input->post('additional_price_wholesale') : 0,
                'group_id' => $this->input->post('poptions_group'),
            );       
        }

        if ($this->form_validation->run() == true && $this->product_options_model->updateProductOptions($id, $data)) {

            $this->session->set_flashdata('message', lang('product_options_updated'));
            redirect("product_options");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['product_options'] = $this->site->getProductOptionsByID($id);
            $this->data['groups'] = $this->site->getAllProductOptionsGroup();
            $this->data['page_title'] = lang('new_product_options');
            $bc = array(array('link' => site_url('product_options'), 'page' => lang('product_options')), array('link' => '#', 'page' => lang('edit_product_options')));
            $meta = array('page_title' => lang('edit_product_options'), 'bc' => $bc);
            $this->page_construct('product_options/edit', $this->data, $meta);

        }
    }

    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->product_options_model->deleteProductOptions($id)) {
            $this->session->set_flashdata('message', lang("product_options_deleted"));
            redirect('product_options');
        }
    }
    
    function product_options_group() {

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['product_options_group'] = $this->site->getAllProductOptionsGroup();
        $this->data['page_title'] = lang('product_options_group');
        $bc = array(array('link' => '#', 'page' => lang('product_options_group')));
        $meta = array('page_title' => lang('product_options_group'), 'bc' => $bc);
        $this->page_construct('product_options/product_options_group', $this->data, $meta);

    }

    function get_product_options_group() {

        $this->load->library('datatables');
        $this->datatables->select("id, code, name");
        $this->datatables->from('product_options_group');
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('product_options/edit_product_options_group/$1') . "' title='" . lang("edit_product_options_group") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('product_options/delete_product_options_group/$1') . "' onClick=\"return confirm('" . lang('alert_x_product_options_group') . "')\" title='" . lang("delete_product_options_group") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

    function add_product_options_group() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('name', lang('product_options_group_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
            );     
        }

        if ($this->form_validation->run() == true && $this->product_options_model->addProductOptionsGroup($data)) {

            $this->session->set_flashdata('message', lang('product_options_group_added'));
            redirect("product_options/product_options_group");

        } else {
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_product_options_group');
            $bc = array(array('link' => site_url('product_options_group'), 'page' => lang('product_options_group')), array('link' => '#', 'page' => lang('add_product_options_group')));
            $meta = array('page_title' => lang('add_product_options_group'), 'bc' => $bc);
            $this->page_construct('product_options/add_product_options_group', $this->data, $meta);
        }
    }

    function edit_product_options_group($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('name', lang('product_options_group_name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array(
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
            );       
        }

        if ($this->form_validation->run() == true && $this->product_options_model->updateProductOptionsGroup($id, $data)) {

            $this->session->set_flashdata('message', lang('product_options_group_updated'));
            redirect("product_options/product_options_group");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['product_options_group'] = $this->site->getProductOptionsGroupByID($id);
            $this->data['page_title'] = lang('new_product_options_group');
            $bc = array(array('link' => site_url('product_options_group'), 'page' => lang('product_options_group')), array('link' => '#', 'page' => lang('edit_product_options_group')));
            $meta = array('page_title' => lang('edit_product_options_group'), 'bc' => $bc);
            $this->page_construct('product_options/edit_product_options_group', $this->data, $meta);

        }
    }

    function delete_product_options_group($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->product_options_model->deleteProductOptionsGroup($id)) {
            $this->session->set_flashdata('message', lang("product_options_group_deleted"));
            redirect('product_options/product_options_group');
        }
    }
}
