<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/PayWayApiCheckout.php';

class Pos extends MY_Controller {

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }
        $this->load->helper('pos');
        $this->load->model('pos_model');
        $this->load->library('form_validation');

    }

    function index($sid = NULL, $eid = NULL) {
        if($this->Print){
            redirect('sales');
        } 
        if($this->SalesReport || $this->AllReports){
            redirect('reports');
        }
        if($this->Stock){
            redirect('products');
        }
        if (!$this->Settings->multi_store) {
            $this->session->set_userdata('store_id', 1);
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect($this->Settings->multi_store ? 'stores' : 'welcome');
        }
        if( $this->input->get('hold') ) { $sid = $this->input->get('hold'); }
        if( $this->input->get('edit') ) { $eid = $this->input->get('edit'); }
        if( $this->input->post('eid') ) { $eid = $this->input->post('eid'); }
        if( $this->input->post('did') ) { $did = $this->input->post('did'); } else { $did = NULL; }
        
        if($eid && !($this->Admin || $this->Manager)) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'pos');
        }
        if (!$this->Settings->default_customer) {
            $this->session->set_flashdata('warning', lang('please_update_settings'));
            redirect('settings');
        }
        if (!$this->session->userdata('register_id')) {
            if ($register = $this->pos_model->registerData($this->session->userdata('user_id'))) {
                $register_data = array('register_id' => $register->id, 'cash_in_hand' => $register->cash_in_hand, 'register_open_time' => $register->date);
                $this->session->set_userdata($register_data);
            } else {
                $this->session->set_flashdata('warning', lang('register_not_open'));
                redirect('pos/open_register');
            }
        }

        $suspend = $this->input->post('suspend') ? TRUE : FALSE;

        $this->form_validation->set_rules('customer', lang("customer"), 'trim|required');

        /*
        if ($this->Settings->show_alert_payment) {
            $this->form_validation->set_rules('next_payment', lang("next_payment"), 'required');
            $this->form_validation->set_rules('alert_payment_day', lang("alert_payment_day"), 'required');
        }
        */

        if ($this->form_validation->run() == true) {

            $quantity = "quantity";
            $product = "product";
            $unit_cost = "unit_cost";
            $tax_rate = "tax_rate";

            $date = $this->input->post('date') ? $this->input->post('date') : date('Y-m-d H:i:s');
            $customer_id = $this->input->post('customer_id');
            $customer_details = $this->pos_model->getCustomerByID($customer_id);
            $customer = $customer_details->name;
            $note = $this->tec->clear_tags($this->input->post('spos_note'));

            $total = 0;
            $product_tax = 0;
            $order_tax = 0;
            $product_discount = 0;
            $order_discount = 0;
            $total_cost = 0;
            $percentage = '%';
            $i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
            for ($r = 0; $r < $i; $r++) {
                $item_id = $_POST['product_id'][$r];
                $real_unit_price = $this->tec->formatDecimal($_POST['real_unit_price'][$r]);
                $item_quantity = $_POST['quantity'][$r];
                $item_comment = $_POST['item_comment'][$r];
                $item_discount = isset($_POST['product_discount'][$r]) ? $_POST['product_discount'][$r] : '0';
                $item_length = $_POST['length'][$r];

                if (isset($item_id) && isset($real_unit_price) && isset($item_quantity)) {
                    $product_details = $this->site->getProductByID($item_id);
                    if ($product_details) {
                        $product_name = $product_details->name;
                        $product_code = $product_details->code;
                        $product_cost = $product_details->cost;
                    } else {
                        $product_name = $_POST['product_name'][$r];
                        $product_code = $_POST['product_code'][$r];
                        $product_cost = 0;
                    }
                    if (!$this->Settings->overselling) {
                        if ($product_details->type == 'standard') {
                            if ($product_details->quantity < $item_quantity) {
                                $this->session->set_flashdata('error', lang("quantity_low").' ('.
                                    lang('name').': '.$product_details->name.' | '.
                                    lang('ordered').': '.$item_quantity.' | '.
                                    lang('available').': '.$product_details->quantity.
                                    ')');
                                redirect("pos");
                            }
                        } elseif ($product_details->type == 'combo') {
                            $combo_items = $this->pos_model->getComboItemsByPID($product->id);
                            foreach ($combo_items as $combo_item) {
                                $cpr = $this->site->getProductByID($combo_item->id);
                                if ($cpr->quantity < $item_quantity) {
                                    $this->session->set_flashdata('error', lang("quantity_low").' ('.
                                        lang('name').': '.$cpr->name.' | '.
                                        lang('ordered').': '.$item_quantity.' x '.$combo_item->qty.' = '.$item_quantity*$combo_item->qty.' | '.
                                        lang('available').': '.$cpr->quantity.
                                        ') '.$product_details->name);
                                    redirect("pos");
                                }
                            }
                        }
                    }
                    $unit_price = $real_unit_price;

                    $pr_discount = 0;
                    if (isset($item_discount)) {
                        $discount = $item_discount;
                        $dpos = strpos($discount, $percentage);
                        if ($dpos !== false) {
                            $pds = explode("%", $discount);
                            $pr_discount = $this->tec->formatDecimal(($unit_price * (Float)($pds[0])) / 100);
                        } else {
                            $pr_discount = $this->tec->formatDecimal($discount);
                        }
                    }
                    $itm_length = (float)$item_length > 0 ? (float)$item_length : 1;

                    $unit_price = $this->tec->formatDecimal($unit_price - $pr_discount);
                    $item_net_price = $unit_price;
                    $pr_item_discount = $this->tec->formatDecimal($pr_discount * $item_quantity * $itm_length);
                    $product_discount += $pr_item_discount;

                    $pr_item_tax = 0; $item_tax = 0; $tax = "";
                        if (isset($product_details->tax) && $product_details->tax != 0) {

                            if ($product_details && $product_details->tax_method == 1) {
                                $item_tax = $this->tec->formatDecimal((($unit_price) * $product_details->tax) / 100);
                                $tax = $product_details->tax . "%";
                            } else {
                                $item_tax = $this->tec->formatDecimal(((($unit_price) * $product_details->tax) / (100 + $product_details->tax)));
                                $tax = $product_details->tax . "%";
                                $item_net_price -= $item_tax;
                            }

                            $pr_item_tax = $this->tec->formatDecimal($item_tax * $item_quantity);

                        }
                    
                    $product_tax += $pr_item_tax;
                    $subtotal = $this->tec->formatDecimal(($item_net_price * $item_quantity * $itm_length) + $pr_item_tax);

                    $products[] = array(
                        'product_id' => $item_id,
                        'quantity' => $item_quantity,
                        'unit_price' => $unit_price,
                        'net_unit_price' => $item_net_price,
                        'discount' => $item_discount,
                        'comment' => $item_comment,
                        'item_discount' => $pr_item_discount,
                        'tax' => $tax,
                        'item_tax' => $pr_item_tax,
                        'subtotal' => $subtotal,
                        'real_unit_price' => $real_unit_price,
                        'cost' => $product_cost,
                        'product_code' => $product_code,
                        'product_name' => $product_name,
                        'next_service_date' => $product_details->service_month > 0 ? date('Y-m-d', strtotime("+".$product_details->service_month." months",strtotime($date))) : NULL,
                        'length' => $item_length,   
                    );

                    $total += $this->tec->formatDecimal($item_net_price * $item_quantity * $itm_length);
                    $total_cost += $this->tec->formatDecimal($product_cost * $item_quantity * $itm_length);

                }
            }
            if (empty($products)) {
                $this->form_validation->set_rules('product', lang("order_items"), 'required');
            } else {
                krsort($products);
            }

            if ($this->input->post('order_discount')) {
                $order_discount_id = $this->input->post('order_discount');
                $opos = strpos($order_discount_id, $percentage);
                if ($opos !== false) {
                    $ods = explode("%", $order_discount_id);
                    $order_discount = $this->tec->formatDecimal((($total + $product_tax) * (Float)($ods[0])) / 100);
                } else {
                    $order_discount = $this->tec->formatDecimal($order_discount_id);
                }
            } else {
                $order_discount_id = NULL;
            }
            $total_discount = $this->tec->formatDecimal($order_discount + $product_discount);

            if($this->input->post('order_tax')) {
                $order_tax_id = $this->input->post('order_tax');
                $opos = strpos($order_tax_id, $percentage);
                if ($opos !== false) {
                    $ots = explode("%", $order_tax_id);
                    $order_tax = $this->tec->formatDecimal((($total + $product_tax - $order_discount) * (Float)($ots[0])) / 100);
                } else {
                    $order_tax = $this->tec->formatDecimal($order_tax_id);
                }

            } else {
                $order_tax_id = NULL;
                $order_tax = 0;
            }

            $total_tax = $this->tec->formatDecimal($product_tax + $order_tax);
            $grand_total = $this->tec->formatDecimal($total + $total_tax - $order_discount);
            $paid = $this->input->post('amount') ? $this->input->post('amount') : 0;
            $round_total = $this->tec->roundNumber($grand_total, $this->Settings->rounding);
            $rounding = $this->tec->formatDecimal(($round_total - $grand_total));
            if ($customer_details->id == 1 && $this->tec->formatDecimal($paid) < $this->tec->formatDecimal($round_total)) {
                $this->session->set_flashdata('error', lang('select_customer_for_due'));
                redirect($_SERVER["HTTP_REFERER"]);
            }
            if (!$eid) {
                $status = 'due';
                if ($this->tec->formatDecimal($round_total) <= $this->tec->formatDecimal($paid)) {
                    $status = 'paid';
                } elseif ($this->tec->formatDecimal($round_total) > $this->tec->formatDecimal($paid) && $paid > 0) {
                    $status = 'partial';
                }
            }

            $cus_group = $this->site->getCustomerGroupByID($this->input->post('sale_customer_group'));

            $data = array('date' => $date,
                'customer_id' => $customer_id,
                'customer_name' => $customer,
                'total' => $this->tec->formatDecimal($total),
                'product_discount' => $this->tec->formatDecimal($product_discount),
                'order_discount_id' => $order_discount_id,
                'order_discount' => $order_discount,
                'total_discount' => $total_discount,
                'product_tax' => $this->tec->formatDecimal($product_tax),
                'order_tax_id' => $order_tax_id,
                'order_tax' => $order_tax,
                'total_tax' => $total_tax,
                'grand_total' => $grand_total,
                'total_items' => $this->input->post('total_items'),
                'total_quantity' => $this->input->post('total_quantity'),
                'rounding' => $rounding,
                'paid' => $paid,
                'status' => $status,
                'created_by' => $this->input->post('created_by') ? $this->input->post('created_by') : $this->session->userdata('user_id'),
                'note' => $note,
                'hold_ref' => $this->input->post('hold_ref'),
                'total_cost' => $total_cost,
                'next_payment' => $this->input->post('next_payment'),
                'alert_payment_day' => $this->input->post('alert_payment_day'),
                'sale_customer_group' => $this->input->post('sale_customer_group'),
                'customer_group_name' => $cus_group->name,
                'inv_number' => $this->input->post('inv_number'),
                );

            if (!$eid) {
                $data['store_id'] = $this->session->userdata('store_id');
            }

            if (!$eid && !$suspend && $paid) {
                if ($this->input->post('paying_gift_card_no')) {
                    $gc = $this->pos_model->getGiftCardByNO($this->input->post('paying_gift_card_no'));
                    if (!$gc || $gc->balance < $amount) {
                        $this->session->set_flashdata('error', lang("incorrect_gift_card"));
                        redirect("pos");
                    }
                }
                $amount = $this->tec->formatDecimal($paid > $grand_total ? ($paid - $this->input->post('balance_amount')) : $paid);
                $payment = array(
                    'date' => $date,
                    'amount' => $amount,
                    'customer_id' => $customer_id,
                    'paid_by' => $this->input->post('paid_by'),
                    'cheque_no' => $this->input->post('cheque_no'),
                    'cc_no' => $this->input->post('cc_no'),
                    'gc_no' => $this->input->post('paying_gift_card_no'),
                    'cc_holder' => $this->input->post('cc_holder'),
                    'cc_month' => $this->input->post('cc_month'),
                    'cc_year' => $this->input->post('cc_year'),
                    'cc_type' => $this->input->post('cc_type'),
                    'cc_cvv2' => $this->input->post('cc_cvv2'),
                    'created_by' => $this->input->post('created_by') ? $this->input->post('created_by') : $this->session->userdata('user_id'),
                    'store_id' => $this->session->userdata('store_id'),
                    'note' => $this->input->post('payment_note'),
                    'pos_paid' => $this->tec->formatDecimal($this->input->post('amount'), 4),
                    'pos_paid_main' => $this->tec->formatDecimal($this->input->post('amount_main'), 4),
                    'pos_paid_exc' => $this->tec->formatDecimal($this->input->post('amount_exc'), 4),
                    'pos_paid_exc2' => $this->tec->formatDecimal($this->input->post('amount_exc2'), 4),
                    'pos_balance' => $this->tec->formatDecimal($this->input->post('balance_amount'), 4),
                    'next_payment' => $this->input->post('next_payment'),
                    'alert_payment_day' => $this->input->post('alert_payment_day'),
                    );
                $data['paid'] = $amount;

            } else {
                $payment = array();
            }

            // $this->tec->print_arrays($data, $products, $payment);
        }

        if ($this->form_validation->run() == true && !empty($products))
        {
            if ($suspend) {
                unset($data['status'], $data['rounding'], $data['next_payment'], $data['alert_payment_day'], $data['sale_customer_group'], $data['customer_group_name'], $data['inv_number']);
                if ($this->pos_model->suspendSale($data, $products, $did)) {
                    $this->session->set_userdata('rmspos', 1);
                    $this->session->set_flashdata('message', lang("sale_saved_to_opened_bill"));
                    redirect("pos");
                } else {
                    $this->session->set_flashdata('error', lang("action_failed"));
                    redirect("pos/".$did);
                }

            } elseif($eid) {

                unset($data['status'], $data['paid']);
                if (! ($this->Admin || $this->Manager)) {
                    unset($data['date']);
                    unset($data['created_by']);
                }                
                unset($data['note']);
                $data['updated_at'] = date('Y-m-d H:i:s');
                $data['updated_by'] = $this->session->userdata('user_id');
                if($this->pos_model->updateSale($eid, $data, $products)) {
                    //Notification to Telegram
                    if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
                        //Invoice
                        $this->telegram_edit_sale($eid);                        
                    }
                    $this->session->set_userdata('rmspos', 1);
                    $this->session->set_flashdata('message', lang("sale_updated"));
                    redirect("sales");
                }
                else {
                    $this->session->set_flashdata('error', lang("action_failed"));
                    redirect("pos/?edit=".$eid);
                }

            } else {
                $data['date_out'] = date('Y-m-d H:i:s');
                if($sale = $this->pos_model->addSale($data, $products, $payment, $did)) {
                    $this->session->set_userdata('rmspos', 1);
                    $msg = lang("sale_added");
                    if (!empty($sale['message'])) {
                        foreach ($sale['message'] as $m) {
                            $msg .= '<br>' . $m;
                        }
                    }
                    $this->session->set_flashdata('message', $msg);
                    $redirect_to = $this->Settings->after_sale_page ? "pos" : "pos/view/" . $sale['sale_id'] . '/' . $this->Settings->receipt_format;
                    if ($this->Settings->auto_print) {
                        if ( ! $this->Settings->remote_printing) {
                            $this->print_receipt($sale['sale_id'], true);
                        } elseif ($this->Settings->remote_printing == 2) {
                            $redirect_to .= '?print='.$sale['sale_id'];
                        } elseif ($this->Settings->remote_printing == 3) {
                            $this->pdf_receipt($sale['sale_id'],0);
                        }
                    }
                    //Notification to Telegram
                    if ($this->Settings->telegram_notification == 1 || $this->Settings->telegram_notification == 3) {
                        //Invoice
                        $this->telegram_receipt($sale['sale_id']);
                        //Alert Quantity
                        foreach ($products as $product) {
                            $item = $this->site->getProductByID($product['product_id']);
                            if(($item->alert_quantity >0) && ($item->quantity <= $item->alert_quantity)) {
                                $text = lang('alert_quantity') . " \n";
                                $text = $text . lang('code') . ' : ' . $item->code . " \n";
                                $text = $text . lang('name') . ' : ' . $item->name . " \n";
                                $text = $text . lang('quantity') . ' : ' . $this->tec->formatQuantity($item->quantity) . " \n";
                                //$text = $text . lang('alert_quantity') . ' : ' . $this->tec->formatQuantity($item->alert_quantity) . " \n";
                                $this->telegram_lib->sendmsg($text);
                            }
                            if($item->alert_expiry > 0 && (date_diff(NOW(),$item->expiry_date) <= $item->alert_expiry)) {
                                $text = lang('alert_expiry') . " \n";
                                $text = $text . lang('code') . ' : ' . $item->code . " \n";
                                $text = $text . lang('name') . ' : ' . $item->name . " \n";
                                $text = $text . lang('expiry_date') . ' : ' . $item->expiry_date . " \n";
                                //$text = $text . lang('alert_quantity') . ' : ' . $this->tec->formatQuantity($item->alert_quantity) . " \n";
                                $this->telegram_lib->sendmsg($text);
                            }
                        }
                    }
                    //Calculate Award Point
                    $this->site->update_award_points($data['grand_total'], $data['customer_id'], $data['created_by']);                    

                    redirect($redirect_to);
                }
                else {
                    $this->session->set_flashdata('error', lang("action_failed"));
                    redirect("pos");
                }

            }
        }
        else
        {

            if(isset($sid) && !empty($sid)) {
                $suspended_sale = $this->pos_model->getSuspendedSaleByID($sid);
                $inv_items = $this->pos_model->getSuspendedSaleItems($sid);
                krsort($inv_items);
                $c = rand(100000, 9999999);
                foreach ($inv_items as $item) {
                    $row = $this->site->getProductByID($item->product_id);
                    if (!$row) {
                        $row = json_decode('{}');
                        $row->id = 0;
                        $row->code = $item->product_code;
                        $row->name = $item->product_name;
                        $row->tax = 0;
                    }
                    $row->price = $item->net_unit_price+($item->item_discount/$item->quantity);
                    $row->unit_price = $item->unit_price+($item->item_discount/$item->quantity)+($item->item_tax/$item->quantity);
                    $row->real_unit_price = $item->real_unit_price;
                    $row->real_unit_price_wholesale = $row->store_price_wholesale;
                    $row->real_unit_price_vip = $row->store_price_vip;
                    $row->discount = $item->discount;
                    $row->qty = $item->quantity;
                    $row->comment = $item->comment;
                    $row->ordered = $item->quantity;
                    $row->length = $item->length;
                    $combo_items = FALSE;
                    $unit = $this->site->getUnitByID($row->unit_id);
                    $ri = $this->Settings->item_addition ? $row->id : $c;
                    $pr[$ri] = array('id' => $c, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items, 'product_unit' => $unit->name);
                    $c++;
                }
                $this->data['items'] = json_encode($pr);
                $this->data['sid'] = $sid;
                $this->data['suspend_sale'] = $suspended_sale;
                $this->data['message'] = lang('suspended_sale_loaded');
            }

            if(isset($eid) && !empty($eid)) {
                $sale = $this->pos_model->getSaleByID($eid);
                $inv_items = $this->pos_model->getAllSaleItems($eid);
                krsort($inv_items);
                $c = rand(100000, 9999999);
                foreach ($inv_items as $item) {
                    $row = $this->site->getProductByID($item->product_id);
                    if (!$row) {
                        $row = json_decode('{}');
                    }
                    $row->price = $item->net_unit_price;
                    $row->unit_price = $item->unit_price;
                    $row->real_unit_price = $item->real_unit_price;
                    $row->real_unit_price_wholesale = $row->store_price_wholesale;
                    $row->real_unit_price_vip = $row->store_price_vip;
                    $row->discount = $item->discount;
                    $row->qty = $item->quantity;
                    $row->length = $item->length;
                    $row->comment = $item->comment;
                    $combo_items = FALSE;
                    $row->quantity += $item->quantity;
                    if ($row->type == 'combo') {
                        $combo_items = $this->pos_model->getComboItemsByPID($row->id);
                        foreach ($combo_items as $combo_item) {
                            $combo_item->quantity += ($combo_item->qty*$item->quantity);
                        }
                    }
                    $ri = $this->Settings->item_addition ? $row->id : $c;
                    $pr[$ri] = array('id' => $c, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items);
                    $c++;
                }
                $this->data['items'] = json_encode($pr);
                $this->data['eid'] = $eid;
                $this->data['sale'] = $sale;
                $this->data['message'] = lang('sale_loaded');
            }
            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
            $this->data['reference_note'] = isset($sid) && !empty($sid) ? $suspended_sale->hold_ref : (isset($eid) && !empty($eid) ? $sale->hold_ref : NULL);
            $this->data['sid'] = isset($sid) && !empty($sid) ? $sid : 0;
            $this->data['eid'] = isset($eid) && !empty($eid) ? $eid : 0;
            $this->data['users'] = $this->site->getAllStaff();
            $this->data['customers'] = $this->site->getAllCustomers(1);
            $this->data['customer_group'] = $this->site->getAllCustomerGroup();
            $this->data['pro_opt1'] = $this->site->getProductOptionsByType('pro_opt1');
            $this->data['pro_opt2'] = $this->site->getProductOptionsByType('pro_opt2');
            $this->data['pro_opt3'] = $this->site->getProductOptionsByType('pro_opt3');
            $this->data['pro_opt4'] = $this->site->getProductOptionsByType('pro_opt4');
            $this->data["tcp"] = $this->pos_model->products_count($this->Settings->default_category);
            $this->data['groups'] = $this->site->getAllProductOptionsGroup();
            if (($this->Settings->multi_store) && ($this->Settings->multistore_product)){
                $this->data['products'] = $this->ajaxproducts($this->site->getDefaultCategoryByStoreID($this->session->userdata('store_id')), 1);
                $this->data['categories'] = $this->site->getCategoryByStoreID($this->session->userdata('store_id'));
            }else{
                $this->data['products'] = $this->ajaxproducts($this->Settings->default_category, 1);
                $this->data['categories'] = $this->site->getAllCategoriesNoIngredient(); 
            } 
            $this->data['message'] = $this->session->flashdata('message');
            $this->data['suspended_sales'] = $this->site->getUserSuspenedSales();

            $this->data['printer'] = $this->site->getPrinterByID($this->Settings->printer);
            $printers = array();
            if (!empty($order_printers = json_decode($this->Settings->order_printers))) {
                foreach ($order_printers as $printer_id) {
                    $printers[] = $this->site->getPrinterByID($printer_id);
                }
            }
            $store = $this->site->getStoreByID($this->session->userdata('store_id'));
            $this->data['order_printers'] = $printers;

            if ($saleid = $this->input->get('print', true)) {
                if ($inv = $this->pos_model->getSaleByID($saleid)) {
                    if ($this->session->userdata('store_id') != $inv->store_id) {
                        $this->session->set_flashdata('error', lang('access_denied'));
                        redirect('pos');
                    }
                    $store = $this->site->getStoreByID($inv->store_id);
                    $this->tec->view_rights($inv->created_by, false, 'pos');
                    $this->load->helper('text');
                    $this->data['rows'] = $this->pos_model->getAllSaleItems($saleid);
                    $this->data['customer'] = $this->pos_model->getCustomerByID($inv->customer_id);
                    $this->data['store'] = $this->site->getStoreByID($inv->store_id);
                    $this->data['inv'] = $inv;
                    $this->data['print'] = $saleid;
                    $this->data['payments'] = $this->pos_model->getAllSalePayments($saleid);
                    $this->data['created_by'] = $this->site->getUser($inv->created_by);
                }
            }
            
            $this->data['aba_qrstring'] = $this->tec->qrcode('text', $store->aba_qrstring , 2);
            $this->data['acleda_qrstring'] = $this->tec->qrcode('text', $store->acleda_qrstring , 2);
            $this->data['page_title'] = lang('pos');
            $bc = array(array('link' => '#', 'page' => lang('pos')));
            $meta = array('page_title' => lang('pos'), 'bc' => $bc);
            $this->load->view($this->theme.'pos/index', $this->data, $meta);

        }
    }


    function get_product($code = NULL) {

        if ($this->input->get('code')) { $code = $this->input->get('code'); }
        $combo_items = FALSE;
        if($product = $this->pos_model->getProductByCode($code)) {
            unset($product->cost, $product->details);
            $product->qty = 1;
            $product->comment = '';
            $product->discount = $this->pos_model->getCategoryDiscount($product->category_id);
            $product->price = $product->store_price > 0 ? $product->store_price : $product->price;
            if ($this->tec->isPromo($product)) {$product->price = $product->promo_price;}
            $product->price_wholesale = $product->store_price_wholesale > 0 ? $product->store_price_wholesale : $product->price_wholeslae;
            $product->price_vip = $product->store_price_vip > 0 ? $product->store_price_vip : $product->price_vip;
            $product->real_unit_price = $product->price;
            $product->real_unit_price_wholesale = $product->price_wholesale;
            $product->real_unit_price_vip = $product->price_vip;
            $product->unit_price = $product->tax ? ($product->price+(($product->price*$product->tax)/100)) : $product->price;
            $product->unit_price_wholesale = $product->tax ? ($product->price_wholesale+(($product->price_wholesale*$product->tax)/100)) : $product->price_wholesale;
            $product->unit_price_vip = $product->tax ? ($product->price_vip+(($product->price_vip*$product->tax)/100)) : $product->price_vip;
            $unit = $this->site->getUnitByID($product->unit_id);
            if ($product->type == 'combo') {
                $combo_items = $this->pos_model->getComboItemsByPID($product->id);
            }
            echo json_encode(array('id' => str_replace(".", "", microtime(true)), 'item_id' => $product->id, 'label' => $product->name . " (" . $product->code . ")", 'row' => $product, 'combo_items' => $combo_items, 'product_unit' => $unit->name));
        } else {
            echo NULL;
        }

    }

    function suggestions() {
        $myterm = $this->input->get('term', TRUE);
        $analyzed  = $this->tec->analyze_term($myterm);
        $term        = $analyzed['term'];
        $qty       = $analyzed['quantity'] ?? null;
        $bprice    = $analyzed['price']    ?? null;

        if(($this->Settings->multi_store) && ($this->Settings->multistore_product)){
            $rows = $this->pos_model->getProductNamesByStore($term, $type);
        }else{
            $rows = $this->pos_model->getProductNames($term, $type); 
        }
        if ($rows) {
            foreach ($rows as $row) {
                unset($row->cost, $row->details);
                $row->qty = 1;
                $row->comment = '';
                $row->discount = $this->pos_model->getCategoryDiscount($row->category_id);
                $row->price = $row->store_price > 0 ? $row->store_price : $row->price;
                if ($this->tec->isPromo($row)) {$row->price = $row->promo_price;}
                $row->price_wholesale = $row->store_price_wholesale > 0 ? $row->store_price_wholesale : $row->price_wholesale;
                $row->price_vip = $row->store_price_vip > 0 ? $row->store_price_vip : $row->price_vip;
                $row->real_unit_price = $row->price;
                $row->real_unit_price_wholesale = $row->price_wholesale;
                $row->real_unit_price_vip = $row->price_vip;
                $row->unit_price = $row->tax ? ($row->price+(($row->price*$row->tax)/100)) : $row->price;
                $row->unit_price_wholesale = $row->tax ? ($row->price_wholesale+(($row->price_wholesale*$row->tax)/100)) : $row->price_wholesale;
                $row->unit_price_vip = $row->tax ? ($row->price_vip+(($row->price_vip*$row->tax)/100)) : $row->price_vip;
                $unit = $this->site->getUnitByID($row->unit_id);
                $combo_items = FALSE;
                if ($row->type == 'combo') {
                    $combo_items = $this->pos_model->getComboItemsByPID($row->id);
                }
                $row->qty = $qty ? $qty : ($bprice ? $bprice / $row->price : 1);
                $pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items, 'product_unit' => $unit->name);
            }
            echo json_encode($pr);
        } else {
            echo json_encode(array(array('id' => 0, 'label' => lang('no_match_found'), 'value' => $term)));
        }
    }


    function registers() {

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['registers'] = $this->pos_model->getOpenRegisters();
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => site_url('pos'), 'page' => lang('pos')), array('link' => '#', 'page' => lang('open_registers')));
        $meta = array('page_title' => lang('open_registers'), 'bc' => $bc);
        $this->page_construct('pos/registers', $this->data, $meta);
    }

    function open_register() {
        if($this->Print){
            redirect('sales');
        } 
        if($this->SalesReport || $this->AllReports){
            redirect('reports');
        }
        if($this->Stock){
            redirect('products');
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        $this->form_validation->set_rules('cash_in_hand', lang("cash_in_hand"), 'trim|required|numeric');

        if ($this->form_validation->run() == true) {
            $data = array('date' => date('Y-m-d H:i:s'),
                'cash_in_hand' => $this->input->post('cash_in_hand'),
                'user_id' => $this->session->userdata('user_id'),
                'store_id' => $this->session->userdata('store_id'),
                'status' => 'open',
                );
        }
        if ($this->form_validation->run() == true && $this->pos_model->openRegister($data)) {
            //Send Telegram notification
            if ($this->Settings->telegram_notification == 2 || $this->Settings->telegram_notification == 3) {
                $store = $this->site->getStoreByID($this->session->userdata('store_id'));  
                $text = lang('open_register') . ": \n";
                $text = $text . lang('store') . ": " . $store->name . " \n";
                $text = $text . lang('open_time').': ' . date('Y-m-d H:i:s') . " \n";
                $text = $text . lang("name").': '. $this->session->userdata('first_name').' '.$this->session->userdata('last_name') . " \n";
                $text = $text . lang("cash_in_hand").': '. $this->tec->formatMoney($this->input->post('cash_in_hand')) . " \n";
                $this->telegram_lib->sendmsg($text);
            }
            $this->session->set_flashdata('message', lang("welcome_to_pos"));
            redirect("pos");
        } else {

            $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

            $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('open_register')));
            $meta = array('page_title' => lang('open_register'), 'bc' => $bc);
            $this->page_construct('pos/open_register', $this->data, $meta);
        }
    }

    function close_register($user_id = NULL) {
        if (! ($this->Admin || $this->Manager)) {
            $user_id = $this->session->userdata('user_id');
        }
        $this->form_validation->set_rules('total_cash', lang("total_cash"), 'trim|required|numeric');
        $this->form_validation->set_rules('total_cheques', lang("total_cheques"), 'trim|required|numeric');
        $this->form_validation->set_rules('total_cc_slips', lang("total_cc_slips"), 'trim|required|numeric');

        if ($this->form_validation->run() == true) {
            if ($this->Admin || $this->Manager) {
                $user_register = $user_id ? $this->pos_model->registerData($user_id) : NULL;
                $rid = $user_register ? $user_register->id : $this->session->userdata('register_id');
                $user_id = $user_register ? $user_register->user_id : $this->session->userdata('user_id');
                $register_open_time = $user_register ? $user_register->date : $this->session->userdata('register_open_time');
                $cash_in_hand = $user_register ? $user_register->cash_in_hand : $this->session->userdata('cash_in_hand');
                $ccsales = $this->pos_model->getRegisterCCSales($register_open_time, $user_id); // as ACLEDA
                $cashsales = $this->pos_model->getRegisterCashSales($register_open_time, $user_id);
                $expenses = $this->pos_model->getRegisterExpenses($register_open_time, $user_id);
                $chsales = $this->pos_model->getRegisterChSales($register_open_time, $user_id); // as ABA
                $total_cash = ($cashsales->paid ? ($cashsales->paid + $cash_in_hand) : $cash_in_hand);
                $total_cash -= ($expenses->total ? $expenses->total : 0);
            } else {
                $rid = $this->session->userdata('register_id');
                $user_id = $this->session->userdata('user_id');
                $register_open_time = $this->session->userdata('register_open_time');
                $cash_in_hand = $this->session->userdata('cash_in_hand');
                $ccsales = $this->pos_model->getRegisterCCSales($register_open_time); // as ACLEDA
                $cashsales = $this->pos_model->getRegisterCashSales($register_open_time);
                $expenses = $this->pos_model->getRegisterExpenses($register_open_time);
                $chsales = $this->pos_model->getRegisterChSales($register_open_time); // as ABA
                $total_cash = ($cashsales->paid ? ($cashsales->paid + $cash_in_hand) : $cash_in_hand);
                $total_cash -= ($expenses->total ? $expenses->total : 0);
            }

            $gcsales = $this->pos_model->getRegisterGCSales($register_open_time, $user_id);
            $other_sales = $this->pos_model->getRegisterOtherSales($register_open_time, $user_id);
            $totalsales = $this->pos_model->getRegisterSales($register_open_time, $user_id);

            $data = array('closed_at' => date('Y-m-d H:i:s'),
                'total_cash' => $total_cash,
                'total_cheques' => $chsales->total_cheques,
                'total_cc_slips' => $ccsales->total_cc_slips,
                'total_cash_submitted' => $this->input->post('total_cash_submitted'),
                'total_cheques_submitted' => $this->input->post('total_cheques_submitted'),
                'total_cc_slips_submitted' => $this->input->post('total_cc_slips_submitted'),
                'note' => $this->input->post('note'),
                'status' => 'close',
                'transfer_opened_bills' => $this->input->post('transfer_opened_bills'),
                'closed_by' => $this->session->userdata('user_id'),
                'cash_sales' => $cashsales->paid ? $cashsales->paid : 0,
                'ch_sales' => $chsales->paid ? $chsales->paid : 0,
                'cc_sales' => $ccsales->paid ? $ccsales->paid : 0,
                'gc_sales' => $gcsales->paid ? $gcsales->paid : 0,
                'other_sales' => $other_sales->paid ? $other_sales->paid : 0,
                'total_sales' => $totalsales->paid ? $totalsales->paid : 0,
                'nbr_sales' => $totalsales->nbr_sales ? $totalsales->nbr_sales : 0,
                'total_cash_1' => $this->input->post('total_cash_1'),
                'total_cash_2' => $this->input->post('total_cash_2'),
                'total_cash_3' => $this->input->post('total_cash_3'),
                );
                $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
				$this->data['ccsales'] = $this->pos_model->getRegisterCCSales($register_open_time, $user_id); // as ACLEDA
				$this->data['cashsales'] = $this->pos_model->getRegisterCashSales($register_open_time, $user_id);
				$this->data['chsales'] = $this->pos_model->getRegisterChSales($register_open_time, $user_id); // as ABA
				$this->data['other_sales'] = $this->pos_model->getRegisterOtherSales($register_open_time, $user_id);
				$this->data['gcsales'] = $this->pos_model->getRegisterGCSales($register_open_time, $user_id); // as WING
				$this->data['stripesales'] = $this->pos_model->getRegisterStripeSales($register_open_time, $user_id);
				$this->data['totalsales'] = $this->pos_model->getRegisterSales($register_open_time, $user_id);
				$this->data['expenses'] = $this->pos_model->getRegisterExpenses($register_open_time);
				$this->data['users'] = $this->tec->getUsers($user_id);
				$this->data['suspended_bills'] = $this->pos_model->getSuspendedsales($user_id);
				$this->data['user_id'] = $user_id;
				$this->data['sale_items'] = $this->pos_model->getRegisterSaleItems($register_open_time, $user_id);      
                $this->data['register_open_time'] = $register_open_time;
                $this->data['sales_discount_tax'] = $this->pos_model->getRegisterSalesDiscountTax($register_open_time, $user_id); 
                $sale_invoices = $this->pos_model->getRegisterSaleInvoices($register_open_time, $user_id);      
                $inv_numbers = '';
                foreach ($sale_invoices as $invoice) {
                    $inv_numbers = $inv_numbers . $invoice->inv_number . ', ';
                }  
                $this->data['inv_numbers'] = $inv_numbers;                    
            // $this->tec->print_arrays($data);

        } elseif ($this->input->post('close_register')) {
            $this->session->set_flashdata('error', (validation_errors() ? validation_errors() : $this->session->flashdata('error')));
            redirect("pos");
        }

        if ($this->form_validation->run() == true && $this->pos_model->closeRegister($rid, $user_id, $data)) {
            $this->session->unset_userdata('register_id');
            $this->session->unset_userdata('cash_in_hand');
            $this->session->unset_userdata('register_open_time');
            $this->session->set_flashdata('message', lang("register_closed"));

            //Send Telegram notification
            if ($this->Settings->telegram_notification == 2 || $this->Settings->telegram_notification == 3) {
                $items = $this->pos_model->getRegisterSaleItems($register_open_time, $user_id);               
                $store = $this->site->getStoreByID($this->session->userdata('store_id'));     
                $text = lang('register_closed') . ": \n";
                $text = $text . lang('store') . ": " . $store->name . " \n";
                $text = $text . lang('open_time').': ' . $register_open_time . " \n";
                $text = $text . lang('close_time').': ' . date('Y-m-d H:i:s') . " \n";
                $text = $text . lang("name").': '. $this->session->userdata('first_name').' '.$this->session->userdata('last_name') . " \n";              
                $text = $text . lang('cash_sale') . ": " . $this->tec->formatMoney($cashsales->paid ? $cashsales->paid : '0.00') . " \n";
                $text = $text . lang('ABA') . ": " . $this->tec->formatMoney($chsales->paid ? $chsales->paid : '0.00') . " \n";
                $text = $text . lang('ACLEDA') . ": " . $this->tec->formatMoney($ccsales->paid ? $ccsales->paid : '0.00') . " \n";
                $text = $text . lang('WING') . ": " . $this->tec->formatMoney($gcsales->paid ? $gcsales->paid : '0.00') . " \n";
                $text = $text . lang('other_sale') . ": " . $this->tec->formatMoney($other_sales->paid ? $other_sales->paid : '0.00') . " \n";
                $text = $text . lang("cash_in_hand").': '. $this->tec->formatMoney($cash_in_hand) . " \n";
                $text = $text . lang('total_sales') . ": " . $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . " \n";
                $text = $text . lang('expense') . ": " . $this->tec->formatMoney($expenses->total ? $expenses->total : '0.00') . " \n";                
                $text = $text . lang('grand_total') . ": " .  $this->tec->formatMoney(($cash_in_hand + $totalsales->paid) -$expenses->total ? ($cash_in_hand + $totalsales->paid) -$expenses->total : '0.00') . " \n";
                $text = $text . lang('item_des') . " \n";
                $no = 0;
                foreach ($items as $item) {
                    $no = $no + 1;
                    $text = $text . $no . ' - ' . $item->product_name . ' : ' . $this->tec->formatMoney($item->unit_price) . ' x ' .  $this->tec->formatQuantity($item->sold) . ' = ' .  $this->tec->formatMoney($item->mysubtotal) . " \n";
                }
                $this->telegram_lib->sendmsg($text);
            }

            /*Email when close Register
            $receipt = $this->load->view($this->theme . 'pos/close_email', $this->data, TRUE);
			$message = preg_replace('#\<!-- start -->(.+)\<!-- end -->#Usi', '', $receipt);
			$subject = lang('email_subject').' - '.$this->Settings->site_name;
			try {
				if ($this->tec->send_email($this->Settings->default_email, $subject, $message)) {
					echo json_encode(array('msg' => lang("email_success")));
				} else {
					echo json_encode(array('msg' => lang("email_failed")));
				}
			} catch (Exception $e) {
				echo json_encode(array('msg' => $e->getMessage()));
            }
            
            
            if ($this->Settings->auto_print) {
                if ( ! $this->Settings->remote_printing) {
                 
                } elseif ($this->Settings->remote_printing == 2) {
                    
                } elseif ($this->Settings->remote_printing == 3) {
                    //Saved PDF close register
                    $savepath = FCPATH .'/uploads/pdf/payment/' . $this->session->userdata('terminal_id') . "/PAY_".time().".pdf";        
                    $html = $this->load->view($this->theme . 'pos/close_pdf', $this->data, true);
                    $width = 80;
                    $height = 3276;                
                    $this->tec->Html2Pdf($html,NULL,$savepath,[$width, $height]); 
                }
            }    

            */

            redirect("welcome");
        } else {
            if ($this->Admin || $this->Manager) {
                $user_register = $user_id ? $this->pos_model->registerData($user_id) : NULL;
                $register_open_time = $user_register ? $user_register->date : $this->session->userdata('register_open_time');
                $this->data['cash_in_hand'] = $user_register ? $user_register->cash_in_hand : NULL;
                $this->data['register_open_time'] = $user_register ? $register_open_time : NULL;
            } else {
                $register_open_time = $this->session->userdata('register_open_time');
                $this->data['cash_in_hand'] = NULL;
                $this->data['register_open_time'] = NULL;
            }
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['ccsales'] = $this->pos_model->getRegisterCCSales($register_open_time, $user_id);
            $this->data['cashsales'] = $this->pos_model->getRegisterCashSales($register_open_time, $user_id);
            $this->data['chsales'] = $this->pos_model->getRegisterChSales($register_open_time, $user_id);
            $this->data['other_sales'] = $this->pos_model->getRegisterOtherSales($register_open_time, $user_id);
            $this->data['gcsales'] = $this->pos_model->getRegisterGCSales($register_open_time, $user_id);
            $this->data['stripesales'] = $this->pos_model->getRegisterStripeSales($register_open_time, $user_id);
            $this->data['totalsales'] = $this->pos_model->getRegisterSales($register_open_time, $user_id);
            $this->data['expenses'] = $this->pos_model->getRegisterExpenses($register_open_time);
            $this->data['users'] = $this->tec->getUsers($user_id);
            $this->data['suspended_bills'] = $this->pos_model->getSuspendedsales($user_id);
            $this->data['user_id'] = $user_id;
            $this->data['sale_items'] = $this->pos_model->getRegisterSaleItems($register_open_time, $user_id);
            $this->data['sales_discount_tax'] = $this->pos_model->getRegisterSalesDiscountTax($register_open_time, $user_id);  
            $sale_invoices = $this->pos_model->getRegisterSaleInvoices($register_open_time, $user_id);      
            $inv_numbers = '';
            foreach ($sale_invoices as $invoice) {
                $inv_numbers = $inv_numbers . $invoice->inv_number . ', ';
            }  
            $this->data['inv_numbers'] = $inv_numbers;           
            $this->load->view($this->theme . 'pos/close_register', $this->data);
        }
    }

    function ajaxproducts( $category_id = NULL, $return = NULL, $type = 'all') {

        if($this->input->get('category_id')) { $category_id = $this->input->get('category_id'); } elseif(!$category_id) { $category_id = $this->Settings->default_category; }
        if($this->input->get('per_page') == 'n' ) { $page = 0; } else { $page = $this->input->get('per_page'); }
        if($this->input->get('type')) { $type = $this->input->get('type'); }
        if($this->input->get('tcp') == 1 ) { $tcp = TRUE; } else { $tcp = FALSE; }

        if($this->Settings->overselling) {
            $products = $this->pos_model->fetch_products($category_id, $this->Settings->pro_limit, $page, $type);
        } else {
            $products = $this->pos_model->fetch_products_notoversell($category_id, $this->Settings->pro_limit, $page, $type);
        }        
        $pro = 1;
        $prods = "<div id='show-products-display'><div id='bydefault-products'>";
        if($products) {
            if($this->Settings->bsty == 1) {
                foreach($products as $product) {
                    $count = $product->id;
                    if($count < 10) { $count = "0".($count /100) *100;  }
                    if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
                    $prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-name btn-default btn-flat product\">".$product->name."</button>";
                    $pro++;
                }
            } elseif($this->Settings->bsty == 2) {
                foreach($products as $product) {
                    $count = $product->id;
                    if($count < 10) { $count = "0".($count /100) *100;  }
                    if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
                    $prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-img btn-flat product\"><img src=\"".base_url()."uploads/thumbs/".$product->image."\" alt=\"".$product->name."\" style=\"width: 110px; height: 110px;\"></button>";
                    $pro++;
                }
            } elseif($this->Settings->bsty == 3) {
                foreach($products as $product) {
                    $count = $product->id;
                    if($count < 10) { $count = "0".($count /100) *100;  }
                    if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
                    $prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-both btn-flat product\"><span class=\"bg-img\"><img src=\"".base_url()."uploads/thumbs/".$product->image."\" alt=\"".$product->name."\" style=\"width: 100px; height: 100px;\"></span><span><span>".$product->name."</span></span></button>";
                    $pro++;
                }
            }  elseif($this->Settings->bsty == 4) {
                foreach($products as $product) {
                    $count = $product->id;
                    if($count < 10) { $count = "0".($count /100) *100;  }
                    if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
                    $prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-both btn-flat product\"><span class=\"bg-img\"><img src=\"".base_url()."uploads/thumbs/".$product->image."\" alt=\"".$product->name."\" style=\"width: 100px; height: 100px;\"></span><span><span>".$product->name."<div style='color:red; display:block; min-height:20px !important;'>" .$this->tec->formatMoney($product->price)."</div></span></span></button>";
                    $pro++;
                }
            }
        } else {
            $prods .= '<h4 class="text-center text-info" style="margin-top:50px;">'.lang('category_is_empty').'</h4>';
        }

        $prods .= "</div><div id='searched-products'></div></div>";

        if(!$return) {
            if(!$tcp) {
                echo $prods;
            } else {
                $category_products = $this->pos_model->products_count($category_id);
                header('Content-Type: application/json');
                echo json_encode(array('products' => $prods, 'tcp' => $category_products));
            }
        } else {
            return $prods;
        }

    }

    function view($sale_id = NULL, $receipt_format = 0, $noprint = NULL) {
        if($this->input->get('id')){ $sale_id = $this->input->get('id'); }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['message'] = $this->session->flashdata('message');
        $inv = $this->pos_model->getSaleByID($sale_id);
        $customer = $this->pos_model->getCustomerByID($inv->customer_id);
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        } elseif ($this->session->userdata('store_id') != $inv->store_id) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('welcome');
        }
        $store = $this->site->getStoreByID($inv->store_id);
        if($Staff){
        $this->tec->view_rights($inv->created_by);
        }
        $this->load->helper('text');
        $this->data['rows'] = $this->pos_model->getAllSaleItems($sale_id);
        $this->data['customer'] = $customer;
        $this->data['store'] = $store;
        $this->data['inv'] = $inv;
        $this->data['sid'] = $sale_id;
        $this->data['due'] = $this->pos_model->getDue($inv->customer_id);
        $this->data['noprint'] = $noprint;
        $this->data['modal'] = $noprint ? true : false;
        $this->data['payments'] = $this->pos_model->getAllSalePayments($sale_id);
        $this->data['created_by'] = $this->site->getUser($inv->created_by);
        $this->data['printer'] = $this->site->getPrinterByID($this->Settings->printer);        
        $this->data['page_title'] = lang("invoice");
        $this->data['saleid_barcode'] = $this->tec->barcode($inv->inv_number, 'code128', 30,'1');
        $this->data['aba_qrstring'] = $this->tec->qrcode('text', $store->aba_qrstring , 2);
        $this->data['acleda_qrstring'] = $this->tec->qrcode('text', $store->acleda_qrstring , 2);
        $this->data['total_sales'] = $this->pos_model->getTotalCustomerSales($inv->customer_id);
        $this->data['summary_categories'] = $this->pos_model->getSummaryCategories($sale_id);
        //ABA PayWay
        /*
        if ($inv->status == 'due') { //Show only for Due contract
            $params= array(
                "hash" => PayWayApiCheckout::getHash($sale_id, $inv->grand_total),
                "tran_id" => $sale_id,
                "amount" => $inv->grand_total,
                "firstname" => $customer->name,
                "lastname" => '',
                "phone" => $customer->phone ? $customer->phone : $this->Settings->phone,
                "email" => $customer->email ? $customer->email : $this->Settings->default_email,
                "currency" => 'USD',
                "payment_option" => 'abapay'
            );                 
            $htmlEle = $this->tec->postCURL(PayWayApiCheckout::getApiUrl(), $params);
            $domdoc = new DOMDocument();
            $domdoc->loadHTML($htmlEle);         
            $this->data['aba_qrcode'] = $this->tec->qrcode('text', $domdoc->getElementById('poqrVal')->getAttribute('value') , 2);         
        }
        
         if($this->Settings->paper_size == 0){
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view'), $this->data);
        }else if($this->Settings->paper_size == 1){
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_a5'), $this->data);
        }else{
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_58'), $this->data);
        }
         if ($receipt_format == 0) { //80mm
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view'), $this->data);
        } elseif ($receipt_format == 1) { //58mm
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_58'), $this->data);
        } elseif ($receipt_format == 2) { //A5
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_A5'), $this->data);
        } elseif ($receipt_format == 3) { //A5
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view2'), $this->data);
        }

        */   
        
        
        if($this->Settings->receipt_format == 0){
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view'), $this->data);
        }else if($this->Settings->receipt_format == 1){
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_58'), $this->data);
        }else if($this->Settings->receipt_format == 2){
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view_A5'), $this->data);
        }else{
            $this->load->view($this->theme.'pos/'.($this->Settings->print_img ? 'eview' : 'view2'), $this->data);
        }
       
        
       
    }

    function pdf_receipt($sale_id = NULL, $noprint = NULL) {
        if($this->input->get('id')){ $sale_id = $this->input->get('id'); }
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['message'] = $this->session->flashdata('message');
        $inv = $this->pos_model->getSaleByID($sale_id);
        $customer = $this->pos_model->getCustomerByID($inv->customer_id);
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        } elseif ($this->session->userdata('store_id') != $inv->store_id) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('welcome');
        }
        $this->tec->view_rights($inv->created_by);
        $this->load->helper('text');
        $store = $this->site->getStoreByID($inv->store_id);
        $this->data['rows'] = $this->pos_model->getAllSaleItems($sale_id);
        $this->data['customer'] = $customer;
        $this->data['store'] = $store;
        $this->data['inv'] = $inv;
        $this->data['sid'] = $sale_id;
        $this->data['noprint'] = $noprint;
        $this->data['modal'] = $noprint ? true : false;
        $this->data['payments'] = $this->pos_model->getAllSalePayments($sale_id);
        $this->data['created_by'] = $this->site->getUser($inv->created_by);
        $this->data['printer'] = $this->site->getPrinterByID($this->Settings->printer);
        $this->data['page_title'] = lang("invoice");
        $this->data['saleid_barcode'] = $this->tec->barcode($inv->inv_number, 'code128', 30,'1');
        $this->data['aba_qrstring'] = $this->tec->qrcode('text', $store->aba_qrstring , 2);
        $this->data['acleda_qrstring'] = $this->tec->qrcode('text', $store->acleda_qrstring , 2);
        $this->data['total_sales'] = $this->pos_model->getTotalCustomerSales($inv->customer_id);
        $this->data['summary_categories'] = $this->pos_model->getSummaryCategories($sale_id);
        /*ABA PayWay
        if ($inv->status == 'due') { //Show only for Due contract
            $params= array(
                "hash" => PayWayApiCheckout::getHash($sale_id, $inv->grand_total),
                "tran_id" => $sale_id,
                "amount" => $inv->grand_total,
                "firstname" => $customer->name,
                "lastname" => '',
                "phone" => $customer->phone ? $customer->phone : $this->Settings->phone,
                "email" => $customer->email ? $customer->email : $this->Settings->default_email,
                "currency" => 'USD',
                "payment_option" => 'abapay'
            );                 
            $htmlEle = $this->tec->postCURL(PayWayApiCheckout::getApiUrl(), $params);
            $domdoc = new DOMDocument();
            $domdoc->loadHTML($htmlEle);         
            $this->data['aba_qrcode'] = $this->tec->qrcode('text', $domdoc->getElementById('poqrVal')->getAttribute('value') , 2);         
        }
        */
        //$stylesheet = file_get_contents(FCPATH .'vendor\mpdf\mpdf\data\receipt.css');
        $savepath = FCPATH .'/uploads/pdf/payment/' . $this->session->userdata('terminal_id') . "/PAY_".time().".pdf";
        
        if ($this->Settings->receipt_format == 0) { //80mm
            $html = $this->load->view($this->theme.'pos/view', $this->data, true);
            $width = 80;
            $height = 3276;
        } elseif ($this->Settings->receipt_format == 1) { //58mm
            $html = $this->load->view($this->theme.'pos/view', $this->data, true);
            $width = 58;
            $height = 3276;
        } elseif ($this->Settings->receipt_format == 2) { //A5
            $html = $this->load->view($this->theme.'pos/view_A5', $this->data, true);
            $width = 148;
            $height = 210;
        }       
        $this->tec->Html2Pdf($html,NULL,$savepath,[$width, $height]);
        //Print Order Label        
        if($this->Settings->print_order_label != 0){
            if($this->Settings->print_order_label == 1){
                $rows = $this->pos_model->getAllSaleItems($sale_id);
            }else{ //print beverage only
                $rows = $this->pos_model->getBeverageSaleItems($sale_id);
            }
            $count = 1;


            $waitingnumber = $this->Settings->waiting_number+1;
            $html = "";
            foreach ($rows as $row) {                
                $sting2 =$count . '/'. count($rows);
                $html = $html . '<div><p>' . '#' . $waitingnumber . '</p><p>' . $row->product_name . '</p><p><small>' . $row->comment . '</small></p><p>' . $sting2 . '</p></div>';  
                $count++;      
            }

    
            $label_fontsize = ($this->Settings->label_fontsize > 0) ? $this->Settings->label_fontsize : 8;
            $label_width = ($this->Settings->label_width > 0) ? $this->Settings->label_width : 40;
            $label_height = ($this->Settings->label_height > 0) ? $this->Settings->label_height : 25;
            $stylesheet = '@page{margin:8px;} body{margin:0;padding:0;} p{margin:0;padding:0;color:#000;text-align:center;font-size:' . $label_fontsize . 'px;}';
            $savepath = FCPATH .'/uploads/pdf/kitchen/' . $this->session->userdata('terminal_id') . "/KIT_".$row->id.".pdf";
            $this->tec->Html2Pdf($html,$stylesheet,$savepath,[$label_width, $label_height]);

            //foreach ($rows as $row) {                
            //    $sting2 =$count . '/'. count($rows);
           //   $this->order_label_pdf($row, $sting2);               
           //     $count++;      
           // }
            
        }
        //Print Customer Label
        if($this->Settings->print_customer_label){
            $this->label_customer($sale_id);
        }
    }

    function order_label_pdf($row = NULL, $count = NULL) {
        $waitingnumber = $this->Settings->waiting_number+1;                           
        $html = '<div><p>' . '#' . $waitingnumber . '</p><p>' . $row->product_name . '</p><p><small>' . $row->comment . '</small></p><p>' . $count . '</p></div>';       
        $label_fontsize = ($this->Settings->label_fontsize > 0) ? $this->Settings->label_fontsize : 8;
        $label_width = ($this->Settings->label_width > 0) ? $this->Settings->label_width : 40;
        $label_height = ($this->Settings->label_height > 0) ? $this->Settings->label_height : 25;
        $stylesheet = '@page{margin:8px;} body{margin:0;padding:0;} p{margin:0;padding:0;color:#000;text-align:left;font-size:' . $label_fontsize . 'px;}';
        $savepath = FCPATH .'/uploads/pdf/kitchen/' . $this->session->userdata('terminal_id') . "/KIT_".$row->id.".pdf";
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[$label_width, $label_height]);
    }

    function pdf_bill() {
        $html = $this->input->post('html', TRUE);
        $font_size_1 = $this->Settings->receipt_font_size + 1;
        $font_size_2 = $this->Settings->receipt_font_size + 2;
        $margin = $this->Settings->pos_printer_margin ? '2px 35px 2px 2px;' : '15px;';
        $stylesheet = $stylesheet . '@page{margin:'.$margin.'} body{font-family:"Battambang", "Khmer OS Battambang"; font-size:' . $this->Settings->receipt_font_size . 'px; line-height: 1.5;} h5{margin:0; font-size:' . $font_size_1 . 'px; font-weight:normal;} table{font-size:' . $this->Settings->receipt_font_size . 'px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} 
        table#bill-table{border-bottom: 1px solid; border-top: 1px solid;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:' . $font_size_2 . 'px; color:#fff;} td{padding:5px;} div#qrcode{text-align:center;}';
        $savepath = FCPATH .'/uploads/pdf/bill/' . $this->session->userdata('terminal_id') . "/BIL_".time().".pdf";    
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[80, 3276]);
    }

    function pdf_order() {
        $html = $this->input->post('html', TRUE);
        $font_size_1 = $this->Settings->receipt_font_size + 1;
        $font_size_2 = $this->Settings->receipt_font_size + 2;
        $margin = $this->Settings->pos_printer_margin ? '2px 35px 2px 2px;' : '15px;';
        $stylesheet = $stylesheet . '@page{margin:'.$margin.'} body{font-family:"Battambang", "Khmer OS Battambang"; font-size:' . $this->Settings->receipt_font_size . 'px; line-height: 1.5;} h5{margin:0; font-size:' . $font_size_1 . 'px; font-weight:normal;} table{font-size:' . $this->Settings->receipt_font_size . 'px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} 
        table#bill-table{border-bottom: 1px solid; border-top: 1px solid;} table#order-table{border-bottom: 1px solid; border-top: 1px solid; width:100%;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:' . $font_size_2 . 'px; color:#fff;} td{padding:5px;}';
        $savepath = FCPATH .'/uploads/pdf/order/' . $this->session->userdata('terminal_id') . "/ORD_".time().".pdf";    
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[80, 3276]);
    }

    function pdf_order_drink() {
        $html = $this->input->post('html', TRUE);
        $font_size_1 = $this->Settings->receipt_font_size + 1;
        $font_size_2 = $this->Settings->receipt_font_size + 2;
        $margin = $this->Settings->pos_printer_margin ? '2px 35px 2px 2px;' : '15px;';
        $stylesheet = $stylesheet . '@page{margin:'.$margin.'} body{font-family:"Battambang", "Khmer OS Battambang"; font-size:' . $this->Settings->receipt_font_size . 'px; line-height: 1.5;} h5{margin:0; font-size:' . $font_size_1 . 'px; font-weight:normal;} table{font-size:' . $this->Settings->receipt_font_size . 'px; border-collapse: collapse;} table.table thead tr th{background-color:#000 !important; color:#fff !important; padding:5px 10px;} 
        table#bill-table1{border-bottom: 1px solid; border-top: 1px solid;} table#order-table1{border-bottom: 1px solid; border-top: 1px solid; width:100%;} p{margin:5px 0;} .text-center{text-align:center;} .text-left{text-align:left;} .text-right{text-align:right;} td.my-total{font-weight:bold; background-color:#000; font-size:' . $font_size_2 . 'px; color:#fff;} td{padding:5px;}';
        $savepath = FCPATH .'/uploads/pdf/kitchen/' . $this->session->userdata('terminal_id') . "/KIT_".time().".pdf";    
        $this->tec->Html2Pdf($html,$stylesheet,$savepath,[80, 3276]);
    }

    

  
	
	function label_customer($sale_id = NULL) {
        $inv = $this->pos_model->getSaleByID($sale_id);        
        $this->data['customer'] = $this->pos_model->getCustomerByID($inv->customer_id);
        $this->data['inv'] = $inv;
        $savepath = FCPATH .'/uploads/pdf/kitchen/' . $this->session->userdata('terminal_id') . "/KIT_".time().".pdf";
        $html = $this->load->view($this->theme.'pos/view_label', $this->data, true);  
        //$label_width = ($this->Settings->label_width > 0) ? $this->Settings->label_width : 60;
        //$label_height = ($this->Settings->label_height > 0) ? $this->Settings->label_height : 40;
        $label_width = 60;
        $label_height = 40;
        $this->tec->Html2Pdf($html,NULL,$savepath,[$label_width, $label_height]);

    }

    function email_receipt($sale_id = NULL, $to = NULL) {
        if($this->input->post('id')) { $sale_id = $this->input->post('id'); }
        if($this->input->post('email')){ $to = $this->input->post('email'); }
        if(!$sale_id || !$to) { die(); }

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['message'] = $this->session->flashdata('message');
        $inv = $this->pos_model->getSaleByID($sale_id);
        $this->tec->view_rights($inv->created_by);
        $this->load->helper('text');
        $this->data['rows'] = $this->pos_model->getAllSaleItems($sale_id);
        $this->data['customer'] = $this->pos_model->getCustomerByID($inv->customer_id);
        $this->data['inv'] = $inv;
        $this->data['sid'] = $sale_id;
        $this->data['noprint'] = NULL;
        $this->data['page_title'] = lang('invoice');
        $this->data['modal'] = false;
        $this->data['payments'] = $this->pos_model->getAllSalePayments($sale_id);
        $this->data['created_by'] = $this->site->getUser($inv->created_by);
        $this->data['saleid_barcode'] = $this->tec->barcode($inv->inv_number, 'code128', 30,'1');
        
        $receipt = $this->load->view($this->theme.'pos/view', $this->data, TRUE);
        $message = preg_replace('#\<!-- start -->(.+)\<!-- end -->#Usi', '', $receipt);
        $subject = lang('email_subject').' - '.$this->Settings->site_name;

        try {
            if ($this->tec->send_email($to, $subject, $message)) {
                echo json_encode(array('msg' => lang("email_success")));
            } else {
                echo json_encode(array('msg' => lang("email_failed")));
            }
        } catch (Exception $e) {
            echo json_encode(array('msg' => $e->getMessage()));
        }

    }


    function register_details() {

        $register_open_time = $this->session->userdata('register_open_time');
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['ccsales'] = $this->pos_model->getRegisterCCSales($register_open_time); //as ACLEDA
        $this->data['cashsales'] = $this->pos_model->getRegisterCashSales($register_open_time);
        $this->data['chsales'] = $this->pos_model->getRegisterChSales($register_open_time); //as ABA
        $this->data['other_sales'] = $this->pos_model->getRegisterOtherSales($register_open_time);
        $this->data['gcsales'] = $this->pos_model->getRegisterGCSales($register_open_time); //as WING
        $this->data['stripesales'] = $this->pos_model->getRegisterStripeSales($register_open_time);
        $this->data['totalsales'] = $this->pos_model->getRegisterSales($register_open_time);
        $this->data['sales_discount_tax'] = $this->pos_model->getRegisterSalesDiscountTax($register_open_time);
        $this->data['expenses'] = $this->pos_model->getRegisterExpenses($register_open_time);
        $this->load->view($this->theme . 'pos/register_details', $this->data);
    }

    function today_sale() {
        //if (!$this->Admin) {
        //    $this->session->set_flashdata('error', lang('access_denied'));
        //    redirect($_SERVER["HTTP_REFERER"]);
        //}

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['ccsales'] = $this->pos_model->getTodayCCSales(); //as ACLEDA
        $this->data['cashsales'] = $this->pos_model->getTodayCashSales();
        $this->data['chsales'] = $this->pos_model->getTodayChSales(); //as ABA
        $this->data['other_sales'] = $this->pos_model->getTodayOtherSales();
        $this->data['gcsales'] = $this->pos_model->getTodayGCSales(); //as WING
        $this->data['stripesales'] = $this->pos_model->getTodayStripeSales();
        $this->data['totalsales'] = $this->pos_model->getTodaySales();
        $this->data['sale_items'] = $this->pos_model->getTodaySaleItems();
        $this->data['totalsalesdue'] = $this->pos_model->getTodaySalesDue();
        $this->data['expenses'] = $this->pos_model->getTodayExpenses();
        $this->data['cost'] = $this->pos_model->getTodayCost();
        $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        $this->load->view($this->theme . 'pos/today_sale', $this->data);
    }

    function shortcuts() {
        $this->load->view($this->theme . 'pos/shortcuts', $this->data);
    }

    function view_bill() {
        $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        $this->load->view($this->theme . 'pos/view_bill', $this->data);
    }

    function promotions() {
        $this->data['store'] = $this->site->getStoreByID($this->session->userdata('store_id'));
        $this->load->view($this->theme . 'promotions', $this->data);
    }

    function stripe_balance() {
        if (!$this->Owner) {
            return FALSE;
        }
        $this->load->model('stripe_payments');
        return $this->stripe_payments->get_balance();
    }

    function language($lang = false) {
        if ($this->input->get('lang')) {
            $lang = $this->input->get('lang');
        }
        //$this->load->helper('cookie');
        $folder = 'app/language/';
        $languagefiles = scandir($folder);
        if (in_array($lang, $languagefiles)) {
            $cookie = array(
                'name' => 'language',
                'value' => $lang,
                'expire' => '31536000',
                'prefix' => 'spos_',
                'secure' => false
            );

            $this->input->set_cookie($cookie);
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function validate_gift_card($no) {
        if ($gc = $this->pos_model->getGiftCardByNO(urldecode($no))) {
            if ($gc->expiry) {
                if ($gc->expiry >= date('Y-m-d')) {
                    echo json_encode($gc);
                } else {
                    echo json_encode(false);
                }
            } else {
                echo json_encode($gc);
            }
        } else {
            echo json_encode(false);
        }
    }

    function print_register($re = NULL) {

        if ($this->session->userdata('register_id')) {

            $register = $this->pos_model->registerData();
            $ccsales = $this->pos_model->getRegisterCCSales();
            $cashsales = $this->pos_model->getRegisterCashSales();
            $chsales = $this->pos_model->getRegisterChSales();
            $other_sales = $this->pos_model->getRegisterOtherSales();
            $gcsales = $this->pos_model->getRegisterGCSales();
            $stripesales = $this->pos_model->getRegisterStripeSales();
            $totalsales = $this->pos_model->getRegisterSales();
            $expenses = $this->pos_model->getRegisterExpenses();
            $user = $this->site->getUser();

            $total_cash = $cashsales->paid ? ($cashsales->paid + $register->cash_in_hand) : $register->cash_in_hand;
            $total_cash -= ($expenses->total ? $expenses->total : 0);
            $info = array(
                (object) array('label' => lang('opened_at'), 'value' => $this->tec->hrld($register->date)),
                (object) array('label' => lang('cash_in_hand'), 'value' => $register->cash_in_hand),
                (object) array('label' => lang('user'), 'value' => $user->first_name.' '.$user->last_name.' ('.$user->email.')'),
                (object) array('label' => lang('printed_at'),  'value' => $this->tec->hrld(date('Y-m-d H:i:s')))
                );

            $reg_totals = array(
                (object) array('label' => lang('cash_sale'), 'value' => $this->tec->formatMoney($cashsales->paid ? $cashsales->paid : '0.00') . ' (' . $this->tec->formatMoney($cashsales->total ? $cashsales->total : '0.00') . ')'),
                (object) array('label' => lang('ch_sale'), 'value' => $this->tec->formatMoney($chsales->paid ? $chsales->paid : '0.00') . ' (' . $this->tec->formatMoney($chsales->total ? $chsales->total : '0.00') . ')'),
                (object) array('label' => lang('gc_sale'),  'value' => $this->tec->formatMoney($gcsales->paid ? $gcsales->paid : '0.00') . ' (' . $this->tec->formatMoney($gcsales->total ? $gcsales->total : '0.00') . ')'),
                (object) array('label' => lang('cc_sale'),  'value' => $this->tec->formatMoney($ccsales->paid ? $ccsales->paid : '0.00') . ' (' . $this->tec->formatMoney($ccsales->total ? $ccsales->total : '0.00') . ')'),
                (object) array('label' => lang('stripe'),  'value' => $this->tec->formatMoney($stripesales->paid ? $stripesales->paid : '0.00') . ' (' . $this->tec->formatMoney($stripesales->total ? $stripesales->total : '0.00') . ')'),
                (object) array('label' => lang('other_sale'),  'value' => $this->tec->formatMoney($other_sales->paid ? $other_sales->paid : '0.00') . ' (' . $this->tec->formatMoney($other_sales->total ? $other_sales->total : '0.00') . ')'),
                (object) array('label' => 'line',  'value' => ''),
                (object) array('label' => lang('total_sales'),  'value' => $this->tec->formatMoney($totalsales->paid ? $totalsales->paid : '0.00') . ' (' . $this->tec->formatMoney($totalsales->total ? $totalsales->total : '0.00') . ')'),
                (object) array('label' => lang('cash_in_hand'),  'value' => $this->tec->formatMoney($register->cash_in_hand)),
                (object) array('label' => lang('expenses'),  'value' => $this->tec->formatMoney($expenses->total ? $expenses->total : '0.00')),
                (object) array('label' => 'line',  'value' => ''),
                (object) array('label' => lang('total_cash'),  'value' => $this->tec->formatMoney($total_cash))
                );

            $data = (object) array(
                'printer' => $this->Settings->local_printers ? '' : json_encode($printer),
                'logo' => !empty($store->logo) ? base_url('uploads/'.$store->logo) : '',
                'heading' => lang('register_details'),
                'info' => $info,
                'totals' => $reg_totals
                );

            // $this->tec->print_arrays($data);
            if ($re == 1) {
                return $data;
            } elseif ($re == 2) {
                echo json_encode($data);
            } else {
                $printer = $this->site->getPrinterByID($this->Settings->printer);
                $this->load->library('escpos');
                $this->escpos->load($printer);
                $this->escpos->print_data($data);
                echo json_encode(true);
            }

        } else {
            echo json_encode(false);
        }
    }

    function print_receipt($id, $open_drawer = false) {

        $sale = $this->pos_model->getSaleByID($id);
        $items = $this->pos_model->getAllSaleItems($id);
        $payments = $this->pos_model->getAllSalePayments($id);
        $store = $this->site->getStoreByID($sale->store_id);
        $created_by = $this->site->getUser($sale->created_by);
        $printer = $this->site->getPrinterByID($this->Settings->printer);
        $this->load->library('escpos');
        $this->escpos->load($printer);
        $this->escpos->print_receipt($store, $sale, $items, $payments, $created_by, $open_drawer);

    }

    function receipt_img() {

        $data = $this->input->post('img', TRUE);
        $filename = date('Y-m-d-H-i-s-').uniqid().'.png';
        $cd = !empty($this->input->post('cd')) ? true : false;
        $imgData = str_replace(' ', '+', $data);
        $imgData = base64_decode($imgData);
        file_put_contents('files/receipts/'.$filename, $imgData);
        $printer = $this->site->getPrinterByID($this->Settings->printer);
        $this->load->library('escpos');
        $this->escpos->load($printer);
        $this->escpos->print_img($filename, $cd);

    }

    function gen_barcode($code) {
        if ($this->input->get('code')) { $code = $this->input->get('code'); }
        if($barcode = $this->tec->barcode($code, 'code128', 30,'1')) {
            echo json_encode(array('barcode' => $barcode));
        } else {
            echo NULL;
        }
    }

    function ajax_customer($code = NULL) {

        if ($this->input->get('code')) { $code = $this->input->get('code'); }
        if($customer = $this->pos_model->getCustomerByID($code)) {
            echo json_encode(array('name' => $customer->name,'phone' => $customer->phone,'cf1' => $customer->cf1,'cf2' => $customer->cf2,'email' => $customer->email,'discount' => $customer->discount,'award_points' => $customer->award_points,'group_id' => $customer->group_id));
        } else {
            echo NULL;
        }

    }

    function ajax_product_option($code = NULL) {

        if ($this->input->get('code')) { $code = $this->input->get('code'); }
        if($product_option = $this->pos_model->getProductOptionByID($code)) {
            echo json_encode(array('code' => $product_option->code,'name' => $product_option->name,'type' => $product_option->type,'additional_price' => $product_option->additional_price,'additional_price_wholesale' => $product_option->additional_price_wholesale));
        } else {
            echo NULL;
        }

    }

    function ajax_product_option_bygroup($group = NULL, $type = NULL) {

        if ($this->input->get('pgroup')) { $group = $this->input->get('pgroup'); }
        if($product_options = $this->pos_model->getProductOptionByGroup($group,$type)) {
            echo json_encode($product_options);
        } else {
            echo NULL;
        }

    }

    function ajax_customer_sales($code = NULL) {

        if ($this->input->get('code')) { $code = $this->input->get('code'); }
        if($total_sales = $this->pos_model->getTotalCustomerSales($code)) {
            echo json_encode(array('total_sales' => $total_sales->amount,'total_due' => $total_sales->amount-$total_sales->paid,'total_paid' => $total_sales->paid));
        } else {
            echo NULL;
        }

    }

    function open_drawer() {

        $printer = $this->site->getPrinterByID($this->Settings->printer);
        $this->load->library('escpos');
        $this->escpos->load($printer);
        $this->escpos->open_drawer();

    }

    function p($bo = 'order') {

        $date = date('Y-m-d H:i:s');
        $customer_id = $this->input->post('customer_id');
        $customer_details = $this->pos_model->getCustomerByID($customer_id);
        $customer = $customer_details->name;
        $note = $this->tec->clear_tags($this->input->post('spos_note'));

        $total = 0;
        $product_tax = 0;
        $order_tax = 0;
        $product_discount = 0;
        $order_discount = 0;
        $percentage = '%';
        $i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
        for ($r = 0; $r < $i; $r++) {
            $item_id = $_POST['product_id'][$r];
            $real_unit_price = $this->tec->formatDecimal($_POST['real_unit_price'][$r]);
            $item_quantity = $_POST['quantity'][$r];
            $item_comment = $_POST['item_comment'][$r];
            $item_ordered = $_POST['item_was_ordered'][$r];
            $item_discount = isset($_POST['product_discount'][$r]) ? $_POST['product_discount'][$r] : '0';
            $item_length = $_POST['length'][$r];

            if (isset($item_id) && isset($real_unit_price) && isset($item_quantity)) {
                $product_details = $this->site->getProductByID($item_id);
                if ($product_details) {
                    $product_name = $product_details->name;
                    $product_code = $product_details->code;
                    $product_cost = $product_details->cost;
                } else {
                    $product_name = $_POST['product_name'][$r];
                    $product_code = $_POST['product_code'][$r];
                    $product_cost = 0;
                }
                if (!$this->Settings->overselling) {
                    if ($product_details->type == 'standard') {
                        if ($product_details->quantity < $item_quantity) {
                            $this->session->set_flashdata('error', lang("quantity_low").' ('.
                                lang('name').': '.$product_details->name.' | '.
                                lang('ordered').': '.$item_quantity.' | '.
                                lang('available').': '.$product_details->quantity.
                                ')');
                            redirect("pos");
                        }
                    } elseif ($product_details->type == 'combo') {
                        $combo_items = $this->pos_model->getComboItemsByPID($product->id);
                        foreach ($combo_items as $combo_item) {
                            $cpr = $this->site->getProductByID($combo_item->id);
                            if ($cpr->quantity < $item_quantity) {
                                $this->session->set_flashdata('error', lang("quantity_low").' ('.
                                    lang('name').': '.$cpr->name.' | '.
                                    lang('ordered').': '.$item_quantity.' x '.$combo_item->qty.' = '.$item_quantity*$combo_item->qty.' | '.
                                    lang('available').': '.$cpr->quantity.
                                    ') '.$product_details->name);
                                redirect("pos");
                            }
                        }
                    }
                }
                $unit_price = $real_unit_price;

                $pr_discount = 0;
                if (isset($item_discount)) {
                    $discount = $item_discount;
                    $dpos = strpos($discount, $percentage);
                    if ($dpos !== false) {
                        $pds = explode("%", $discount);
                        $pr_discount = $this->tec->formatDecimal(($unit_price * (Float)($pds[0])) / 100);
                    } else {
                        $pr_discount = $this->tec->formatDecimal($discount);
                    }
                }
                $itm_length = (float)$item_length > 0 ? (float)$item_length : 1;

                $unit_price = $this->tec->formatDecimal($unit_price - $pr_discount);
                $item_net_price = $unit_price;
                $pr_item_discount = $this->tec->formatDecimal($pr_discount * $item_quantity * $itm_length);
                $product_discount += $pr_item_discount;

                $pr_item_tax = 0; $item_tax = 0; $tax = "";
                if (isset($product_details->tax) && $product_details->tax != 0) {

                    if ($product_details && $product_details->tax_method == 1) {
                        $item_tax = $this->tec->formatDecimal((($unit_price) * $product_details->tax) / 100);
                        $tax = $product_details->tax . "%";
                    } else {
                        $item_tax = $this->tec->formatDecimal((($unit_price) * $product_details->tax) / (100 + $product_details->tax));
                        $tax = $product_details->tax . "%";
                        $item_net_price -= $item_tax;
                    }

                    $pr_item_tax = $this->tec->formatDecimal($item_tax * $item_quantity);

                }

                $product_tax += $pr_item_tax;                
                $subtotal = (($item_net_price * $item_quantity *$itm_length) + $pr_item_tax);

                $products[] = (object) array(
                    'product_id' => $item_id,
                    'quantity' => $item_quantity,
                    'unit_price' => $unit_price,
                    'net_unit_price' => $item_net_price,
                    'discount' => $item_discount,
                    'comment' => $item_comment,
                    'item_discount' => $pr_item_discount,
                    'tax' => $tax,
                    'item_tax' => $pr_item_tax,
                    'subtotal' => $subtotal,
                    'real_unit_price' => $real_unit_price,
                    'cost' => $product_cost,
                    'product_code' => $product_code,
                    'product_name' => $product_name,
                    'ordered' => $item_ordered,
                    'length' => $item_length,
                    );               
                
                $total += $item_net_price * $item_quantity * $itm_length;

            }
        }
        if (empty($products)) {
            $this->form_validation->set_rules('product', lang("order_items"), 'required');
        } else {
            krsort($products);
        }

        if ($this->input->post('order_discount')) {
            $order_discount_id = $this->input->post('order_discount');
            $opos = strpos($order_discount_id, $percentage);
            if ($opos !== false) {
                $ods = explode("%", $order_discount_id);
                $order_discount = $this->tec->formatDecimal((($total + $product_tax) * (Float)($ods[0])) / 100);
            } else {
                $order_discount = $this->tec->formatDecimal($order_discount_id);
            }
        } else {
            $order_discount_id = NULL;
        }
        $total_discount = $this->tec->formatDecimal($order_discount + $product_discount);

        if($this->input->post('order_tax')) {
            $order_tax_id = $this->input->post('order_tax');
            $opos = strpos($order_tax_id, $percentage);
            if ($opos !== false) {
                $ots = explode("%", $order_tax_id);
                $order_tax = $this->tec->formatDecimal((($total + $product_tax - $order_discount) * (Float)($ots[0])) / 100);
            } else {
                $order_tax = $this->tec->formatDecimal($order_tax_id);
            }

        } else {
            $order_tax_id = NULL;
            $order_tax = 0;
        }

        $total_tax = $this->tec->formatDecimal($product_tax + $order_tax);
        $grand_total = $this->tec->formatDecimal($this->tec->formatDecimal($total) + $total_tax - $order_discount);
        $paid = 0;
        $round_total = $this->tec->roundNumber($grand_total, $this->Settings->rounding);
        $rounding = $this->tec->formatDecimal(($round_total - $grand_total));

        $data = (object) array('date' => $date,
            'customer_id' => $customer_id,
            'customer_name' => $customer,
            'total' => $this->tec->formatDecimal($total),
            'product_discount' => $this->tec->formatDecimal($product_discount),
            'order_discount_id' => $order_discount_id,
            'order_discount' => $order_discount,
            'total_discount' => $total_discount,
            'product_tax' => $this->tec->formatDecimal($product_tax),
            'order_tax_id' => $order_tax_id,
            'order_tax' => $order_tax,
            'total_tax' => $total_tax,
            'grand_total' => $grand_total,
            'total_items' => $this->input->post('total_items'),
            'total_quantity' => $this->input->post('total_quantity'),
            'rounding' => $rounding,
            'paid' => $paid,
            'created_by' => $this->session->userdata('user_id'),
            'note' => $note,
            'hold_ref' => $this->input->post('hold_ref'),
            );

        // $this->tec->print_arrays($data, $products);
        $store = $this->site->getStoreByID($this->session->userdata('store_id'));
        $created_by = $this->site->getUser($this->session->userdata('user_id'));

        if ($bo == 'bill') {
            $printer = $this->site->getPrinterByID($this->Settings->printer);
            $this->load->library('escpos');
            $this->escpos->load($printer);
            $this->escpos->print_receipt($store, $data, $products, false, $created_by, false, true);
        } else {
            $order_printers = json_decode($this->Settings->order_printers);
            $this->load->library('escpos');
            foreach ($order_printers as $printer_id) {
                $printer = $this->site->getPrinterByID($printer_id);
                $this->escpos->load($printer);
                $this->escpos->print_order($store, $data, $products, $created_by);
            }
        }

    }

    function telegram_receipt($sale_id = NULL) {        
        $inv = $this->pos_model->getSaleByID($sale_id);
        $items = $this->pos_model->getAllSaleItems($sale_id);
        $store = $this->site->getStoreByID($inv->store_id);
        $created_by = $this->site->getUser($inv->created_by);
        $text = lang('sale_added') . ": \n";
        $text = $text . lang('store') . ": " . $store->name . " \n";
        $text = $text . lang('sale_no_ref') . ": " . $inv->inv_number . " \n";
        $text = $text . lang("customer").': '. $inv->customer_name . " \n";
        $text = $text . lang("sales_person").': '. $created_by->first_name." ".$created_by->last_name . " \n";
        $text = $text . lang("date").': '.$this->tec->hrld($inv->date) . " \n";        
        $text = $text . lang('status') . ": " . lang($inv->status) . " \n";
        if ($inv->note != '') {$text = $text . lang('note') . ": " . lang($inv->note) . " \n";}
        $text = $text . lang('item_des') . " \n";
        $no = 0;
        foreach ($items as $item) {
            $no = $no + 1;
            $text = $text . $no . ' - ' . $item->product_name . ' : ' . $this->tec->formatMoney($item->unit_price) . ' x ' .  $this->tec->formatQuantity($item->quantity) . ' = ' .  $this->tec->formatMoney($item->subtotal) . " \n";
        }
        $text = $text . lang('discount') . ": " . $this->tec->formatMoney($inv->total_discount) . " \n";
        $text = $text . lang('grand_total') . ": " . $this->tec->formatMoney($inv->grand_total) . " \n";
        $this->telegram_lib->sendmsg($text);
    }

    function telegram_edit_sale($sale_id = NULL) {        
        $inv = $this->pos_model->getSaleByID($sale_id);
        $items = $this->pos_model->getAllSaleItems($sale_id);
        $store = $this->site->getStoreByID($inv->store_id);
        $created_by = $this->site->getUser($inv->created_by);
        $updated_by = $this->site->getUser($inv->updated_by);
        $text = lang('sale_updated') . ": \n";
        $text = $text . lang('store') . ": " . $store->name . " \n";
        $text = $text . lang('sale_no_ref') . ": " . $inv->inv_number . " \n";
        $text = $text . lang("customer").': '. $inv->customer_name . " \n";
        $text = $text . lang("sales_person").': '. $created_by->first_name." ".$created_by->last_name . " \n";
        $text = $text . lang("date").': '.$this->tec->hrld($inv->date) . " \n";       
        $text = $text . lang('status') . ": " . lang($inv->status) . " \n";
        $text = $text . lang("perform_by").': '. $updated_by->first_name." ".$updated_by->last_name . " \n";
        if ($inv->note != '') {$text = $text . lang('note') . ": " . lang($inv->note) . " \n";}
        $text = $text . lang('item_des') . " \n";
        $no = 0;
        foreach ($items as $item) {
            $no = $no + 1;
            $text = $text . $no . ' - ' . $item->product_name . ' : ' . $this->tec->formatMoney($item->unit_price) . ' x ' .  $this->tec->formatQuantity($item->quantity) . ' = ' .  $this->tec->formatMoney($item->subtotal) . " \n";
        }
        $text = $text . lang('grand_total') . ": " . $this->tec->formatMoney($inv->grand_total) . " \n";
        $this->telegram_lib->sendmsg($text);
    }

    function reset_waitingnumber() {
        if($this->pos_model->resetWaitingNumber()) {
            $this->session->set_flashdata('message', lang('reset_waiting_number'));            
        } else {
            $this->session->set_flashdata('error', lang('reset_waiting_number'));
        }
        redirect("pos");
    }

}
