<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Exchanges extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('exchanges_model');
    }

    function index() {

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));        
        $this->data['page_title'] = lang('exchanges');
        $bc = array(array('link' => '#', 'page' => lang('exchanges')));
        $meta = array('page_title' => lang('exchanges'), 'bc' => $bc);
        $this->page_construct('exchanges/index', $this->data, $meta);

    }

    function get_exchanges() {

        $this->load->library('datatables');
        $this->datatables->select("id, date, buy_rate, sell_rate, amount_to_change, amount_changed, amount_received, changes, type, symbol_to_change, symbol_changed");
        $this->datatables->from('exchanges');
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('exchanges/edit/$1') . "' title='" . lang("edit_exchanges") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('exchanges/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_category') . "')\" title='" . lang("delete_exchanges") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

    function add() {

        $this->form_validation->set_rules('buy_rate', lang('buy_rate'), 'required|is_numeric');
        $this->form_validation->set_rules('sell_rate', lang('sell_rate'), 'required|is_numeric');
        $this->form_validation->set_rules('type', lang('type'), 'required');
        $this->form_validation->set_rules('amount_to_change', lang('amount_to_change'), 'required|is_numeric');
        $this->form_validation->set_rules('amount_changed', lang('amount_changed'), 'required|is_numeric');
        $this->form_validation->set_rules('amount_received', lang('amount_received'), 'required|is_numeric');

        if ($this->form_validation->run() == true) {
            $data = array(
                'date' => $this->input->post('date'),
                'buy_rate' => $this->input->post('buy_rate'),
                'sell_rate' => $this->input->post('sell_rate'),
                'type' => $this->input->post('type'),
                'amount_to_change' => $this->input->post('amount_to_change'),
                'amount_changed' => $this->input->post('amount_changed'),
                'amount_received' => $this->input->post('amount_received'),
                'changes' => $this->input->post('changes'),
                'symbol_to_change' => $this->input->post('symbol_to_change'),
                'symbol_changed' => $this->input->post('symbol_changed'),
            );            
        }

        if ($this->form_validation->run() == true && $this->exchanges_model->addExchange($data)) {

            $this->session->set_flashdata('message', lang('exchanges_added'));
            redirect("exchanges");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_exchanges');
            $bc = array(array('link' => site_url('exchanges'), 'page' => lang('exchanges')), array('link' => '#', 'page' => lang('add_exchanges')));
            $meta = array('page_title' => lang('add_exchanges'), 'bc' => $bc);
            $this->page_construct('exchanges/add', $this->data, $meta);
        }
    }

    function edit($id = NULL) {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('buy_rate', lang('buy_rate'), 'required|is_numeric');
        $this->form_validation->set_rules('sell_rate', lang('sell_rate'), 'required|is_numeric');
        $this->form_validation->set_rules('type', lang('type'), 'required');
        $this->form_validation->set_rules('amount_to_change', lang('amount_to_change'), 'required|is_numeric');
        $this->form_validation->set_rules('amount_changed', lang('amount_changed'), 'required|is_numeric');
        $this->form_validation->set_rules('amount_received', lang('amount_received'), 'required|is_numeric');

        if ($this->form_validation->run() == true) {
            $data = array(
                'date' => $this->input->post('date'),
                'buy_rate' => $this->input->post('buy_rate'),
                'sell_rate' => $this->input->post('sell_rate'),
                'type' => $this->input->post('type'),
                'amount_to_change' => $this->input->post('amount_to_change'),
                'amount_changed' => $this->input->post('amount_changed'),
                'amount_received' => $this->input->post('amount_received'),
                'changes' => $this->input->post('changes'),
                'symbol_to_change' => $this->input->post('symbol_to_change'),
                'symbol_changed' => $this->input->post('symbol_changed'),
            );
        }

        if ($this->form_validation->run() == true && $this->exchanges_model->updateExchange($id, $data)) {

            $this->session->set_flashdata('message', lang('exchanges_updated'));
            redirect("exchanges");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['exchanges'] = $this->exchanges_model->getExchangeByID($id);
            $this->data['page_title'] = lang('edit_exchanges');
            $bc = array(array('link' => site_url('exchanges'), 'page' => lang('exchanges')), array('link' => '#', 'page' => lang('edit_exchanges')));
            $meta = array('page_title' => lang('edit_exchanges'), 'bc' => $bc);
            $this->page_construct('exchanges/edit', $this->data, $meta);

        }
    }

    function view($id = NULL) {

        $this->data['exchange'] = $this->exchanges_model->getExchangeByID($id);
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['page_title'] = lang('view_exchanges');
        $this->load->view($this->theme.'exchanges/view', $this->data);

    }

    function delete($id = NULL) {

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->exchanges_model->deleteExchange($id)) {
            $this->session->set_flashdata('message', lang("exchanges_deleted"));
            redirect('exchanges');
        }
    }    
}
