<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Customer_group extends MY_Controller
{

    function __construct() {
        parent::__construct();


        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('customer_group_model');
    }

    function index() {

        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['customer_group'] = $this->site->getAllCustomerGroup();
        $this->data['page_title'] = lang('customer_group');
        $bc = array(array('link' => '#', 'page' => lang('customer_group')));
        $meta = array('page_title' => lang('customer_group'), 'bc' => $bc);
        $this->page_construct('customer_group/index', $this->data, $meta);

    }

    function get_customer_group() {

        $this->load->library('datatables');
        $this->datatables->select("id, code, name, active");
        $this->datatables->from('customer_group');
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='" . site_url('customer_group/edit/$1') . "' title='" . lang("edit_customer_group") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('customer_group/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_customer_group') . "')\" title='" . lang("delete_customer_group") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();

    }

    function add() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('name', lang('name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'), 'name' => $this->input->post('name'), 'active' => $this->input->post('active'));            
        }

        if ($this->form_validation->run() == true && $this->customer_group_model->addCustomerGroup($data)) {

            $this->session->set_flashdata('message', lang('customer_group_added'));
            redirect("customer_group");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_customer_group');
            $bc = array(array('link' => site_url('customer_group'), 'page' => lang('customer_group')), array('link' => '#', 'page' => lang('add_customer_group')));
            $meta = array('page_title' => lang('add_customer_group'), 'bc' => $bc);
            $this->page_construct('customer_group/add', $this->data, $meta);
        }
    }

    function edit($id = NULL) {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $this->form_validation->set_rules('name', lang('name'), 'required');

        if ($this->form_validation->run() == true) {
            $data = array('code' => $this->input->post('code'), 'name' => $this->input->post('name'), 'active' => $this->input->post('active'));         
        }

        if ($this->form_validation->run() == true && $this->customer_group_model->updateCustomerGroup($id, $data)) {

            $this->session->set_flashdata('message', lang('customer_group_updated'));
            redirect("customer_group");

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['customer_group'] = $this->site->getCustomerGroupByID($id);
            $this->data['page_title'] = lang('new_customer_group');
            $bc = array(array('link' => site_url('customer_group'), 'page' => lang('customer_group')), array('link' => '#', 'page' => lang('edit_customer_group')));
            $meta = array('page_title' => lang('edit_customer_group'), 'bc' => $bc);
            $this->page_construct('customer_group/edit', $this->data, $meta);

        }
    }

    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->customer_group_model->deleteCustomerGroup($id)) {
            $this->session->set_flashdata('message', lang("customer_group_deleted"));
            redirect('customer_group');
        }
    }    
}
