<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/RestController.php';
require APPPATH . '/libraries/Format.php';
use chriskacerguis\RestServer\RestController;

class Api extends RestController {

    function __construct() {
        parent::__construct();
        $this->load->model('sales_model');
    }    

    public function pushbackaba_get() {
        
        header('Content-type: application/json');
        $Data = json_decode(file_get_contents('php://input'), true);
        
        $tran_id = $Data['tran_id'];
        $status = $Data['status']; 
        //$tran_id = $this->get('tran_id');
        //$status = $this->get('status'); 
        
        if ($status == 0) {
            $inv = $this->sales_model->getSaleByID($tran_id);

            $payment = array(
                'date' => date('Y-m-d H:i:s'),
                'sale_id' => $inv->id,
                'customer_id' => $inv->customer_id,
                'reference' => 'Auto from ABA Payway',
                'amount' => $inv->grand_total,
                'paid_by' => 'ABA',
                'created_by' => 1,
                'store_id' => 1,
            );
            if($this->sales_model->addPayment($payment)){
                $this->response($inv, 200);
            }
        } else {
            $this->response('nodata', 404);
        }
    }

    public function pushbackaba_post() {
        
        header('Content-type: application/json');
        $Data = json_decode(file_get_contents('php://input'), true);
        
        $tran_id = $Data['tran_id'];
        $status = $Data['status']; 
        //$tran_id = $this->get('tran_id');
        //$status = $this->get('status'); 
        
        if ($status == 0) {
            $inv = $this->sales_model->getSaleByID($tran_id);

            $payment = array(
                'date' => date('Y-m-d H:i:s'),
                'sale_id' => $inv->id,
                'customer_id' => $inv->customer_id,
                'reference' => 'Auto from ABA Payway',
                'amount' => $inv->grand_total,
                'paid_by' => 'ABA',
                'created_by' => 1,
                'store_id' => 1,
            );
            if($this->sales_model->addPayment($payment)){
                $this->response($inv, 200);
            }
        } else {
            $this->response('nodata', 404);
        }
    }    
    
}
